/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.client;

import javax.annotation.Nullable;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.DynamicTextureCache;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class ScrollingText
implements IGui {
    private float ticksOffset;
    private DynamicTextureCache.DynamicResource dynamicResource;
    private final float availableWidth;
    private final float availableHeight;
    private final int scrollSpeed;
    private final boolean isFullPixel;

    public ScrollingText(float availableWidth, float availableHeight, int scrollSpeed, boolean isFullPixel) {
        this.availableWidth = availableWidth;
        this.availableHeight = availableHeight;
        this.scrollSpeed = scrollSpeed;
        this.isFullPixel = isFullPixel;
    }

    public void changeImage(@Nullable DynamicTextureCache.DynamicResource dynamicResource) {
        if (this.dynamicResource != dynamicResource) {
            this.dynamicResource = dynamicResource;
            this.ticksOffset = InitClient.getGameTick();
        }
    }

    public void scrollText(StoredMatrixTransformations storedMatrixTransformations) {
        if (this.dynamicResource != null) {
            int pixelScale = this.isFullPixel ? 1 : 4;
            float scale = this.availableHeight / (float)this.dynamicResource.height;
            int widthSteps = (int)Math.floor(this.availableWidth / scale / (float)pixelScale);
            int imageSteps = this.dynamicResource.width / pixelScale;
            int totalSteps = widthSteps + imageSteps;
            int step = Math.round((InitClient.getGameTick() - this.ticksOffset) * (float)this.scrollSpeed) % totalSteps;
            float width = Math.min(Math.min(this.availableWidth, (float)this.dynamicResource.width * scale), Math.min((float)(step * pixelScale) * scale, (float)((totalSteps - step) * pixelScale) * scale));
            MainRenderer.scheduleRender(this.dynamicResource.identifier, false, QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                IDrawing.drawTexture(graphicsHolder, (float)Math.max(widthSteps - step, 0) * scale * (float)pixelScale, 0.0f, width, this.availableHeight, Math.max((float)(step - widthSteps) / (float)imageSteps, 0.0f), 0.0f, Math.min((float)step / (float)imageSteps, 1.0f), 1.0f, Direction.UP, -1, GraphicsHolder.getDefaultLight());
                graphicsHolder.pop();
            });
        }
    }
}

