/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.data;

import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.mtr.core.integration.Response;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.core.operation.ArrivalsRequest;
import org.mtr.core.operation.ArrivalsResponse;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.MinecraftServerHelper;
import org.mtr.mod.Init;
import org.mtr.mod.data.ArrivalsCache;

public final class ArrivalsCacheServer
extends ArrivalsCache {
    private long millisOffset = 0L;
    private final World world;
    private static final Object2ObjectAVLTreeMap<String, ArrivalsCacheServer> INSTANCES = new Object2ObjectAVLTreeMap();

    private ArrivalsCacheServer(World world) {
        super(1000);
        this.world = world;
    }

    @Override
    public long getMillisOffset() {
        return this.millisOffset;
    }

    @Override
    protected void requestArrivalsFromServer(LongAVLTreeSet platformIds, Consumer<ObjectList<ArrivalResponse>> callback) {
        Init.sendHttpRequest("operation/arrivals", this.world, Utilities.getJsonObjectFromData(new ArrivalsRequest(new LongImmutableList(platformIds), 10, -1)).toString(), responseString -> {
            Response response = Response.create(Utilities.parseJson(responseString));
            this.millisOffset = response.getCurrentTime() - System.currentTimeMillis();
            callback.accept(response.getData(ArrivalsResponse::new).getArrivals());
        });
    }

    public static ArrivalsCacheServer getInstance(ServerWorld serverWorld) {
        World world = new World((Level)serverWorld.data);
        return INSTANCES.computeIfAbsent(((ResourceLocation)MinecraftServerHelper.getWorldId((World)world).data).toString(), worldId -> new ArrivalsCacheServer(world));
    }

    public static void tickAll() {
        INSTANCES.forEach((worldId, arrivalsCacheServer) -> arrivalsCacheServer.tick());
    }
}

