/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.item;

import javax.annotation.Nonnull;
import org.mtr.core.data.Rail;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.ItemExtension;
import org.mtr.mod.block.BlockNode;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.packet.PacketUpdateLastRailStyles;

public class ItemBrush
extends ItemExtension {
    public ItemBrush(ItemSettings itemSettings) {
        super(itemSettings.maxCount(1));
    }

    @Override
    @Nonnull
    public ActionResult useOnBlock2(ItemUsageContext context) {
        Rail rail;
        World world = context.getWorld();
        PlayerEntity playerEntity = context.getPlayer();
        if (world.isClient() && playerEntity != null && world.getBlockState((BlockPos)context.getBlockPos()).getBlock().data instanceof BlockNode && (rail = MinecraftClientData.getInstance().getFacingRail(false)) != null) {
            return PacketUpdateLastRailStyles.CLIENT_CACHE.canApplyStylesToRail(playerEntity.getUuid(), rail, true) ? ActionResult.SUCCESS : ActionResult.FAIL;
        }
        return super.useOnBlock2(context);
    }
}

