/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import javax.annotation.Nonnull;
import org.mtr.core.integration.Response;
import org.mtr.core.operation.DataRequest;
import org.mtr.core.operation.DataResponse;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.Init;
import org.mtr.mod.QrCodeHelper;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.packet.PacketRequestResponseBase;

public final class PacketRequestData
extends PacketRequestResponseBase {
    private final String tunnelUrl;

    public PacketRequestData(PacketBufferReceiver packetBufferReceiver) {
        super(packetBufferReceiver);
        this.tunnelUrl = packetBufferReceiver.readString();
    }

    public PacketRequestData(DataRequest dataRequest) {
        super(Utilities.getJsonObjectFromData(dataRequest).toString());
        this.tunnelUrl = "";
    }

    private PacketRequestData(String content) {
        super(content);
        this.tunnelUrl = Init.getTunnelUrl();
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        super.write(packetBufferSender);
        packetBufferSender.writeString(this.tunnelUrl);
    }

    @Override
    protected void runClientInbound(Response response) {
        response.getData(jsonReader -> new DataResponse((ReaderBase)jsonReader, MinecraftClientData.getInstance())).write();
        QrCodeHelper.INSTANCE.setServerTunnelUrl(this.tunnelUrl);
    }

    @Override
    protected PacketRequestResponseBase getInstance(String content) {
        return new PacketRequestData(content);
    }

    @Override
    @Nonnull
    protected String getEndpoint() {
        return "operation/get-data";
    }

    @Override
    protected PacketRequestResponseBase.ResponseType responseType() {
        return PacketRequestResponseBase.ResponseType.PLAYER;
    }
}

