/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import javax.annotation.Nonnull;
import org.mtr.core.data.Rail;
import org.mtr.core.data.SignalModification;
import org.mtr.core.integration.Response;
import org.mtr.core.operation.UpdateDataRequest;
import org.mtr.core.operation.UpdateDataResponse;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mod.client.DynamicTextureCache;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.packet.PacketRequestResponseBase;

public final class PacketUpdateData
extends PacketRequestResponseBase {
    public PacketUpdateData(PacketBufferReceiver packetBufferReceiver) {
        super(packetBufferReceiver);
    }

    public PacketUpdateData(UpdateDataRequest updateDataRequest) {
        super(Utilities.getJsonObjectFromData(updateDataRequest).toString());
    }

    private PacketUpdateData(String content) {
        super(content);
    }

    @Override
    protected void runClientInbound(Response response) {
        PacketUpdateData.update(response);
    }

    @Override
    protected PacketRequestResponseBase getInstance(String content) {
        return new PacketUpdateData(content);
    }

    @Override
    @Nonnull
    protected String getEndpoint() {
        return "operation/update-data";
    }

    @Override
    protected PacketRequestResponseBase.ResponseType responseType() {
        return PacketRequestResponseBase.ResponseType.ALL;
    }

    public static void sendDirectlyToServerRail(ServerWorld serverWorld, Rail rail) {
        new PacketUpdateData(new UpdateDataRequest(new MinecraftClientData()).addRail(rail)).runServerOutbound(serverWorld, null);
    }

    public static void sendDirectlyToServerSignalModification(ServerWorld serverWorld, SignalModification signalModification) {
        new PacketUpdateData(new UpdateDataRequest(new MinecraftClientData()).addSignalModification(signalModification)).runServerOutbound(serverWorld, null);
    }

    public static void update(Response response) {
        MinecraftClientData minecraftClientData = MinecraftClientData.getInstance();
        response.getData(jsonReader -> new UpdateDataResponse((ReaderBase)jsonReader, minecraftClientData)).write();
        response.getData(jsonReader -> new UpdateDataResponse((ReaderBase)jsonReader, MinecraftClientData.getDashboardInstance())).write();
        minecraftClientData.vehicles.forEach(vehicle -> vehicle.vehicleExtraData.immutablePath.forEach(pathData -> pathData.writePathCache(minecraftClientData, vehicle.getTransportMode())));
        DynamicTextureCache.instance.reload();
    }
}

