/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import javax.annotation.Nullable;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.block.BlockEyeCandy;

public final class PacketUpdateEyeCandyConfig
extends PacketHandler {
    private final BlockPos blockPos;
    private final String modelId;
    private final float translateX;
    private final float translateY;
    private final float translateZ;
    private final float rotateX;
    private final float rotateY;
    private final float rotateZ;
    private final boolean fullLight;

    public PacketUpdateEyeCandyConfig(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong(packetBufferReceiver.readLong());
        this.modelId = packetBufferReceiver.readString();
        this.translateX = packetBufferReceiver.readFloat();
        this.translateY = packetBufferReceiver.readFloat();
        this.translateZ = packetBufferReceiver.readFloat();
        this.rotateX = packetBufferReceiver.readFloat();
        this.rotateY = packetBufferReceiver.readFloat();
        this.rotateZ = packetBufferReceiver.readFloat();
        this.fullLight = packetBufferReceiver.readBoolean();
    }

    public PacketUpdateEyeCandyConfig(BlockPos blockPos, @Nullable String modelId, float translateX, float translateY, float translateZ, float rotateX, float rotateY, float rotateZ, boolean fullLight) {
        this.blockPos = blockPos;
        this.modelId = modelId == null ? "" : modelId;
        this.translateX = translateX;
        this.translateY = translateY;
        this.translateZ = translateZ;
        this.rotateX = rotateX;
        this.rotateY = rotateY;
        this.rotateZ = rotateZ;
        this.fullLight = fullLight;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeString(this.modelId);
        packetBufferSender.writeFloat(this.translateX);
        packetBufferSender.writeFloat(this.translateY);
        packetBufferSender.writeFloat(this.translateZ);
        packetBufferSender.writeFloat(this.rotateX);
        packetBufferSender.writeFloat(this.rotateY);
        packetBufferSender.writeFloat(this.rotateZ);
        packetBufferSender.writeBoolean(this.fullLight);
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        BlockEntity entity = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos);
        if (entity != null && entity.data instanceof BlockEyeCandy.BlockEntity) {
            ((BlockEyeCandy.BlockEntity)((Object)entity.data)).setData(this.modelId, this.translateX, this.translateY, this.translateZ, this.rotateX, this.rotateY, this.rotateZ, this.fullLight);
        }
    }
}

