/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.mtr.core.data.Data;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.EntityAbstractMapping;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.EntityModelExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ModelPartExtension;
import org.mtr.mapping.mapper.OptimizedModel;
import org.mtr.mod.Init;
import org.mtr.mod.MutableBox;
import org.mtr.mod.ObjectHolder;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.data.VehicleExtension;
import org.mtr.mod.render.StoredMatrixTransformations;
import org.mtr.mod.resource.BlockbenchElement;
import org.mtr.mod.resource.BlockbenchModel;
import org.mtr.mod.resource.BlockbenchOutline;
import org.mtr.mod.resource.GroupTransformations;
import org.mtr.mod.resource.ModelDisplayPart;
import org.mtr.mod.resource.ModelProperties;
import org.mtr.mod.resource.OptimizedModelWrapper;
import org.mtr.mod.resource.PartCondition;
import org.mtr.mod.resource.PositionDefinitions;
import org.mtr.mod.resource.RenderStage;

public final class DynamicVehicleModel
extends EntityModelExtension<EntityAbstractMapping> {
    public final ModelProperties modelProperties;
    private final Identifier texture;
    private final ObjectArraySet<Box> floors = new ObjectArraySet();
    private final ObjectArraySet<Box> doorways = new ObjectArraySet();
    private final Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsForPartConditionAndRenderStage = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsForPartConditionAndRenderStageDoorsClosed = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>> objModelsForPartConditionAndRenderStage = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<PartCondition, Object2ObjectOpenHashMap<RenderStage, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>> objModelsForPartConditionAndRenderStageDoorsClosed = new Object2ObjectOpenHashMap();

    public DynamicVehicleModel(BlockbenchModel blockbenchModel, Identifier texture, ModelProperties modelProperties, PositionDefinitions positionDefinitions, String id) {
        super(blockbenchModel.getTextureWidth(), blockbenchModel.getTextureHeight());
        Object2ObjectOpenHashMap uuidToBlockbenchElement = new Object2ObjectOpenHashMap();
        blockbenchModel.getElements().forEach(blockbenchElement -> uuidToBlockbenchElement.put(blockbenchElement.getUuid(), blockbenchElement));
        Object2ObjectOpenHashMap nameToPart = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap nameToDisplayPart = new Object2ObjectOpenHashMap();
        blockbenchModel.getOutlines().forEach(blockbenchOutline -> {
            ObjectHolder<ModelPartExtension> parentModelPart = new ObjectHolder<ModelPartExtension>(this::createModelPart);
            MutableBox mutableBox = new MutableBox();
            ObjectHolder<ModelDisplayPart> modelDisplayPart = new ObjectHolder<ModelDisplayPart>(ModelDisplayPart::new);
            DynamicVehicleModel.iterateChildren(blockbenchOutline, null, new GroupTransformations(), (uuid, groupTransformations) -> {
                BlockbenchElement blockbenchElement = (BlockbenchElement)uuidToBlockbenchElement.remove(uuid);
                if (blockbenchElement != null) {
                    mutableBox.add(blockbenchElement.setModelPart(((ModelPartExtension)parentModelPart.createAndGet()).addChild(), (GroupTransformations)groupTransformations, (ModelDisplayPart)modelDisplayPart.createAndGet(), (float)modelProperties.getModelYOffset()));
                }
            });
            if (parentModelPart.exists()) {
                nameToPart.put(blockbenchOutline.getName(), new ObjectObjectImmutablePair<ModelPartExtension, MutableBox>(parentModelPart.createAndGet(), mutableBox));
            }
            if (modelDisplayPart.exists()) {
                nameToDisplayPart.put(blockbenchOutline.getName(), modelDisplayPart.createAndGet());
            }
        });
        this.buildModel();
        modelProperties.addPartsIfEmpty((ObjectSet<String>)nameToPart.keySet());
        this.texture = texture;
        this.modelProperties = modelProperties;
        modelProperties.iterateParts(modelPropertiesPart -> modelPropertiesPart.writeCache(texture, nameToPart, nameToDisplayPart, positionDefinitions, this.floors, this.doorways, this.materialGroupsForPartConditionAndRenderStage, this.materialGroupsForPartConditionAndRenderStageDoorsClosed));
        this.testDoors(id);
    }

    public DynamicVehicleModel(Object2ObjectAVLTreeMap<String, OptimizedModel.ObjModel> nameToObjModels, Identifier texture, ModelProperties modelProperties, PositionDefinitions positionDefinitions, String id) {
        super(0, 0);
        this.buildModel();
        modelProperties.addPartsIfEmpty(nameToObjModels.keySet());
        this.texture = texture;
        this.modelProperties = modelProperties;
        modelProperties.iterateParts(modelPropertiesPart -> modelPropertiesPart.writeCache(nameToObjModels, positionDefinitions, this.objModelsForPartConditionAndRenderStage, this.objModelsForPartConditionAndRenderStageDoorsClosed, modelProperties.getModelYOffset()));
        this.testDoors(id);
    }

    @Override
    public void setAngles2(EntityAbstractMapping entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int light, int overlay, float red, float green, float blue, float alpha) {
    }

    public void render(StoredMatrixTransformations storedMatrixTransformations, @Nullable VehicleExtension vehicle, int light, ObjectArrayList<Box> openDoorways) {
        this.modelProperties.iterateParts(modelPropertiesPart -> modelPropertiesPart.render(this.texture, storedMatrixTransformations, vehicle, light, openDoorways));
    }

    public void writeFloorsAndDoorways(ObjectArraySet<Box> floors, ObjectArraySet<Box> doorways, Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsForPartCondition, Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsForPartConditionDoorsClosed, Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>> objModelsForPartCondition, Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>> objModelsForPartConditionDoorsClosed) {
        floors.addAll(this.floors);
        doorways.addAll(this.doorways);
        this.materialGroupsForPartConditionAndRenderStage.forEach((partCondition, materialGroupsForRenderStage) -> Data.put(materialGroupsForPartCondition, partCondition, materialGroupsForRenderStage.values(), ObjectArrayList::new));
        this.materialGroupsForPartConditionAndRenderStageDoorsClosed.forEach((partCondition, materialGroupsForRenderStage) -> Data.put(materialGroupsForPartConditionDoorsClosed, partCondition, materialGroupsForRenderStage.values(), ObjectArrayList::new));
        this.objModelsForPartConditionAndRenderStage.forEach((partCondition, objModelsForRenderStage) -> Data.put(objModelsForPartCondition, partCondition, DynamicVehicleModel.flattenCollection(objModelsForRenderStage.values()), ObjectArrayList::new));
        this.objModelsForPartConditionAndRenderStageDoorsClosed.forEach((partCondition, objModelsForRenderStage) -> Data.put(objModelsForPartConditionDoorsClosed, partCondition, DynamicVehicleModel.flattenCollection(objModelsForRenderStage.values()), ObjectArrayList::new));
        this.materialGroupsForPartConditionAndRenderStage.clear();
        this.materialGroupsForPartConditionAndRenderStageDoorsClosed.clear();
        this.objModelsForPartConditionAndRenderStage.clear();
        this.objModelsForPartConditionAndRenderStageDoorsClosed.clear();
    }

    private void testDoors(String id) {
        long startTime = System.nanoTime();
        ObjectArrayList boxesList = new ObjectArrayList();
        int slices = 5;
        for (int i = 0; i <= 5; ++i) {
            ObjectArrayList boxes = new ObjectArrayList();
            double time = (double)i / 5.0;
            this.modelProperties.iterateParts(modelPropertiesPart -> modelPropertiesPart.getOpenDoorBounds(boxes, time));
            boxesList.add(boxes);
        }
        int count = ((ObjectArrayList)boxesList.get(0)).size();
        for (int i = 0; i < count; ++i) {
            for (int j = i + 1; j < count; ++j) {
                if (((Box)((ObjectArrayList)boxesList.get(0)).get(i)).intersects((Box)((ObjectArrayList)boxesList.get(0)).get(j))) continue;
                for (int k = 1; k <= 5; ++k) {
                    if (!((Box)((ObjectArrayList)boxesList.get(k)).get(i)).intersects((Box)((ObjectArrayList)boxesList.get(k)).get(j))) continue;
                    Init.LOGGER.warn("Vehicle doors overlapping! Door X and Z multipliers were probably set incorrectly ({})", (Object)id);
                    return;
                }
            }
        }
        CustomResourceLoader.incrementTestDuration(System.nanoTime() - startTime);
    }

    private static void iterateChildren(BlockbenchOutline blockbenchOutline, @Nullable BlockbenchOutline previousBlockbenchOutline, GroupTransformations groupTransformations, BiConsumer<String, GroupTransformations> consumer) {
        GroupTransformations newGroupTransformations = blockbenchOutline.add(groupTransformations, previousBlockbenchOutline);
        blockbenchOutline.childrenUuid.forEach(uuid -> consumer.accept((String)uuid, newGroupTransformations));
        blockbenchOutline.getChildren().forEach(childOutline -> DynamicVehicleModel.iterateChildren(childOutline, blockbenchOutline, groupTransformations, consumer));
    }

    private static <T> ObjectArrayList<T> flattenCollection(ObjectCollection<? extends ObjectCollection<T>> collection) {
        ObjectArrayList combinedList = new ObjectArrayList();
        collection.forEach(combinedList::addAll);
        return combinedList;
    }
}

