/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntityAbstractMapping;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.EntityAbstractMapping;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.EntityModelExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ModelPartExtension;
import org.mtr.mod.block.BlockAPGGlass;
import org.mtr.mod.block.BlockAPGGlassEnd;
import org.mtr.mod.block.BlockPSDAPGDoorBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.block.TripleHorizontalBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderPSDAPGDoor<T extends BlockPSDAPGDoorBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements IGui,
IBlock {
    private final int type;
    private static final ModelSingleCube MODEL_PSD = new ModelSingleCube(36, 18, 0, 0, 0, 16, 16, 2);
    private static final ModelSingleCube MODEL_PSD_END_LEFT_1 = new ModelSingleCube(20, 18, 0, 0, 0, 8, 16, 2);
    private static final ModelSingleCube MODEL_PSD_END_RIGHT_1 = new ModelSingleCube(20, 18, 8, 0, 0, 8, 16, 2);
    private static final ModelSingleCube MODEL_PSD_END_LEFT_2 = new ModelSingleCube(20, 18, 8, 0, 2, 8, 16, 2);
    private static final ModelSingleCube MODEL_PSD_END_RIGHT_2 = new ModelSingleCube(20, 18, 0, 0, 2, 8, 16, 2);
    private static final ModelSingleCube MODEL_PSD_LIGHT_LEFT = new ModelSingleCube(16, 16, 0, -1, 5, 1, 1, 1);
    private static final ModelSingleCube MODEL_PSD_LIGHT_RIGHT = new ModelSingleCube(16, 16, 15, -1, 5, 1, 1, 1);
    private static final ModelSingleCube MODEL_APG_TOP = new ModelSingleCube(34, 9, 0, 8, 1, 16, 8, 1);
    private static final ModelAPGDoorBottom MODEL_APG_BOTTOM = new ModelAPGDoorBottom();
    private static final ModelAPGDoorLight MODEL_APG_LIGHT = new ModelAPGDoorLight();
    private static final ModelSingleCube MODEL_APG_DOOR_LOCKED = new ModelSingleCube(6, 6, 5, 10, 1, 6, 6, 0);
    private static final ModelSingleCube MODEL_PSD_DOOR_LOCKED = new ModelSingleCube(6, 6, 5, 6, 1, 6, 6, 0);
    private static final ModelSingleCube MODEL_LIFT_LEFT = new ModelSingleCube(28, 18, 0, 0, 0, 12, 16, 2);
    private static final ModelSingleCube MODEL_LIFT_RIGHT = new ModelSingleCube(28, 18, 4, 0, 0, 12, 16, 2);

    public RenderPSDAPGDoor(BlockEntityRenderer.Argument dispatcher, int type) {
        super(dispatcher);
        this.type = type;
    }

    @Override
    public void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = ((BlockEntityAbstractMapping)((Object)entity)).getWorld2();
        if (world == null) {
            return;
        }
        BlockPos blockPos = ((BlockEntityAbstractMapping)((Object)entity)).getPos2();
        Direction facing = IBlock.getStatePropertySafe(world, blockPos, BlockPSDAPGDoorBase.FACING);
        boolean side = IBlock.getStatePropertySafe(world, blockPos, BlockPSDAPGDoorBase.SIDE) == IBlock.EnumSide.RIGHT;
        boolean half = IBlock.getStatePropertySafe(world, blockPos, BlockPSDAPGDoorBase.HALF) == IBlock.DoubleBlockHalf.UPPER;
        boolean end = IBlock.getStatePropertySafe(world, blockPos, BlockPSDAPGDoorBase.END);
        boolean unlocked = IBlock.getStatePropertySafe(world, blockPos, BlockPSDAPGDoorBase.UNLOCKED);
        double open = Math.min(((BlockPSDAPGDoorBase.BlockEntityBase)entity).getDoorValue(), this.type >= 3 ? 0.75 : 1.0);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)((BlockEntityAbstractMapping)((Object)entity)).getPos2().getX(), ((BlockEntityAbstractMapping)((Object)entity)).getPos2().getY(), 0.5 + (double)((BlockEntityAbstractMapping)((Object)entity)).getPos2().getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.rotateYDegrees(-facing.asRotation());
            graphicsHolderNew.rotateXDegrees(180.0f);
        });
        StoredMatrixTransformations storedMatrixTransformationsLight = storedMatrixTransformations.copy();
        switch (this.type) {
            case 0: 
            case 1: {
                if (half) {
                    MainRenderer.scheduleRender(new Identifier(String.format("mtr:textures/block/light_%s.png", open > 0.0 ? "on" : "off")), false, open > 0.0 ? QueuedRenderLayer.LIGHT : QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                        storedMatrixTransformationsLight.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                        (side ? MODEL_PSD_LIGHT_RIGHT : MODEL_PSD_LIGHT_LEFT).render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                        graphicsHolderNew.pop();
                    });
                }
                if (!end) break;
                MainRenderer.scheduleRender(new Identifier(String.format("mtr:textures/block/psd_door_end_%s_%s_2_%s.png", half ? "top" : "bottom", side ? "right" : "left", this.type == 1 ? "2" : "1")), false, QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformationsLight.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                    graphicsHolderNew.translate(open / 2.0 * (double)(side ? -1 : 1), 0.0, 0.0);
                    (side ? MODEL_PSD_END_RIGHT_2 : MODEL_PSD_END_LEFT_2).render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
                break;
            }
            case 2: {
                if (!half) break;
                Block block = world.getBlockState(blockPos.offset(side ? facing.rotateYClockwise() : facing.rotateYCounterclockwise())).getBlock();
                if (!(block.data instanceof BlockAPGGlass) && !(block.data instanceof BlockAPGGlassEnd)) break;
                MainRenderer.scheduleRender(new Identifier(String.format("mtr:textures/block/apg_door_light_%s.png", open > 0.0 ? "on" : "off")), false, open > 0.0 ? QueuedRenderLayer.LIGHT_TRANSLUCENT : QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformationsLight.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                    graphicsHolderNew.translate(side ? -0.515625 : 0.515625, 0.0, 0.0);
                    graphicsHolderNew.scale(0.5f, 1.0f, 1.0f);
                    MODEL_APG_LIGHT.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
            }
        }
        storedMatrixTransformations.add(matricesNew -> matricesNew.translate(open * (double)(side ? -1 : 1), 0.0, 0.0));
        switch (this.type) {
            case 0: 
            case 1: {
                if (end) {
                    MainRenderer.scheduleRender(new Identifier(String.format("mtr:textures/block/psd_door_end_%s_%s_1_%s.png", half ? "top" : "bottom", side ? "right" : "left", this.type == 1 ? "2" : "1")), false, QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                        storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                        (side ? MODEL_PSD_END_RIGHT_1 : MODEL_PSD_END_LEFT_1).render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                        graphicsHolderNew.pop();
                    });
                } else {
                    MainRenderer.scheduleRender(new Identifier(String.format("mtr:textures/block/psd_door_%s_%s_%s.png", half ? "top" : "bottom", side ? "right" : "left", this.type == 1 ? "2" : "1")), false, QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                        storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                        MODEL_PSD.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                        graphicsHolderNew.pop();
                    });
                }
                if (!half || unlocked) break;
                MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/sign/door_not_in_use.png"), false, QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                    if (end) {
                        graphicsHolderNew.translate(side ? 0.25 : -0.25, 0.0, 0.0);
                    }
                    MODEL_PSD_DOOR_LOCKED.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
                break;
            }
            case 2: {
                MainRenderer.scheduleRender(new Identifier(String.format("mtr:textures/block/apg_door_%s_%s.png", half ? "top" : "bottom", side ? "right" : "left")), false, QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                    (half ? MODEL_APG_TOP : MODEL_APG_BOTTOM).render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
                if (!half || unlocked) break;
                MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/sign/door_not_in_use.png"), false, QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                    MODEL_APG_DOOR_LOCKED.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
                break;
            }
            case 4: {
                if (IBlock.getStatePropertySafe(world, blockPos, TripleHorizontalBlock.CENTER)) break;
                storedMatrixTransformations.add(matricesNew -> matricesNew.translate(side ? 0.5 : -0.5, 0.0, 0.0));
            }
            case 3: {
                MainRenderer.scheduleRender(new Identifier(String.format("mtr:textures/block/lift_door_%s_%s_1.png", half ? "top" : "bottom", side ? "right" : "left")), false, QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                    (side ? MODEL_LIFT_RIGHT : MODEL_LIFT_LEFT).render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
                if (!half || unlocked) break;
                MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/sign/door_not_in_use.png"), false, QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                    graphicsHolderNew.translate(side ? 0.125 : -0.125, 0.0, 0.0);
                    MODEL_PSD_DOOR_LOCKED.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
            }
        }
    }

    @Override
    public boolean rendersOutsideBoundingBox2(T blockEntity) {
        return true;
    }

    private static class ModelSingleCube
    extends EntityModelExtension<EntityAbstractMapping> {
        private final ModelPartExtension cube = this.createModelPart();

        private ModelSingleCube(int textureWidth, int textureHeight, int x, int y, int z, int length, int height, int depth) {
            super(textureWidth, textureHeight);
            this.cube.setTextureUVOffset(0, 0).addCuboid(x - 8, y - 16, z - 8, length, height, depth, 0.0f, false);
            this.buildModel();
        }

        @Override
        public void render(GraphicsHolder graphicsHolder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.cube.render(graphicsHolder, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        }

        @Override
        public void setAngles2(EntityAbstractMapping entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        }
    }

    private static class ModelAPGDoorBottom
    extends EntityModelExtension<EntityAbstractMapping> {
        private final ModelPartExtension bone = this.createModelPart();

        private ModelAPGDoorBottom() {
            super(34, 27);
            this.bone.setTextureUVOffset(0, 0).addCuboid(-8.0f, -16.0f, -7.0f, 16, 16, 1, 0.0f, false);
            this.bone.setTextureUVOffset(0, 17).addCuboid(-8.0f, -6.0f, -8.0f, 16, 6, 1, 0.0f, false);
            ModelPartExtension cube = this.bone.addChild();
            cube.setPivot(0.0f, -6.0f, -8.0f);
            cube.setRotation(-0.7854f, 0.0f, 0.0f);
            cube.setTextureUVOffset(0, 24).addCuboid(-8.0f, -2.0f, 0.0f, 16, 2, 1, 0.0f, false);
            this.buildModel();
        }

        @Override
        public void render(GraphicsHolder graphicsHolder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.bone.render(graphicsHolder, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        }

        @Override
        public void setAngles2(EntityAbstractMapping entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        }
    }

    private static class ModelAPGDoorLight
    extends EntityModelExtension<EntityAbstractMapping> {
        private final ModelPartExtension bone = this.createModelPart();

        private ModelAPGDoorLight() {
            super(8, 8);
            this.bone.setTextureUVOffset(0, 4).addCuboid(-0.5f, -9.0f, -7.0f, 1, 1, 3, 0.05f, false);
            ModelPartExtension cube = this.bone.addChild();
            cube.setPivot(0.0f, -9.05f, -4.95f);
            cube.setRotation(0.3927f, 0.0f, 0.0f);
            cube.setTextureUVOffset(0, 0).addCuboid(-0.5f, 0.05f, -3.05f, 1, 1, 3, 0.05f, false);
            this.buildModel();
        }

        @Override
        public void render(GraphicsHolder graphicsHolder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.bone.render(graphicsHolder, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        }

        @Override
        public void setAngles2(EntityAbstractMapping entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        }
    }
}

