/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.block.BlockPSDAPGDoorBase;
import org.mtr.mod.block.BlockPSDAPGGlassEndBase;
import org.mtr.mod.block.BlockPSDTop;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.DynamicTextureCache;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderRouteBase;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderPSDTop
extends RenderRouteBase<BlockPSDTop.BlockEntity> {
    private static final float END_FRONT_OFFSET = 1.0f / (MathHelper.getSquareRootOfTwoMapped() * 16.0f);
    private static final float BOTTOM_DIAGONAL_OFFSET = ((float)Math.sqrt(3.0) - 1.0f) / 32.0f;
    private static final float ROOT_TWO_SCALED = MathHelper.getSquareRootOfTwoMapped() / 16.0f;
    private static final float BOTTOM_END_DIAGONAL_OFFSET = END_FRONT_OFFSET - BOTTOM_DIAGONAL_OFFSET / MathHelper.getSquareRootOfTwoMapped();
    private static final float COLOR_STRIP_START = 0.90625f;
    private static final float COLOR_STRIP_END = 0.9375f;

    public RenderPSDTop(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher, 1.95f, 7.5f, 1.5f, 0.125f, true, 3, BlockPSDTop.ARROW_DIRECTION);
    }

    @Override
    protected RenderRouteBase.RenderType getRenderType(World world, BlockPos pos, BlockState state) {
        BlockPSDTop.EnumPersistent persistent = IBlock.getStatePropertySafe(state, BlockPSDTop.PERSISTENT);
        if (persistent == BlockPSDTop.EnumPersistent.NONE) {
            Block blockBelow = world.getBlockState(pos.down()).getBlock();
            if (blockBelow.data instanceof BlockPSDAPGDoorBase) {
                return RenderRouteBase.RenderType.ARROW;
            }
            if (!(blockBelow.data instanceof BlockPSDAPGGlassEndBase)) {
                return RenderRouteBase.RenderType.ROUTE;
            }
            return RenderRouteBase.RenderType.NONE;
        }
        return persistent == BlockPSDTop.EnumPersistent.ARROW ? RenderRouteBase.RenderType.ARROW : (persistent == BlockPSDTop.EnumPersistent.ROUTE ? RenderRouteBase.RenderType.ROUTE : RenderRouteBase.RenderType.NONE);
    }

    @Override
    protected void renderAdditionalUnmodified(StoredMatrixTransformations storedMatrixTransformations, BlockState state, Direction facing, int light) {
        boolean persistent;
        boolean airLeft = IBlock.getStatePropertySafe(state, BlockPSDTop.AIR_LEFT);
        boolean airRight = IBlock.getStatePropertySafe(state, BlockPSDTop.AIR_RIGHT);
        boolean bl = persistent = IBlock.getStatePropertySafe(state, BlockPSDTop.PERSISTENT) != BlockPSDTop.EnumPersistent.NONE;
        if (!airLeft && !airRight || persistent) {
            return;
        }
        MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/psd_top.png"), false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
            storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
            if (airLeft) {
                IDrawing.drawTexture(graphicsHolder, -0.125f, 0.0f, 0.5f, 0.5f, 0.0f, -0.125f, 0.5f, 1.0f, -0.125f, -0.125f, 1.0f, 0.5f, 0.0f, 0.0f, 1.0f, 1.0f, facing, -1, light);
                IDrawing.drawTexture(graphicsHolder, 0.5f - END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, -0.25f - END_FRONT_OFFSET, 0.0625f, 0.25f - END_FRONT_OFFSET, -0.25f - END_FRONT_OFFSET, 1.0f, 0.25f - END_FRONT_OFFSET, 0.5f - END_FRONT_OFFSET, 1.0f, -0.5f - END_FRONT_OFFSET, 0.0f, 0.0f, 1.0f, 0.9375f, facing.getOpposite(), -1, light);
                IDrawing.drawTexture(graphicsHolder, 0.5f - BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, -0.5f - BOTTOM_END_DIAGONAL_OFFSET, -0.25f - BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, 0.25f - BOTTOM_END_DIAGONAL_OFFSET, -0.25f - END_FRONT_OFFSET, 0.0625f, 0.25f - END_FRONT_OFFSET, 0.5f - END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, 0.0f, 0.9375f, 1.0f, 0.96875f, facing.getOpposite(), -1, light);
                IDrawing.drawTexture(graphicsHolder, 0.5f, 0.0f, -0.5f, -0.25f, 0.0f, 0.25f, -0.25f - BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, 0.25f - BOTTOM_END_DIAGONAL_OFFSET, 0.5f - BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, -0.5f - BOTTOM_END_DIAGONAL_OFFSET, 0.0f, 0.96875f, 1.0f, 1.0f, facing.getOpposite(), -1, light);
                IDrawing.drawTexture(graphicsHolder, 0.5f, 0.003125f, -0.125f, -0.125f, 0.003125f, 0.5f, -0.125f, 0.003125f, 0.125f, 0.5f, 0.003125f, -0.5f, 0.125f, 0.125f, 0.1875f, 0.1875f, facing, -1, light);
                IDrawing.drawTexture(graphicsHolder, 0.5f, 0.996875f, -0.5f, -0.125f, 0.996875f, 0.125f, -0.125f, 0.996875f, 0.5f, 0.5f, 0.996875f, -0.125f, 0.125f, 0.125f, 0.1875f, 0.1875f, Direction.UP, -1, light);
                IDrawing.drawTexture(graphicsHolder, 0.5f - END_FRONT_OFFSET, 0.996875f, -0.5f - END_FRONT_OFFSET, -0.125f - ROOT_TWO_SCALED, 0.996875f, 0.125f, -0.125f, 0.996875f, 0.125f, 0.5f, 0.996875f, -0.5f, 0.125f, 0.125f, 0.1875f, 0.1875f, Direction.UP, -1, light);
                IDrawing.drawTexture(graphicsHolder, 0.5f, 0.0625f, -0.5f, 0.5f - END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, 0.5f - END_FRONT_OFFSET, 1.0f, -0.5f - END_FRONT_OFFSET, 0.5f, 1.0f, -0.5f, 0.9375f, 0.0f, 1.0f, 0.9375f, facing, -1, light);
                IDrawing.drawTexture(graphicsHolder, 0.5f, 0.0f, -0.5f, 0.5f - BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, -0.5f - BOTTOM_END_DIAGONAL_OFFSET, 0.5f - END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, 0.5f, 0.0625f, -0.5f, 0.9375f, 0.9375f, 1.0f, 1.0f, facing, -1, light);
            }
            if (airRight) {
                IDrawing.drawTexture(graphicsHolder, -0.5f, 0.0f, -0.125f, 0.125f, 0.0f, 0.5f, 0.125f, 1.0f, 0.5f, -0.5f, 1.0f, -0.125f, 0.0f, 0.0f, 1.0f, 1.0f, facing, -1, light);
                IDrawing.drawTexture(graphicsHolder, 0.25f + END_FRONT_OFFSET, 0.0625f, 0.25f - END_FRONT_OFFSET, -0.5f + END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, -0.5f + END_FRONT_OFFSET, 1.0f, -0.5f - END_FRONT_OFFSET, 0.25f + END_FRONT_OFFSET, 1.0f, 0.25f - END_FRONT_OFFSET, 0.0f, 0.0f, 1.0f, 0.9375f, facing.getOpposite(), -1, light);
                IDrawing.drawTexture(graphicsHolder, 0.25f + BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, 0.25f - BOTTOM_END_DIAGONAL_OFFSET, -0.5f + BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, -0.5f - BOTTOM_END_DIAGONAL_OFFSET, -0.5f + END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, 0.25f + END_FRONT_OFFSET, 0.0625f, 0.25f - END_FRONT_OFFSET, 0.0f, 0.9375f, 1.0f, 0.96875f, facing.getOpposite(), -1, light);
                IDrawing.drawTexture(graphicsHolder, 0.25f, 0.0f, 0.25f, -0.5f, 0.0f, -0.5f, -0.5f + BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, -0.5f - BOTTOM_END_DIAGONAL_OFFSET, 0.25f + BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, 0.25f - BOTTOM_END_DIAGONAL_OFFSET, 0.0f, 0.96875f, 1.0f, 1.0f, facing.getOpposite(), -1, light);
                IDrawing.drawTexture(graphicsHolder, 0.125f, 0.003125f, 0.5f, -0.5f, 0.003125f, -0.125f, -0.5f, 0.003125f, -0.5f, 0.125f, 0.003125f, 0.125f, 0.125f, 0.125f, 0.1875f, 0.1875f, facing, -1, light);
                IDrawing.drawTexture(graphicsHolder, 0.125f, 0.996875f, 0.125f, -0.5f, 0.996875f, -0.5f, -0.5f, 0.996875f, -0.125f, 0.125f, 0.996875f, 0.5f, 0.125f, 0.125f, 0.1875f, 0.1875f, Direction.UP, -1, light);
                IDrawing.drawTexture(graphicsHolder, 0.125f + ROOT_TWO_SCALED, 0.996875f, 0.125f, -0.5f + END_FRONT_OFFSET, 0.996875f, -0.5f - END_FRONT_OFFSET, -0.5f, 0.996875f, -0.5f, 0.125f, 0.996875f, 0.125f, 0.125f, 0.125f, 0.1875f, 0.1875f, Direction.UP, -1, light);
                IDrawing.drawTexture(graphicsHolder, -0.5f + END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, -0.5f, 0.0625f, -0.5f, -0.5f, 1.0f, -0.5f, -0.5f + END_FRONT_OFFSET, 1.0f, -0.5f - END_FRONT_OFFSET, 0.0f, 0.0f, 0.0625f, 0.9375f, facing, -1, light);
                IDrawing.drawTexture(graphicsHolder, -0.5f + BOTTOM_END_DIAGONAL_OFFSET, BOTTOM_DIAGONAL_OFFSET, -0.5f - BOTTOM_END_DIAGONAL_OFFSET, -0.5f, 0.0f, -0.5f, -0.5f, 0.0625f, -0.5f, -0.5f + END_FRONT_OFFSET, 0.0625f, -0.5f - END_FRONT_OFFSET, 0.0f, 0.9375f, 0.0625f, 1.0f, facing, -1, light);
            }
            graphicsHolder.pop();
        });
    }

    @Override
    protected void renderAdditional(StoredMatrixTransformations storedMatrixTransformations, long platformId, BlockState state, int leftBlocks, int rightBlocks, Direction facing, int color, int light) {
        boolean isNotPersistent = IBlock.getStatePropertySafe(state, BlockPSDTop.PERSISTENT) == BlockPSDTop.EnumPersistent.NONE;
        boolean airLeft = isNotPersistent && IBlock.getStatePropertySafe(state, BlockPSDTop.AIR_LEFT);
        boolean airRight = isNotPersistent && IBlock.getStatePropertySafe(state, BlockPSDTop.AIR_RIGHT);
        MainRenderer.scheduleRender(DynamicTextureCache.instance.getColorStrip((long)platformId).identifier, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
            storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
            IDrawing.drawTexture(graphicsHolder, airLeft ? 0.625f : 0.0f, 0.90625f, 0.0f, airRight ? 0.375f : 1.0f, 0.9375f, 0.0f, facing, color, light);
            if (airLeft) {
                IDrawing.drawTexture(graphicsHolder, END_FRONT_OFFSET, 0.90625f, -0.625f - END_FRONT_OFFSET, 0.75f + END_FRONT_OFFSET, 0.9375f, 0.125f - END_FRONT_OFFSET, facing, -1, light);
            }
            if (airRight) {
                IDrawing.drawTexture(graphicsHolder, 0.25f - END_FRONT_OFFSET, 0.90625f, 0.125f - END_FRONT_OFFSET, 1.0f - END_FRONT_OFFSET, 0.9375f, -0.625f - END_FRONT_OFFSET, facing, -1, light);
            }
            graphicsHolder.pop();
        });
    }

    @Override
    protected float getAdditionalOffset(BlockState state) {
        return IBlock.getStatePropertySafe(state, BlockPSDTop.PERSISTENT) == BlockPSDTop.EnumPersistent.NONE ? 0.0f : 0.46875f;
    }
}

