/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.mtr.core.data.NameColorDataBase;
import org.mtr.core.data.Station;
import org.mtr.core.data.StationExit;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntObjectImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockEntityAbstractMapping;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.QrCodeHelper;
import org.mtr.mod.block.BlockRailwaySign;
import org.mtr.mod.block.BlockStationNameBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.DynamicTextureCache;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import org.mtr.mod.resource.SignResource;
import org.mtr.mod.screen.EditStationScreen;

public class RenderRailwaySign<T extends BlockRailwaySign.BlockEntity>
extends BlockEntityRenderer<T>
implements IBlock,
IGui,
IDrawing {
    public RenderRailwaySign(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    @Override
    public void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = ((BlockEntityAbstractMapping)((Object)entity)).getWorld2();
        if (world == null) {
            return;
        }
        BlockPos pos = ((BlockEntityAbstractMapping)((Object)entity)).getPos2();
        BlockState state = world.getBlockState(pos);
        if (!(state.getBlock().data instanceof BlockRailwaySign)) {
            return;
        }
        BlockRailwaySign block = (BlockRailwaySign)state.getBlock().data;
        if (((BlockRailwaySign.BlockEntity)((Object)entity)).getSignIds().length != block.length) {
            return;
        }
        Direction facing = IBlock.getStatePropertySafe(state, BlockStationNameBase.FACING);
        String[] signIds = ((BlockRailwaySign.BlockEntity)((Object)entity)).getSignIds();
        boolean renderBackground = false;
        int backgroundColor = 0;
        for (String signId : signIds) {
            SignResource sign;
            if (signId == null || (sign = RenderRailwaySign.getSign(signId)) == null) continue;
            renderBackground = true;
            if (sign.getBackgroundColor() == 0) continue;
            backgroundColor = sign.getBackgroundColor();
            break;
        }
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)((BlockEntityAbstractMapping)((Object)entity)).getPos2().getX(), 0.53125 + (double)((BlockEntityAbstractMapping)((Object)entity)).getPos2().getY(), 0.5 + (double)((BlockEntityAbstractMapping)((Object)entity)).getPos2().getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.rotateYDegrees(-facing.asRotation());
            graphicsHolderNew.rotateZDegrees(180.0f);
            graphicsHolderNew.translate((double)((float)block.getXStart() / 16.0f) - 0.5, 0.0, -0.06875000009313226);
        });
        graphicsHolder.push();
        graphicsHolder.translate(0.5, 0.53125, 0.5);
        graphicsHolder.rotateYDegrees(-facing.asRotation());
        graphicsHolder.rotateZDegrees(180.0f);
        graphicsHolder.translate((double)((float)block.getXStart() / 16.0f) - 0.5, 0.0, -0.06875000009313226);
        if (renderBackground) {
            int newBackgroundColor = backgroundColor | 0xFF000000;
            MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/white.png"), false, QueuedRenderLayer.LIGHT, (graphicsHolderNew, offset) -> {
                storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                IDrawing.drawTexture(graphicsHolderNew, 0.0f, 0.0f, 0.003125f, 0.5f * (float)signIds.length, 0.5f, 0.003125f, facing, newBackgroundColor, GraphicsHolder.getDefaultLight());
                graphicsHolderNew.pop();
            });
        }
        for (int i = 0; i < signIds.length; ++i) {
            if (signIds[i] == null) continue;
            RenderRailwaySign.drawSign(graphicsHolder, storedMatrixTransformations, pos, signIds[i], 0.5f * (float)i, 0.0f, 0.5f, RenderRailwaySign.getMaxWidth(signIds, i, false), RenderRailwaySign.getMaxWidth(signIds, i, true), ((BlockRailwaySign.BlockEntity)((Object)entity)).getSelectedIds(), facing, backgroundColor | 0xFF000000, (textureId, x, y, size, flipTexture) -> MainRenderer.scheduleRender(textureId, true, QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolderNew, offset) -> {
                storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                IDrawing.drawTexture(graphicsHolderNew, x, y, size, size, flipTexture ? 1.0f : 0.0f, 0.0f, flipTexture ? 0.0f : 1.0f, 1.0f, facing, -1, GraphicsHolder.getDefaultLight());
                graphicsHolderNew.pop();
            }));
        }
        graphicsHolder.pop();
    }

    public static void drawSign(GraphicsHolder graphicsHolder, @Nullable StoredMatrixTransformations storedMatrixTransformations, BlockPos pos, String signId, float x, float y, float size, float maxWidthLeft, float maxWidthRight, LongAVLTreeSet selectedIds, Direction facing, int backgroundColor, DrawTexture drawTexture) {
        boolean isTransportSystemMap;
        SignResource sign = RenderRailwaySign.getSign(signId);
        if (sign == null) {
            return;
        }
        float signSize = (sign.getSmall() ? 0.75f : 1.0f) * size;
        float margin = (size - signSize) / 2.0f;
        boolean hasCustomText = sign.hasCustomText;
        boolean flipCustomText = sign.getFlipCustomText();
        boolean flipTexture = sign.getFlipTexture();
        boolean isExit = signId.equals("exit_letter") || signId.equals("exit_letter_flipped");
        boolean isLine = signId.equals("line") || signId.equals("line_flipped");
        boolean isPlatform = signId.equals("platform") || signId.equals("platform_flipped");
        boolean isStation = signId.equals("station") || signId.equals("station_flipped");
        boolean bl = isTransportSystemMap = signId.equals("transport_system_map") || signId.equals("transport_system_map_text") || signId.equals("transport_system_map_text_flipped");
        if (storedMatrixTransformations != null && isExit) {
            Station station = InitClient.findStation(pos);
            if (station == null) {
                return;
            }
            ObjectArrayList selectedExitsSorted = new ObjectArrayList();
            ObjectArrayList<StationExit> exits = EditStationScreen.getStationExits(station, true);
            exits.forEach(exit -> {
                if (selectedIds.longStream().anyMatch(selectedId -> EditStationScreen.deserializeExit(selectedId).equals(exit.getName()))) {
                    selectedExitsSorted.add(exit);
                }
            });
            graphicsHolder.push();
            graphicsHolder.translate(x + margin + (flipCustomText ? signSize : 0.0f), y + margin, 0.0);
            float maxWidth = ((flipCustomText ? maxWidthLeft : maxWidthRight) + 1.0f) * size - margin * 2.0f;
            float exitWidth = signSize * (float)selectedExitsSorted.size();
            graphicsHolder.scale(Math.min(1.0f, maxWidth / exitWidth), 1.0f, 1.0f);
            for (int i = 0; i < selectedExitsSorted.size(); ++i) {
                StationExit stationExit = (StationExit)selectedExitsSorted.get(flipCustomText ? selectedExitsSorted.size() - i - 1 : i);
                float signOffset = (float)(flipCustomText ? -1 : 1) * signSize * (float)i - (flipCustomText ? signSize : 0.0f);
                MainRenderer.scheduleRender(DynamicTextureCache.instance.getExitSignLetter((String)stationExit.getName().substring((int)0, (int)1), (String)stationExit.getName().substring((int)1), (int)backgroundColor).identifier, true, QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                    graphicsHolderNew.translate(x + margin + (flipCustomText ? signSize : 0.0f), y + margin, 0.0);
                    graphicsHolderNew.scale(Math.min(1.0f, maxWidth / exitWidth), 1.0f, 1.0f);
                    IDrawing.drawTexture(graphicsHolderNew, signOffset, 0.0f, signSize, signSize, facing, GraphicsHolder.getDefaultLight());
                    graphicsHolderNew.pop();
                });
                if (!(maxWidth > exitWidth) || selectedExitsSorted.size() != 1 || stationExit.getDestinations().isEmpty()) continue;
                RenderRailwaySign.renderCustomText(stationExit.getDestinations().get(0), storedMatrixTransformations, facing, size, flipCustomText ? x : x + size, flipCustomText, maxWidth - exitWidth - margin * 2.0f, backgroundColor);
            }
            graphicsHolder.pop();
        } else if (storedMatrixTransformations != null && isLine) {
            Station station = InitClient.findStation(pos);
            if (station == null) {
                return;
            }
            LongAVLTreeSet platformIds = new LongAVLTreeSet();
            station.savedRails.forEach(platform -> platformIds.add(platform.getId()));
            station.connectedStations.forEach(connectingStation -> connectingStation.savedRails.forEach(platform -> platformIds.add(platform.getId())));
            ObjectArrayList<IntObjectImmutablePair> selectedRoutesSorted = new ObjectArrayList<IntObjectImmutablePair>();
            IntAVLTreeSet addedColors = new IntAVLTreeSet();
            MinecraftClientData.getInstance().simplifiedRoutes.forEach(simplifiedRoute -> {
                int color = simplifiedRoute.getColor();
                if (!addedColors.contains(color) && selectedIds.contains(color) && simplifiedRoute.getPlatforms().stream().anyMatch(simplifiedRoutePlatform -> platformIds.contains(simplifiedRoutePlatform.getPlatformId()))) {
                    selectedRoutesSorted.add(new IntObjectImmutablePair<String>(color, simplifiedRoute.getName().split("\\|\\|")[0]));
                    addedColors.add(color);
                }
            });
            selectedRoutesSorted.sort(Comparator.comparingInt(IntObjectImmutablePair::leftInt));
            float maxWidth = Math.max(0.0f, ((flipCustomText ? maxWidthLeft : maxWidthRight) + 1.0f) * size - margin * 2.0f);
            float height = size - margin * 2.0f;
            ArrayList<DynamicTextureCache.DynamicResource> resourceLocationDataList = new ArrayList<DynamicTextureCache.DynamicResource>();
            float totalTextWidth = 0.0f;
            for (IntObjectImmutablePair route : selectedRoutesSorted) {
                DynamicTextureCache.DynamicResource resourceLocationData = DynamicTextureCache.instance.getRouteSquare(route.leftInt(), (String)route.right(), flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT);
                resourceLocationDataList.add(resourceLocationData);
                totalTextWidth += height * (float)resourceLocationData.width / (float)resourceLocationData.height + margin / 2.0f;
            }
            StoredMatrixTransformations storedMatrixTransformations2 = storedMatrixTransformations.copy();
            storedMatrixTransformations2.add(graphicsHolderNew -> graphicsHolderNew.translate(flipCustomText ? (double)(x + size - margin) : (double)(x + margin), 0.0, 0.0));
            if (totalTextWidth > margin / 2.0f) {
                totalTextWidth -= margin / 2.0f;
            }
            if (totalTextWidth > maxWidth) {
                float finalTotalTextWidth = totalTextWidth;
                storedMatrixTransformations2.add(graphicsHolderNew -> graphicsHolderNew.scale(maxWidth / finalTotalTextWidth, 1.0f, 1.0f));
            }
            float xOffset = 0.0f;
            for (DynamicTextureCache.DynamicResource resourceLocationData : resourceLocationDataList) {
                float width = height * (float)resourceLocationData.width / (float)resourceLocationData.height;
                float finalXOffset = xOffset;
                MainRenderer.scheduleRender(resourceLocationData.identifier, true, QueuedRenderLayer.LIGHT, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations2.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                    IDrawing.drawTexture(graphicsHolderNew, flipCustomText ? -finalXOffset - width : finalXOffset, margin, width, height, Direction.UP, GraphicsHolder.getDefaultLight());
                    graphicsHolderNew.pop();
                });
                xOffset += width + margin / 2.0f;
            }
        } else if (storedMatrixTransformations != null && isPlatform) {
            Station station = InitClient.findStation(pos);
            if (station == null) {
                return;
            }
            LongArrayList selectedIdsSorted = station.savedRails.stream().sorted().mapToLong(NameColorDataBase::getId).filter(selectedIds::contains).boxed().collect(Collectors.toCollection(LongArrayList::new));
            int selectedCount = selectedIdsSorted.size();
            float extraMargin = margin - margin / (float)selectedCount;
            float height = (size - extraMargin * 2.0f) / (float)selectedCount;
            for (int i = 0; i < selectedIdsSorted.size(); ++i) {
                float topOffset = (float)i * height + extraMargin;
                float bottomOffset = (float)(i + 1) * height + extraMargin;
                float left = flipCustomText ? x - maxWidthLeft * size : x + margin;
                float right = flipCustomText ? x + size - margin : x + (maxWidthRight + 1.0f) * size;
                MainRenderer.scheduleRender(DynamicTextureCache.instance.getDirectionArrow((long)selectedIdsSorted.getLong((int)i), (boolean)false, (boolean)false, (IGui.HorizontalAlignment)(flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT), (boolean)false, (float)(margin / size), (float)((right - left) / (bottomOffset - topOffset)), (int)backgroundColor, (int)-1, (int)backgroundColor).identifier, true, QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
                    IDrawing.drawTexture(graphicsHolderNew, left, topOffset, 0.0f, right, bottomOffset, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facing, -1, GraphicsHolder.getDefaultLight());
                    graphicsHolderNew.pop();
                });
            }
        } else {
            if (storedMatrixTransformations != null && isTransportSystemMap) {
                StoredMatrixTransformations storedMatrixTransformationsNew = storedMatrixTransformations.copy();
                storedMatrixTransformationsNew.add(graphicsHolderNew -> graphicsHolderNew.translate(x, y, 0.0));
                QrCodeHelper.INSTANCE.renderQrCode(storedMatrixTransformationsNew, QueuedRenderLayer.LIGHT, signSize);
            } else {
                drawTexture.drawTexture(sign.getTexture(), x + margin, y + margin, signSize, flipTexture);
            }
            if (hasCustomText) {
                float start;
                float fixedMargin = size * 0.25f / 2.0f;
                boolean isSmall = sign.getSmall();
                float maxWidth = Math.max(0.0f, (flipCustomText ? maxWidthLeft : maxWidthRight) * size - fixedMargin * (float)(isSmall ? 1 : 2));
                float f = flipCustomText ? x - (isSmall ? 0.0f : fixedMargin) : (start = x + size + (isSmall ? 0.0f : fixedMargin));
                if (storedMatrixTransformations == null) {
                    IDrawing.drawStringWithFont(graphicsHolder, isExit || isLine ? "..." : sign.getCustomText().getString(), flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.TOP, start, y + fixedMargin, maxWidth, size - fixedMargin * 2.0f, 0.01f, -1, false, GraphicsHolder.getDefaultLight(), null);
                } else {
                    String signText = isStation ? IGui.mergeStations(selectedIds.longStream().filter(MinecraftClientData.getInstance().stationIdMap::containsKey).sorted().mapToObj(stationId -> IGui.insertTranslation("gui.mtr.station_cjk", "gui.mtr.station", 1, ((Station)MinecraftClientData.getInstance().stationIdMap.get(stationId)).getName())).collect(Collectors.toList())) : sign.getCustomText().getString();
                    RenderRailwaySign.renderCustomText(signText, storedMatrixTransformations, facing, size, start, flipCustomText, maxWidth, backgroundColor);
                }
            }
        }
    }

    private static void renderCustomText(String signText, StoredMatrixTransformations storedMatrixTransformations, Direction facing, float size, float start, boolean flipCustomText, float maxWidth, int backgroundColor) {
        DynamicTextureCache.DynamicResource dynamicResource = DynamicTextureCache.instance.getSignText(signText, flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT, 0.125f, backgroundColor, -1);
        float width = Math.min(size * (float)dynamicResource.width / (float)dynamicResource.height, maxWidth);
        MainRenderer.scheduleRender(dynamicResource.identifier, true, QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolderNew, offset) -> {
            storedMatrixTransformations.transform((GraphicsHolder)graphicsHolderNew, (Vector3d)offset);
            IDrawing.drawTexture(graphicsHolderNew, start - (flipCustomText ? width : 0.0f), 0.0f, 0.0f, start + (flipCustomText ? 0.0f : width), size, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facing, -1, GraphicsHolder.getDefaultLight());
            graphicsHolderNew.pop();
        });
    }

    public static SignResource getSign(@Nullable String signId) {
        if (signId == null) {
            return null;
        }
        SignResource[] signResource = new SignResource[]{null};
        CustomResourceLoader.getSignById(signId, newSignResource -> {
            signResource[0] = newSignResource;
        });
        return signResource[0];
    }

    public static float getMaxWidth(String[] signIds, int index, boolean right) {
        float maxWidthLeft = 0.0f;
        int i = index + (right ? 1 : -1);
        while (right ? i < signIds.length : i >= 0) {
            if (signIds[i] != null) {
                SignResource sign = RenderRailwaySign.getSign(signIds[i]);
                if (sign != null && sign.hasCustomText && right == sign.getFlipCustomText()) {
                    maxWidthLeft /= 2.0f;
                }
                return maxWidthLeft;
            }
            maxWidthLeft += 1.0f;
            i += right ? 1 : -1;
        }
        return maxWidthLeft;
    }

    @FunctionalInterface
    public static interface DrawTexture {
        public void drawTexture(Identifier var1, float var2, float var3, float var4, boolean var5);
    }
}

