/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import org.mtr.mapping.holder.BlockEntityAbstractMapping;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.LightType;
import org.mtr.mapping.holder.LightmapTextureManager;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.block.BlockSignalSemaphoreBase;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderSignalBase;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderSignalSemaphore<T extends BlockSignalSemaphoreBase.BlockEntityBase>
extends RenderSignalBase<T> {
    private static final int ANGLE = 55;
    private static final int SPEED = 4;

    public RenderSignalSemaphore(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher, 8, 2);
    }

    @Override
    protected void render(StoredMatrixTransformations storedMatrixTransformations, T entity, float tickDelta, int occupiedAspect, boolean isBackSide) {
        float angle = isBackSide ? ((BlockSignalSemaphoreBase.BlockEntityBase)((Object)entity)).angle2 : ((BlockSignalSemaphoreBase.BlockEntityBase)((Object)entity)).angle1;
        MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/white.png"), false, QueuedRenderLayer.LIGHT, (graphicsHolder, offset) -> {
            storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
            IDrawing.drawTexture(graphicsHolder, -0.0625f, 0.296875f, -0.190625f, 0.0625f, 0.453125f, -0.190625f, Direction.UP, angle < 27.5f ? -65536 : -16711936, GraphicsHolder.getDefaultLight());
            graphicsHolder.pop();
        });
        World world = ((BlockEntityAbstractMapping)((Object)entity)).getWorld2();
        if (world != null) {
            BlockPos pos = ((BlockEntityAbstractMapping)((Object)entity)).getPos2();
            MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/semaphore.png"), false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                graphicsHolder.translate(0.1875, 0.375, 0.0);
                graphicsHolder.rotateZDegrees(-180.0f - angle);
                int light = LightmapTextureManager.pack(world.getLightLevel(LightType.getBlockMapped(), pos), world.getLightLevel(LightType.getSkyMapped(), pos));
                IDrawing.drawTexture(graphicsHolder, -0.705f, -0.5f, -0.19375f, 0.295f, 0.5f, -0.19375f, Direction.UP, -1, light);
                IDrawing.drawTexture(graphicsHolder, 0.295f, -0.5f, -0.19375f, -0.705f, 0.5f, -0.19375f, 1.0f, 0.0f, 0.0f, 1.0f, Direction.UP, -1, light);
                graphicsHolder.pop();
            });
        }
        float newAngle = occupiedAspect > 0 ? Math.max(0.0f, angle - 4.0f * tickDelta) : Math.min(55.0f, angle + 4.0f * tickDelta);
        if (isBackSide) {
            ((BlockSignalSemaphoreBase.BlockEntityBase)((Object)entity)).angle2 = newAngle;
        } else {
            ((BlockSignalSemaphoreBase.BlockEntityBase)((Object)entity)).angle1 = newAngle;
        }
    }
}

