/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import org.mtr.core.data.Station;
import org.mtr.mapping.holder.BlockEntityAbstractMapping;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockStationNameBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.RenderRouteBase;
import org.mtr.mod.render.StoredMatrixTransformations;

public abstract class RenderStationNameBase<T extends BlockStationNameBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements IGui,
IDrawing {
    public RenderStationNameBase(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    @Override
    public void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = ((BlockEntityAbstractMapping)((Object)entity)).getWorld2();
        if (world == null) {
            return;
        }
        BlockPos pos = ((BlockEntityAbstractMapping)((Object)entity)).getPos2();
        BlockState state = world.getBlockState(pos);
        Direction facing = IBlock.getStatePropertySafe(state, BlockStationNameBase.FACING);
        int color = RenderRouteBase.getShadingColor(facing, ((BlockStationNameBase.BlockEntityBase)entity).getColor(state));
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)pos.getX(), 0.5 + (double)((BlockStationNameBase.BlockEntityBase)entity).yOffset + (double)pos.getY(), 0.5 + (double)pos.getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.rotateYDegrees(-facing.asRotation());
            graphicsHolderNew.rotateZDegrees(180.0f);
        });
        Station station = InitClient.findStation(pos);
        for (int i = 0; i < (((BlockStationNameBase.BlockEntityBase)entity).isDoubleSided ? 2 : 1); ++i) {
            StoredMatrixTransformations storedMatrixTransformations2 = storedMatrixTransformations.copy();
            boolean shouldFlip = i == 1;
            storedMatrixTransformations2.add(graphicsHolderNew -> {
                if (shouldFlip) {
                    graphicsHolderNew.rotateYDegrees(180.0f);
                }
                graphicsHolderNew.translate(0.0, 0.0, 0.5 - (double)entity.zOffset - (double)0.003125f);
            });
            this.drawStationName(world, pos, state, facing, storedMatrixTransformations2, station == null ? TextHelper.translatable("gui.mtr.untitled", new Object[0]).getString() : station.getName(), station == null ? 0 : station.getColor(), color, light);
        }
    }

    protected abstract void drawStationName(World var1, BlockPos var2, BlockState var3, Direction var4, StoredMatrixTransformations var5, String var6, int var7, int var8, int var9);
}

