/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.mtr.core.data.VehicleCar;
import org.mtr.core.tool.Vector;
import org.mtr.libraries.com.logisticscraft.occlusionculling.util.Vec3d;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectBooleanImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.LightType;
import org.mtr.mapping.holder.LightmapTextureManager;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.OptimizedRenderer;
import org.mtr.mod.Init;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.GangwayMovementPositions;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.client.VehicleRidingMovement;
import org.mtr.mod.data.IGui;
import org.mtr.mod.data.VehicleExtension;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderVehicleHelper;
import org.mtr.mod.render.RenderVehicleTransformationHelper;
import org.mtr.mod.render.StoredMatrixTransformations;
import org.mtr.mod.resource.VehicleResource;

public class RenderVehicles
implements IGui {
    public static void render(long millisElapsed, Vector3d cameraShakeOffset) {
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        ClientWorld clientWorld = minecraftClient.getWorldMapped();
        ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
        if (clientWorld == null || clientPlayerEntity == null) {
            return;
        }
        ObjectArrayList cullingTasks = new ObjectArrayList();
        Vector3d cameraPosition = minecraftClient.getGameRendererMapped().getCamera().getPos();
        Vec3d camera = new Vec3d(cameraPosition.getXMapped(), cameraPosition.getYMapped(), cameraPosition.getZMapped());
        boolean canRide = !clientPlayerEntity.isSpectator();
        MinecraftClientData.getInstance().vehicles.forEach(vehicle -> {
            ObjectArrayList previousGangwayPositionsList = new ObjectArrayList();
            ObjectArrayList previousBarrierPositionsList = new ObjectArrayList();
            PreviousGangwayMovementPositions previousGangwayMovementPositions = new PreviousGangwayMovementPositions();
            ObjectArrayList<RenderVehicleHelper.VehicleProperties> vehiclePropertiesList = RenderVehicleHelper.getTransformedVehiclePropertiesList(vehicle, vehicle.getVehicleCarsAndPositions().stream().map(vehicleCarAndPosition -> new RenderVehicleHelper.VehicleProperties((ObjectObjectImmutablePair<VehicleCar, ObjectArrayList<ObjectObjectImmutablePair<Vector, Vector>>>)vehicleCarAndPosition, !vehicle.getTransportMode().hasPitchAscending && !vehicle.getTransportMode().hasPitchDescending)).collect(Collectors.toCollection(ObjectArrayList::new)), cameraShakeOffset);
            RenderVehicles.iterateWithIndex(vehiclePropertiesList, (carNumber, vehicleProperties) -> {
                RenderVehicleTransformationHelper renderVehicleTransformationHelperAbsolute = vehicleProperties.renderVehicleTransformationHelperAbsolute;
                RenderVehicleTransformationHelper renderVehicleTransformationHelperOffset = vehicleProperties.renderVehicleTransformationHelperOffset;
                cullingTasks.add(occlusionCullingInstance -> {
                    double longestDimension = vehicle.persistentVehicleData.longestDimensions[carNumber];
                    boolean shouldRender = occlusionCullingInstance.isAABBVisible(new Vec3d(renderVehicleTransformationHelperAbsolute.pivotPosition.x - longestDimension, renderVehicleTransformationHelperAbsolute.pivotPosition.y - 8.0, renderVehicleTransformationHelperAbsolute.pivotPosition.z - longestDimension), new Vec3d(renderVehicleTransformationHelperAbsolute.pivotPosition.x + longestDimension, renderVehicleTransformationHelperAbsolute.pivotPosition.y + 8.0, renderVehicleTransformationHelperAbsolute.pivotPosition.z + longestDimension), camera);
                    return () -> {
                        vehicle.persistentVehicleData.rayTracing[carNumber] = shouldRender;
                    };
                });
                if (vehicle.persistentVehicleData.rayTracing[carNumber] || VehicleRidingMovement.isRiding(vehicle.getId())) {
                    CustomResourceLoader.getVehicleById(vehicle.getTransportMode(), vehicleProperties.vehicleCar.getVehicleId(), vehicleResource -> {
                        RenderVehicles.iterateWithIndex(vehicleProperties.bogiePositionsList, (bogieIndex, bogiePositions) -> {
                            RenderVehicleTransformationHelper renderVehicleTransformationHelperBogie = new RenderVehicleTransformationHelper((ObjectObjectImmutablePair<Vector, Vector>)bogiePositions, vehicleProperties.averageAbsoluteBogiePositionsList.get(bogieIndex), renderVehicleTransformationHelperOffset);
                            if (OptimizedRenderer.hasOptimizedRendering()) {
                                RenderVehicleHelper.renderModel(renderVehicleTransformationHelperBogie, 0.0, storedMatrixTransformations -> vehicleResource.queueBogie(bogieIndex, (StoredMatrixTransformations)storedMatrixTransformations, (VehicleExtension)vehicle, renderVehicleTransformationHelperBogie.light));
                            } else {
                                vehicleResource.iterateBogieModels(bogieIndex, model -> RenderVehicleHelper.renderModel(renderVehicleTransformationHelperBogie, 0.0, storedMatrixTransformations -> model.render((StoredMatrixTransformations)storedMatrixTransformations, (VehicleExtension)vehicle, renderVehicleTransformationHelperBogie.light, new ObjectArrayList<Box>())));
                            }
                            vehicle.playMotorSound((VehicleResource)vehicleResource, carNumber, bogieIndex, renderVehicleTransformationHelperBogie.pivotPosition);
                        });
                        Vector3d playerPosition = renderVehicleTransformationHelperAbsolute.transformBackwards(clientPlayerEntity.getPos(), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
                        ObjectArrayList<ObjectBooleanImmutablePair<Box>> floorsAndDoorways = new ObjectArrayList<ObjectBooleanImmutablePair<Box>>();
                        GangwayMovementPositions gangwayMovementPositions1 = new GangwayMovementPositions(renderVehicleTransformationHelperAbsolute, false);
                        GangwayMovementPositions gangwayMovementPositions2 = new GangwayMovementPositions(renderVehicleTransformationHelperAbsolute, true);
                        ObjectArrayList openDoorways = !vehicle.getTransportMode().continuousMovement && vehicle.isMoving() || !vehicle.persistentVehicleData.checkCanOpenDoors() ? new ObjectArrayList() : vehicleResource.doorways.stream().filter(doorway -> RenderVehicleHelper.canOpenDoors(doorway, renderVehicleTransformationHelperAbsolute, vehicle.persistentVehicleData.getDoorValue())).collect(Collectors.toCollection(ObjectArrayList::new));
                        double oscillationAmount = vehicle.persistentVehicleData.getOscillation(carNumber).getAmount();
                        if (canRide) {
                            vehicleResource.floors.forEach(floor -> {
                                floorsAndDoorways.add(new ObjectBooleanImmutablePair<Box>((Box)floor, true));
                                RenderVehicleHelper.renderFloorOrDoorway(floor, -1, playerPosition, renderVehicleTransformationHelperOffset);
                                gangwayMovementPositions1.check((Box)floor);
                                gangwayMovementPositions2.check((Box)floor);
                            });
                            openDoorways.forEach(doorway -> {
                                floorsAndDoorways.add(new ObjectBooleanImmutablePair<Box>((Box)doorway, false));
                                RenderVehicleHelper.renderFloorOrDoorway(doorway, -65536, playerPosition, renderVehicleTransformationHelperOffset);
                            });
                            VehicleRidingMovement.startRiding(openDoorways, vehicle.vehicleExtraData.getSidingId(), vehicle.getId(), carNumber, playerPosition.getXMapped(), playerPosition.getYMapped(), playerPosition.getZMapped(), renderVehicleTransformationHelperAbsolute.yaw);
                        }
                        if (!openDoorways.isEmpty()) {
                            vehicle.playDoorSound((VehicleResource)vehicleResource, carNumber, renderVehicleTransformationHelperAbsolute.pivotPosition);
                        }
                        RenderVehicleHelper.renderModel(renderVehicleTransformationHelperOffset, oscillationAmount, storedMatrixTransformations -> {
                            if (OptimizedRenderer.hasOptimizedRendering()) {
                                vehicleResource.queue((StoredMatrixTransformations)storedMatrixTransformations, (VehicleExtension)vehicle, renderVehicleTransformationHelperAbsolute.light, openDoorways);
                            }
                            vehicleResource.iterateModels((modelIndex, model) -> {
                                model.render((StoredMatrixTransformations)storedMatrixTransformations, (VehicleExtension)vehicle, renderVehicleTransformationHelperAbsolute.light, openDoorways);
                                while (modelIndex >= previousGangwayPositionsList.size()) {
                                    previousGangwayPositionsList.add(new PreviousConnectionPositions());
                                }
                                while (modelIndex >= previousBarrierPositionsList.size()) {
                                    previousBarrierPositionsList.add(new PreviousConnectionPositions());
                                }
                                RenderVehicles.renderConnection(vehicleResource.hasGangway1(), vehicleResource.hasGangway2(), true, (PreviousConnectionPositions)previousGangwayPositionsList.get(modelIndex), model.modelProperties.gangwayInnerSideTexture, model.modelProperties.gangwayInnerTopTexture, model.modelProperties.gangwayInnerBottomTexture, model.modelProperties.gangwayOuterSideTexture, model.modelProperties.gangwayOuterTopTexture, model.modelProperties.gangwayOuterBottomTexture, renderVehicleTransformationHelperOffset, vehicleProperties.vehicleCar.getLength(), model.modelProperties.getGangwayWidth(), model.modelProperties.getGangwayHeight(), model.modelProperties.getGangwayYOffset(), model.modelProperties.getGangwayZOffset(), oscillationAmount, vehicle.getIsOnRoute());
                                RenderVehicles.renderConnection(vehicleResource.hasBarrier1(), vehicleResource.hasBarrier2(), false, (PreviousConnectionPositions)previousBarrierPositionsList.get(modelIndex), model.modelProperties.barrierInnerSideTexture, model.modelProperties.barrierInnerTopTexture, model.modelProperties.barrierInnerBottomTexture, model.modelProperties.barrierOuterSideTexture, model.modelProperties.barrierOuterTopTexture, model.modelProperties.barrierOuterBottomTexture, renderVehicleTransformationHelperOffset, vehicleProperties.vehicleCar.getLength(), model.modelProperties.getBarrierWidth(), model.modelProperties.getBarrierHeight(), model.modelProperties.getBarrierYOffset(), model.modelProperties.getBarrierZOffset(), oscillationAmount, vehicle.getIsOnRoute());
                            });
                        });
                        if (vehicleResource.hasGangway1()) {
                            Box gangwayConnectionFloor1 = gangwayMovementPositions1.getBox();
                            RenderVehicleHelper.renderFloorOrDoorway(gangwayConnectionFloor1, -16776961, playerPosition, renderVehicleTransformationHelperOffset);
                            floorsAndDoorways.add(new ObjectBooleanImmutablePair<Box>(gangwayConnectionFloor1, true));
                        }
                        if (vehicleResource.hasGangway2()) {
                            Box gangwayConnectionFloor2 = gangwayMovementPositions2.getBox();
                            RenderVehicleHelper.renderFloorOrDoorway(gangwayConnectionFloor2, -16776961, playerPosition, renderVehicleTransformationHelperOffset);
                            floorsAndDoorways.add(new ObjectBooleanImmutablePair<Box>(gangwayConnectionFloor2, true));
                        }
                        if (canRide) {
                            VehicleRidingMovement.movePlayer(millisElapsed, vehicle.getId(), carNumber, floorsAndDoorways, vehicleResource.hasGangway1() ? previousGangwayMovementPositions.gangwayMovementPositions : null, vehicleResource.hasGangway1() ? gangwayMovementPositions1 : null, vehicleResource.hasGangway2() ? gangwayMovementPositions2 : null, renderVehicleTransformationHelperAbsolute);
                        }
                        previousGangwayMovementPositions.gangwayMovementPositions = gangwayMovementPositions2;
                    });
                }
            });
        });
        if (!OptimizedRenderer.renderingShadows()) {
            MainRenderer.WORKER_THREAD.scheduleVehicles(occlusionCullingInstance -> {
                ObjectArrayList tasks = new ObjectArrayList();
                cullingTasks.forEach(occlusionCullingInstanceRunnableFunction -> tasks.add((Runnable)occlusionCullingInstanceRunnableFunction.apply(occlusionCullingInstance)));
                minecraftClient.execute(() -> tasks.forEach(Runnable::run));
            });
        }
    }

    private static void renderConnection(boolean shouldRender1, boolean shouldRender2, boolean canHaveLight, PreviousConnectionPositions previousConnectionPositions, @Nullable Identifier innerSideTexture, @Nullable Identifier innerTopTexture, @Nullable Identifier innerBottomTexture, @Nullable Identifier outerSideTexture, @Nullable Identifier outerTopTexture, @Nullable Identifier outerBottomTexture, RenderVehicleTransformationHelper renderVehicleTransformationHelper, double vehicleLength, double width, double height, double yOffset, double zOffset, double oscillationAmount, boolean isOnRoute) {
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld == null) {
            return;
        }
        double halfLength = vehicleLength / 2.0;
        double newOscillationAmount = -Math.toRadians(oscillationAmount);
        if (shouldRender1 && previousConnectionPositions.isValid()) {
            Vector position1 = renderVehicleTransformationHelper.transformForwards(new Vector(-width / 2.0, yOffset + (double)0.003125f, zOffset - halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
            Vector position2 = renderVehicleTransformationHelper.transformForwards(new Vector(-width / 2.0, height + yOffset + (double)0.003125f, zOffset - halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
            Vector position3 = renderVehicleTransformationHelper.transformForwards(new Vector(width / 2.0, height + yOffset + (double)0.003125f, zOffset - halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
            Vector position4 = renderVehicleTransformationHelper.transformForwards(new Vector(width / 2.0, yOffset + (double)0.003125f, zOffset - halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
            Vector position5 = previousConnectionPositions.position1;
            Vector position6 = previousConnectionPositions.position2;
            Vector position7 = previousConnectionPositions.position3;
            Vector position8 = previousConnectionPositions.position4;
            BlockPos blockPosConnection = Init.newBlockPos(position1.x, position1.y + 1.0, position1.z);
            int lightConnection = LightmapTextureManager.pack(clientWorld.getLightLevel(LightType.getBlockMapped(), blockPosConnection), clientWorld.getLightLevel(LightType.getSkyMapped(), blockPosConnection));
            MainRenderer.scheduleRender(outerSideTexture, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> renderVehicleTransformationHelper.render((GraphicsHolder)graphicsHolder, (Vector3d)offset, newOffset -> {
                RenderVehicles.drawTexture(graphicsHolder, position2, position7, position8, position1, newOffset, lightConnection);
                RenderVehicles.drawTexture(graphicsHolder, position6, position3, position4, position5, newOffset, lightConnection);
            }));
            MainRenderer.scheduleRender(outerTopTexture, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> renderVehicleTransformationHelper.render((GraphicsHolder)graphicsHolder, (Vector3d)offset, newOffset -> RenderVehicles.drawTexture(graphicsHolder, position3, position6, position7, position2, newOffset, lightConnection)));
            MainRenderer.scheduleRender(outerBottomTexture, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> renderVehicleTransformationHelper.render((GraphicsHolder)graphicsHolder, (Vector3d)offset, newOffset -> RenderVehicles.drawTexture(graphicsHolder, position1, position8, position5, position4, newOffset, lightConnection)));
            MainRenderer.scheduleRender(innerSideTexture, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> renderVehicleTransformationHelper.render((GraphicsHolder)graphicsHolder, (Vector3d)offset, newOffset -> {
                RenderVehicles.drawTexture(graphicsHolder, position7, position2, position1, position8, newOffset, canHaveLight && isOnRoute ? GraphicsHolder.getDefaultLight() : lightConnection);
                RenderVehicles.drawTexture(graphicsHolder, position3, position6, position5, position4, newOffset, canHaveLight && isOnRoute ? GraphicsHolder.getDefaultLight() : lightConnection);
            }));
            MainRenderer.scheduleRender(innerTopTexture, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> renderVehicleTransformationHelper.render((GraphicsHolder)graphicsHolder, (Vector3d)offset, newOffset -> RenderVehicles.drawTexture(graphicsHolder, position6, position3, position2, position7, newOffset, canHaveLight && isOnRoute ? GraphicsHolder.getDefaultLight() : lightConnection)));
            MainRenderer.scheduleRender(innerBottomTexture, false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> renderVehicleTransformationHelper.render((GraphicsHolder)graphicsHolder, (Vector3d)offset, newOffset -> RenderVehicles.drawTexture(graphicsHolder, position8, position1, position4, position5, newOffset, canHaveLight && isOnRoute ? GraphicsHolder.getDefaultLight() : lightConnection)));
        }
        if (shouldRender2) {
            previousConnectionPositions.position1 = renderVehicleTransformationHelper.transformForwards(new Vector(width / 2.0, yOffset + (double)0.003125f, -zOffset + halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
            previousConnectionPositions.position2 = renderVehicleTransformationHelper.transformForwards(new Vector(width / 2.0, height + yOffset + (double)0.003125f, -zOffset + halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
            previousConnectionPositions.position3 = renderVehicleTransformationHelper.transformForwards(new Vector(-width / 2.0, height + yOffset + (double)0.003125f, -zOffset + halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
            previousConnectionPositions.position4 = renderVehicleTransformationHelper.transformForwards(new Vector(-width / 2.0, yOffset + (double)0.003125f, -zOffset + halfLength).rotateZ(newOscillationAmount), Vector::rotateX, Vector::rotateY, Vector::add);
        } else {
            previousConnectionPositions.position1 = null;
            previousConnectionPositions.position2 = null;
            previousConnectionPositions.position3 = null;
            previousConnectionPositions.position4 = null;
        }
    }

    private static void drawTexture(GraphicsHolder graphicsHolder, Vector position1, Vector position2, Vector position3, Vector position4, Vector3d offset, int light) {
        IDrawing.drawTexture(graphicsHolder, position1.x, position1.y, position1.z, position2.x, position2.y, position2.z, position3.x, position3.y, position3.z, position4.x, position4.y, position4.z, offset, 0.0f, 0.0f, 1.0f, 1.0f, Direction.UP, -1, light);
    }

    private static <T> void iterateWithIndex(ObjectArrayList<T> list, IndexedConsumer<T> indexedConsumer) {
        for (int i = 0; i < list.size(); ++i) {
            indexedConsumer.accept(i, list.get(i));
        }
    }

    private static class PreviousConnectionPositions {
        private Vector position1;
        private Vector position2;
        private Vector position3;
        private Vector position4;

        private PreviousConnectionPositions() {
        }

        private boolean isValid() {
            return this.position1 != null && this.position2 != null && this.position3 != null && this.position4 != null;
        }
    }

    @FunctionalInterface
    private static interface IndexedConsumer<T> {
        public void accept(int var1, T var2);
    }

    private static class PreviousGangwayMovementPositions {
        private GangwayMovementPositions gangwayMovementPositions;

        private PreviousGangwayMovementPositions() {
        }
    }
}

