/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import java.util.function.Consumer;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.GraphicsHolder;

public class StoredMatrixTransformations {
    public final boolean useDefaultOffset;
    private final ObjectArrayList<Consumer<GraphicsHolder>> transformations = new ObjectArrayList();
    private final double initialTranslateX;
    private final double initialTranslateY;
    private final double initialTranslateZ;

    public StoredMatrixTransformations() {
        this.useDefaultOffset = false;
        this.initialTranslateX = 0.0;
        this.initialTranslateY = 0.0;
        this.initialTranslateZ = 0.0;
    }

    public StoredMatrixTransformations(double initialTranslateX, double initialTranslateY, double initialTranslateZ) {
        this.useDefaultOffset = true;
        this.initialTranslateX = initialTranslateX;
        this.initialTranslateY = initialTranslateY;
        this.initialTranslateZ = initialTranslateZ;
    }

    private StoredMatrixTransformations(boolean useDefaultOffset, double initialTranslateX, double initialTranslateY, double initialTranslateZ) {
        this.useDefaultOffset = useDefaultOffset;
        this.initialTranslateX = initialTranslateX;
        this.initialTranslateY = initialTranslateY;
        this.initialTranslateZ = initialTranslateZ;
    }

    public void add(Consumer<GraphicsHolder> transformation) {
        this.transformations.add(transformation);
    }

    public void transform(GraphicsHolder graphicsHolder, Vector3d offset) {
        graphicsHolder.push();
        if (this.useDefaultOffset) {
            graphicsHolder.translate(this.initialTranslateX - offset.getXMapped(), this.initialTranslateY - offset.getYMapped(), this.initialTranslateZ - offset.getZMapped());
        }
        this.transformations.forEach((Consumer<Consumer<GraphicsHolder>>)((Consumer<Consumer>)transformation -> transformation.accept(graphicsHolder)));
    }

    public StoredMatrixTransformations copy() {
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(this.useDefaultOffset, this.initialTranslateX, this.initialTranslateY, this.initialTranslateZ);
        storedMatrixTransformations.transformations.addAll((ObjectList<Consumer<GraphicsHolder>>)this.transformations);
        return storedMatrixTransformations;
    }
}

