/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import javax.annotation.Nullable;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.mapper.OptimizedModel;
import org.mtr.mod.generated.resource.ObjectResourceSchema;
import org.mtr.mod.render.DynamicVehicleModel;
import org.mtr.mod.resource.CustomResourceTools;
import org.mtr.mod.resource.OptimizedModelWrapper;
import org.mtr.mod.resource.StoredModelResourceBase;

public final class ObjectResource
extends ObjectResourceSchema
implements StoredModelResourceBase {
    @Nullable
    private final OptimizedModelWrapper optimizedModel;
    @Nullable
    private final DynamicVehicleModel dynamicVehicleModel;

    public ObjectResource(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
        ObjectObjectImmutablePair<OptimizedModelWrapper, DynamicVehicleModel> modelPair = this.load(this.modelResource, this.textureResource, this.flipTextureV, 0.0);
        this.optimizedModel = modelPair.left();
        this.dynamicVehicleModel = modelPair.right();
    }

    @Override
    @Nullable
    public OptimizedModelWrapper getOptimizedModel() {
        return this.optimizedModel;
    }

    @Override
    @Nullable
    public DynamicVehicleModel getDynamicVehicleModel() {
        return this.dynamicVehicleModel;
    }

    @Override
    public void transform(ObjectCollection<OptimizedModel.ObjModel> values2) {
        values2.forEach(objModel -> {
            objModel.applyTranslation(this.translation.getX(), this.translation.getY(), this.translation.getZ());
            objModel.applyRotation(this.rotation.getX(), this.rotation.getY(), this.rotation.getZ());
            objModel.applyScale(ObjectResource.clampNumber(this.scale.getX()), ObjectResource.clampNumber(this.scale.getY()), ObjectResource.clampNumber(this.scale.getZ()));
            objModel.applyMirror(this.mirror.getX(), this.mirror.getY(), this.mirror.getZ());
        });
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        return CustomResourceTools.colorStringToInt(this.color);
    }

    private static double clampNumber(double value) {
        return value <= 0.0 ? 1.0 : value;
    }
}

