/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;
import org.mtr.core.data.Depot;
import org.mtr.core.data.Platform;
import org.mtr.core.data.Route;
import org.mtr.core.data.RoutePlatformData;
import org.mtr.core.data.Station;
import org.mtr.core.data.TransportMode;
import org.mtr.core.operation.GenerateOrClearByDepotIds;
import org.mtr.core.operation.UpdateDataRequest;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.packet.PacketDepotClear;
import org.mtr.mod.packet.PacketDepotGenerate;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.screen.DashboardList;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.DashboardListSelectorScreen;
import org.mtr.mod.screen.DashboardScreen;
import org.mtr.mod.screen.EditNameColorScreenBase;
import org.mtr.mod.screen.WidgetShorterSlider;

public class EditDepotScreen
extends EditNameColorScreenBase<Depot> {
    private final int sliderX;
    private final int sliderWidthWithText;
    private final int rightPanelsX;
    private final boolean showScheduleControls;
    private final boolean showCruisingAltitude;
    private final ButtonWidgetExtension buttonUseRealTime;
    private final ButtonWidgetExtension buttonReset;
    private final WidgetShorterSlider[] sliders = new WidgetShorterSlider[24];
    private final TextFieldWidgetExtension textFieldDeparture;
    private final ButtonWidgetExtension buttonAddDeparture;
    private final ButtonWidgetExtension buttonEditInstructions;
    private final ButtonWidgetExtension buttonGenerateRoute;
    private final ButtonWidgetExtension buttonClearTrains;
    private final CheckboxWidgetExtension checkboxRepeatIndefinitely;
    private final TextFieldWidgetExtension textFieldCruisingAltitude;
    private final DashboardList departuresList;
    private final MutableText cruisingAltitudeText = TextHelper.translatable("gui.mtr.cruising_altitude", new Object[0]);
    private static final int PANELS_START = 44;
    private static final int SLIDER_WIDTH = 64;
    private static final int MAX_TRAINS_PER_HOUR = 5;
    private static final int DEFAULT_CRUISING_ALTITUDE = 256;
    private static final int TRAIN_FREQUENCY_MULTIPLIER = 4;

    public EditDepotScreen(Depot depot, TransportMode transportMode, DashboardScreen dashboardScreen) {
        super(depot, dashboardScreen, "gui.mtr.depot_name", "gui.mtr.depot_color");
        this.sliderX = GraphicsHolder.getTextWidth(EditDepotScreen.getTimeString(0)) + 12;
        this.sliderWidthWithText = 70 + GraphicsHolder.getTextWidth(EditDepotScreen.getSliderString(0));
        this.rightPanelsX = this.sliderX + 64 + 12 + GraphicsHolder.getTextWidth(EditDepotScreen.getSliderString(1));
        this.showScheduleControls = !transportMode.continuousMovement;
        this.showCruisingAltitude = transportMode == TransportMode.AIRPLANE;
        this.buttonUseRealTime = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.mtr.schedule_mode_real_time_off", new Object[0]), button -> {
            depot.setUseRealTime(!depot.getUseRealTime());
            this.toggleRealTime();
            this.saveData();
        });
        this.buttonReset = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.mtr.reset_sign", new Object[0]), button -> {
            for (int i = 0; i < 24; ++i) {
                this.sliders[i].setValue(0);
            }
            ((Depot)this.data).getRealTimeDepartures().clear();
            this.updateList();
            this.saveData();
        });
        int i = 0;
        while (i < 24) {
            int currentIndex = i++;
            this.sliders[currentIndex] = new WidgetShorterSlider(this.sliderX, 64, 10, EditDepotScreen::getSliderString, value -> {
                for (int j = 0; j < 24; ++j) {
                    if (j == currentIndex) continue;
                    this.sliders[j].setValue(value);
                }
            });
        }
        this.departuresList = new DashboardList(null, null, null, null, null, this::onDeleteDeparture, null, () -> "", text -> {});
        this.textFieldDeparture = new TextFieldWidgetExtension(0, 0, 0, 20, 25, TextCase.DEFAULT, "[^\\d:+* ]", "07:10:00 + 10 * 00:03:00");
        this.buttonAddDeparture = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("+"), button -> {
            this.checkDeparture(this.textFieldDeparture.getText2(), true, false);
            this.saveData();
        });
        this.buttonEditInstructions = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.mtr.edit_instructions", new Object[0]), button -> {
            this.saveData();
            ObjectArrayList<DashboardListItem> routes = new ObjectArrayList<DashboardListItem>((ObjectCollection<DashboardListItem>)MinecraftClientData.getFilteredDataSet(transportMode, MinecraftClientData.getDashboardInstance().routes));
            Collections.sort(routes);
            MinecraftClient.getInstance().openScreen(new Screen(new DashboardListSelectorScreen(this, new ObjectImmutableList<DashboardListItem>((ObjectList<DashboardListItem>)routes), (LongCollection)((Depot)this.data).getRouteIds(), false, true)));
        });
        this.buttonGenerateRoute = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.mtr.refresh_path", new Object[0]), button -> {
            this.saveData();
            GenerateOrClearByDepotIds generateOrClearByDepotIds = new GenerateOrClearByDepotIds();
            generateOrClearByDepotIds.addDepotId(depot.getId());
            InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketDepotGenerate(generateOrClearByDepotIds));
        });
        this.buttonClearTrains = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.mtr.clear_vehicles", new Object[0]), button -> {
            this.saveData();
            GenerateOrClearByDepotIds generateOrClearByDepotIds = new GenerateOrClearByDepotIds();
            generateOrClearByDepotIds.addDepotId(depot.getId());
            InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketDepotClear(generateOrClearByDepotIds));
        });
        this.checkboxRepeatIndefinitely = new CheckboxWidgetExtension(0, 0, 0, 20, true, button -> {
            this.saveData();
            GenerateOrClearByDepotIds generateOrClearByDepotIds = new GenerateOrClearByDepotIds();
            generateOrClearByDepotIds.addDepotId(depot.getId());
            InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketDepotGenerate(generateOrClearByDepotIds));
        });
        this.checkboxRepeatIndefinitely.setMessage2(new Text((Component)TextHelper.translatable((String)"gui.mtr.repeat_indefinitely", (Object[])new Object[0]).data));
        this.textFieldCruisingAltitude = new TextFieldWidgetExtension(0, 0, 0, 20, 5, TextCase.DEFAULT, "[^-\\d]", String.valueOf(256));
    }

    @Override
    protected void init2() {
        this.setPositionsAndInit(this.rightPanelsX, this.f_96543_ / 4 * 3, this.f_96543_);
        int buttonWidth = (this.f_96543_ - this.rightPanelsX) / 2;
        IDrawing.setPositionAndWidth(this.buttonEditInstructions, this.rightPanelsX, 44, buttonWidth * 2);
        IDrawing.setPositionAndWidth(this.buttonGenerateRoute, this.rightPanelsX, 64, buttonWidth * (this.showScheduleControls ? 1 : 2));
        IDrawing.setPositionAndWidth(this.buttonClearTrains, this.rightPanelsX + buttonWidth, 64, buttonWidth);
        IDrawing.setPositionAndWidth(this.checkboxRepeatIndefinitely, this.rightPanelsX, 84 + (this.showCruisingAltitude ? 24 : 0), buttonWidth * 2);
        this.checkboxRepeatIndefinitely.setChecked(((Depot)this.data).getRepeatInfinitely());
        int cruisingAltitudeTextWidth = GraphicsHolder.getTextWidth(this.cruisingAltitudeText) + 12;
        IDrawing.setPositionAndWidth(this.textFieldCruisingAltitude, this.rightPanelsX + Math.min(cruisingAltitudeTextWidth, buttonWidth * 2 - 60) + 2, 86, 56);
        this.textFieldCruisingAltitude.setText2(String.valueOf(((Depot)this.data).getCruisingAltitude()));
        if (this.showScheduleControls) {
            for (WidgetShorterSlider slider : this.sliders) {
                this.addChild(new ClickableWidget((AbstractWidget)slider));
            }
        }
        for (int i = 0; i < 24; ++i) {
            this.sliders[i].setValue((int)((Depot)this.data).getFrequency(i));
        }
        int leftWidth = this.rightPanelsX - 1;
        IDrawing.setPositionAndWidth(this.buttonUseRealTime, 0, 0, leftWidth - 60);
        IDrawing.setPositionAndWidth(this.buttonReset, leftWidth - 60, 0, 60);
        this.departuresList.y = 20;
        this.departuresList.height = this.f_96544_ - 40 - 4;
        this.departuresList.width = leftWidth;
        this.departuresList.init(this::addChild);
        IDrawing.setPositionAndWidth(this.textFieldDeparture, 2, this.f_96544_ - 20 - 2, leftWidth - 4 - 20);
        this.addChild(new ClickableWidget((AbstractWidget)this.textFieldDeparture));
        this.textFieldDeparture.setChangedListener2(text -> {
            this.buttonAddDeparture.f_93623_ = this.checkDeparture((String)text, false, false);
        });
        IDrawing.setPositionAndWidth(this.buttonAddDeparture, leftWidth - 20, this.f_96544_ - 20 - 2, 20);
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonAddDeparture));
        this.buttonAddDeparture.f_93623_ = false;
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonEditInstructions));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonGenerateRoute));
        if (this.showScheduleControls) {
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonUseRealTime));
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonReset));
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonClearTrains));
            this.addChild(new ClickableWidget((AbstractWidget)this.checkboxRepeatIndefinitely));
        }
        if (this.showCruisingAltitude) {
            this.addChild(new ClickableWidget((AbstractWidget)this.textFieldCruisingAltitude));
        }
        this.toggleRealTime();
    }

    @Override
    public void tick2() {
        super.tick2();
        this.departuresList.tick();
        this.textFieldDeparture.tick2();
        this.textFieldCruisingAltitude.tick2();
        for (int i = 0; i < 24; ++i) {
            ((Depot)this.data).setFrequency(i, this.sliders[i].getIntValue());
        }
        if (((Depot)this.data).routes.isEmpty()) {
            this.checkboxRepeatIndefinitely.f_93624_ = false;
        } else {
            Route firstRoute = (Route)MinecraftClientData.getDashboardInstance().routeIdMap.get(((Route)Utilities.getElement(((Depot)this.data).routes, 0)).getId());
            Route lastRoute = (Route)MinecraftClientData.getDashboardInstance().routeIdMap.get(((Route)Utilities.getElement(((Depot)this.data).routes, -1)).getId());
            this.checkboxRepeatIndefinitely.f_93624_ = firstRoute != null && lastRoute != null && !firstRoute.getRoutePlatforms().isEmpty() && !lastRoute.getRoutePlatforms().isEmpty() && ((RoutePlatformData)Utilities.getElement(firstRoute.getRoutePlatforms(), 0)).getPlatform().getId() == ((RoutePlatformData)Utilities.getElement(lastRoute.getRoutePlatforms(), -1)).getPlatform().getId();
        }
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        guiDrawing.beginDrawingRectangle();
        guiDrawing.drawRectangle(this.rightPanelsX - 1, 0.0, this.rightPanelsX, this.f_96544_, Integer.MAX_VALUE);
        guiDrawing.finishDrawingRectangle();
        this.renderTextFields(graphicsHolder);
        if (this.showScheduleControls && ((Depot)this.data).getUseRealTime()) {
            this.departuresList.render(graphicsHolder);
        }
        int lineHeight = Math.min(20, (this.f_96544_ - 40) / 24);
        for (int i = 0; i < 24; ++i) {
            if (this.showScheduleControls && !((Depot)this.data).getUseRealTime()) {
                graphicsHolder.drawText(EditDepotScreen.getTimeString(i), 6, 40 + lineHeight * i + (int)((float)(lineHeight - 8) / 2.0f), -1, false, GraphicsHolder.getDefaultLight());
            }
            this.sliders[i].setY2(40 + lineHeight * i);
            this.sliders[i].setHeight(lineHeight);
        }
        super.render(graphicsHolder, mouseX, mouseY, delta);
        int yStartRightPane = 44 + 20 * (this.checkboxRepeatIndefinitely.f_93624_ ? 3 : 2) + (this.showCruisingAltitude ? 24 : 0) + 6;
        if (this.showCruisingAltitude) {
            graphicsHolder.drawText(this.cruisingAltitudeText, this.rightPanelsX + 6, 92, -1, false, GraphicsHolder.getDefaultLight());
        }
        graphicsHolder.drawText(TextHelper.translatable("gui.mtr.sidings_in_depot", ((Depot)this.data).savedRails.size()), this.rightPanelsX + 6, yStartRightPane, -1, false, GraphicsHolder.getDefaultLight());
        Depot newDepot = (Depot)MinecraftClientData.getDashboardInstance().depotIdMap.get(((Depot)this.data).getId());
        if (newDepot != null) {
            String[] stringSplit = EditDepotScreen.getSuccessfulSegmentsText(newDepot).split("\\|");
            for (int i = 0; i < stringSplit.length; ++i) {
                graphicsHolder.drawText(stringSplit[i], this.rightPanelsX + 6, yStartRightPane + 40 + 14 * i, -1, false, GraphicsHolder.getDefaultLight());
            }
        }
        if (this.showScheduleControls && !((Depot)this.data).getUseRealTime()) {
            graphicsHolder.drawCenteredText(TextHelper.translatable("gui.mtr.game_time", new Object[0]), this.sliderX / 2, 26, -5592406);
            graphicsHolder.drawCenteredText(TextHelper.translatable("gui.mtr.vehicles_per_hour", new Object[0]), this.sliderX + this.sliderWidthWithText / 2, 26, -5592406);
        }
    }

    @Override
    public void mouseMoved2(double mouseX, double mouseY) {
        this.departuresList.mouseMoved(mouseX, mouseY);
    }

    @Override
    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        this.departuresList.mouseScrolled(mouseX, mouseY, amount);
        return super.mouseScrolled2(mouseX, mouseY, amount);
    }

    @Override
    protected void saveData() {
        super.saveData();
        ((Depot)this.data).setRepeatInfinitely(this.checkboxRepeatIndefinitely.f_93624_ && this.checkboxRepeatIndefinitely.isChecked2());
        try {
            ((Depot)this.data).setCruisingAltitude(Integer.parseInt(this.textFieldCruisingAltitude.getText2()));
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            ((Depot)this.data).setCruisingAltitude(256L);
        }
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addDepot((Depot)this.data)));
    }

    private void toggleRealTime() {
        for (WidgetShorterSlider slider : this.sliders) {
            slider.f_93624_ = !((Depot)this.data).getUseRealTime();
        }
        this.departuresList.x = ((Depot)this.data).getUseRealTime() ? 0 : this.f_96543_;
        this.textFieldDeparture.setX2(((Depot)this.data).getUseRealTime() ? 2 : this.f_96543_);
        this.buttonAddDeparture.f_93624_ = ((Depot)this.data).getUseRealTime();
        this.buttonUseRealTime.setMessage2(new Text((Component)TextHelper.translatable((String)(((Depot)this.data).getUseRealTime() ? "gui.mtr.schedule_mode_real_time_on" : "gui.mtr.schedule_mode_real_time_off"), (Object[])new Object[0]).data));
        this.updateList();
    }

    private void onDeleteDeparture(DashboardListItem dashboardListItem, int index) {
        this.checkDeparture(dashboardListItem.getName(false), false, true);
        this.saveData();
    }

    private void updateList() {
        ObjectArrayList<DashboardListItem> departureData = new ObjectArrayList<DashboardListItem>();
        long offset = System.currentTimeMillis() / 86400000L * 86400000L;
        ((Depot)this.data).getRealTimeDepartures().longStream().mapToObj(departure -> {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(departure + offset);
            return calendar;
        }).sorted(Comparator.comparingInt(calendar -> {
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            return hour * 3600 + minute * 60 + second;
        })).forEach(calendar -> {
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            departureData.add(new DashboardListItem(0L, String.format("%2s:%2s:%2s", hour, minute, second).replace(' ', '0'), 0));
        });
        this.departuresList.setData(departureData, false, false, false, false, false, true);
    }

    private boolean checkDeparture(String text, boolean addToList, boolean removeFromList) {
        try {
            int interval;
            int multiple;
            String[] departureSplit = text.replace(" ", "").split("\\+");
            String[] timeSplit1 = departureSplit[0].split(":");
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, Integer.parseInt(timeSplit1[0]) % 24);
            calendar.set(12, Integer.parseInt(timeSplit1[1]) % 60);
            calendar.set(13, Integer.parseInt(timeSplit1[2]) % 60);
            calendar.set(14, 0);
            int departure = (int)(calendar.getTimeInMillis() % 86400000L);
            if (departureSplit.length > 1) {
                String[] intervalSplit = departureSplit[1].split("\\*");
                multiple = Integer.parseInt(intervalSplit[0]) + 1;
                String[] timeSplit2 = intervalSplit[1].split(":");
                interval = (Integer.parseInt(timeSplit2[0]) * 3600 + Integer.parseInt(timeSplit2[1]) * 60 + Integer.parseInt(timeSplit2[2])) * 1000;
            } else {
                multiple = 1;
                interval = 0;
            }
            if (addToList || removeFromList) {
                for (int i = 0; i < multiple; ++i) {
                    int rawDeparture = (departure + i * interval) % 86400000;
                    if (addToList) {
                        if (((Depot)this.data).getRealTimeDepartures().contains(rawDeparture)) continue;
                        ((Depot)this.data).getRealTimeDepartures().add(rawDeparture);
                        continue;
                    }
                    ((Depot)this.data).getRealTimeDepartures().rem(rawDeparture);
                }
                this.updateList();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String getSuccessfulSegmentsText(Depot depot) {
        long lastGeneratedMillis = depot.getLastGeneratedMillis();
        if (lastGeneratedMillis == 0L) {
            return "";
        }
        long timeDifference = System.currentTimeMillis() - lastGeneratedMillis;
        StringBuilder stringBuilder = new StringBuilder(TextHelper.translatable("gui.mtr.path_refresh_time", EditDepotScreen.getTimeDifferenceString(timeDifference)).getString()).append("|").append(DateFormat.getDateTimeInstance().format(new Date(lastGeneratedMillis))).append("||");
        switch (depot.getLastGeneratedStatus()) {
            case SUCCESSFUL: {
                stringBuilder.append(TextHelper.translatable("gui.mtr.path_found", new Object[0]).getString());
                break;
            }
            case NO_SIDINGS: {
                stringBuilder.append(TextHelper.translatable("gui.mtr.path_not_generated_no_sidings", new Object[0]).getString());
                break;
            }
            case TWO_PLATFORMS_REQUIRED: {
                stringBuilder.append(TextHelper.translatable("gui.mtr.path_not_generated_platforms", new Object[0]).getString());
            }
        }
        depot.getFailedPlatformIds((lastGeneratedFailedStartId, lastGeneratedFailedEndId) -> stringBuilder.append(TextHelper.translatable("gui.mtr.path_not_found_between", EditDepotScreen.getRoute(depot, lastGeneratedFailedStartId, lastGeneratedFailedEndId), EditDepotScreen.getStation(lastGeneratedFailedStartId), EditDepotScreen.getStation(lastGeneratedFailedEndId)).getString()), lastGeneratedFailedSidingCount -> stringBuilder.append("|").append(TextHelper.translatable("gui.mtr.path_not_found_sidings", lastGeneratedFailedSidingCount).getString()));
        return stringBuilder.toString();
    }

    private static String getSliderString(int value) {
        Object headwayText = value == 0 ? "" : " (" + Utilities.round(200.0f / (float)value, 1) + TextHelper.translatable("gui.mtr.s", new Object[0]).getString() + ")";
        return (float)value / 4.0f + TextHelper.translatable("gui.mtr.tph", new Object[0]).getString() + (String)headwayText;
    }

    private static String getTimeString(int hour) {
        String hourString = StringUtils.leftPad((String)String.valueOf(hour), (int)2, (String)"0");
        return String.format("%s:00-%s:59", hourString, hourString);
    }

    private static String getTimeDifferenceString(long timeDifference) {
        MutableText mutableText = timeDifference >= 86400000L ? TextHelper.translatable("gui.mtr.days", timeDifference / 86400000L) : (timeDifference >= 3600000L ? TextHelper.translatable("gui.mtr.hours", timeDifference / 3600000L) : (timeDifference >= 60000L ? TextHelper.translatable("gui.mtr.minutes", timeDifference / 60000L) : TextHelper.translatable("gui.mtr.seconds", timeDifference / 1000L)));
        return mutableText.getString();
    }

    private static String getRoute(Depot depot, long lastGeneratedFailedStartId, long lastGeneratedFailedEndId) {
        long previousId = 0L;
        String previousRouteName = "";
        for (Route route : depot.routes) {
            for (RoutePlatformData routePlatform : route.getRoutePlatforms()) {
                long thisId = routePlatform.platform.getId();
                if (previousId == lastGeneratedFailedStartId && thisId == lastGeneratedFailedEndId) {
                    return IGui.formatStationName(previousRouteName);
                }
                previousId = thisId;
            }
            previousRouteName = route.getName();
        }
        return IGui.formatStationName("");
    }

    private static String getStation(long platformId) {
        Platform platform = (Platform)MinecraftClientData.getDashboardInstance().platformIdMap.get(platformId);
        Station station = platform == null ? null : (Station)platform.area;
        return IGui.formatStationName(station == null ? "" : station.getName());
    }
}

