/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import org.mtr.core.data.Route;
import org.mtr.core.data.RoutePlatformData;
import org.mtr.core.data.RouteType;
import org.mtr.core.data.Station;
import org.mtr.core.operation.UpdateDataRequest;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.screen.DashboardScreen;
import org.mtr.mod.screen.EditNameColorScreenBase;

public class EditRouteScreen
extends EditNameColorScreenBase<Route>
implements IGui {
    private final MutableText lightRailRouteNumberText = TextHelper.translatable("gui.mtr.light_rail_route_number", new Object[0]);
    private final TextFieldWidgetExtension textFieldLightRailRouteNumber = new TextFieldWidgetExtension(0, 0, 0, 20, 256, TextCase.DEFAULT, null, null);
    private final ButtonWidgetExtension buttonRouteType = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.mtr.add_value", new Object[0]), button -> this.setRouteType(route, route.getRouteType().next()));
    private final CheckboxWidgetExtension buttonIsRouteHidden = new CheckboxWidgetExtension(0, 0, 0, 20, true, this::setIsRouteHidden);
    private final CheckboxWidgetExtension buttonDisableNextStationAnnouncements;
    private final CheckboxWidgetExtension buttonIsClockwiseRoute;
    private final CheckboxWidgetExtension buttonIsAntiClockwiseRoute;
    private final boolean isCircular;
    private static final int CHECKBOX_WIDTH = 160;

    public EditRouteScreen(Route route, DashboardScreen dashboardScreen) {
        super(route, dashboardScreen, "gui.mtr.route_name", "gui.mtr.route_color");
        this.buttonIsRouteHidden.setMessage2(new Text((Component)TextHelper.translatable((String)"gui.mtr.is_route_hidden", (Object[])new Object[0]).data));
        this.buttonDisableNextStationAnnouncements = new CheckboxWidgetExtension(0, 0, 0, 20, true, this::setDisableNextStationAnnouncements);
        this.buttonDisableNextStationAnnouncements.setMessage2(new Text((Component)TextHelper.translatable((String)"gui.mtr.disable_next_station_announcements", (Object[])new Object[0]).data));
        this.buttonIsClockwiseRoute = new CheckboxWidgetExtension(0, 0, 0, 20, true, this::setIsClockwise);
        this.buttonIsClockwiseRoute.setMessage2(new Text((Component)TextHelper.translatable((String)"gui.mtr.is_clockwise_route", (Object[])new Object[0]).data));
        this.buttonIsAntiClockwiseRoute = new CheckboxWidgetExtension(0, 0, 0, 20, true, this::setIsAntiClockwise);
        this.buttonIsAntiClockwiseRoute.setMessage2(new Text((Component)TextHelper.translatable((String)"gui.mtr.is_anticlockwise_route", (Object[])new Object[0]).data));
        if (!route.getRoutePlatforms().isEmpty()) {
            Station firstStation = (Station)((RoutePlatformData)Utilities.getElement(route.getRoutePlatforms(), (int)0)).platform.area;
            Station lastStation = (Station)((RoutePlatformData)Utilities.getElement(route.getRoutePlatforms(), (int)-1)).platform.area;
            this.isCircular = firstStation != null && lastStation != null && firstStation.getId() == lastStation.getId();
        } else {
            this.isCircular = false;
        }
    }

    @Override
    protected void init2() {
        this.setPositionsAndInit(20, this.f_96543_ / 4 * 3 - 20, this.f_96543_ - 20);
        IDrawing.setPositionAndWidth(this.buttonRouteType, 20, 60, 160);
        this.setRouteType((Route)this.data, ((Route)this.data).getRouteType());
        IDrawing.setPositionAndWidth(this.buttonIsRouteHidden, 20, 80, 160);
        IDrawing.setPositionAndWidth(this.buttonDisableNextStationAnnouncements, 20, 100, 160);
        IDrawing.setPositionAndWidth(this.textFieldLightRailRouteNumber, 22, 142, 156);
        this.textFieldLightRailRouteNumber.setText2(((Route)this.data).getRouteNumber());
        IDrawing.setPositionAndWidth(this.buttonIsClockwiseRoute, 20, 164, 160);
        IDrawing.setPositionAndWidth(this.buttonIsAntiClockwiseRoute, 20, 184, 160);
        if (((Route)this.data).getTransportMode().hasRouteTypeVariation) {
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonRouteType));
        }
        this.addChild(new ClickableWidget((AbstractWidget)this.textFieldLightRailRouteNumber));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonIsRouteHidden));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonDisableNextStationAnnouncements));
        if (this.isCircular) {
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonIsClockwiseRoute));
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonIsAntiClockwiseRoute));
        }
        this.setIsRouteHidden(((Route)this.data).getHidden());
        this.setIsClockwise(((Route)this.data).getCircularState() == Route.CircularState.CLOCKWISE);
        this.setIsAntiClockwise(((Route)this.data).getCircularState() == Route.CircularState.ANTICLOCKWISE);
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        try {
            this.renderBackground(graphicsHolder);
            this.renderTextFields(graphicsHolder);
            if (this.textFieldLightRailRouteNumber.f_93624_) {
                graphicsHolder.drawText(this.lightRailRouteNumberText, 20, 126, -1, false, GraphicsHolder.getDefaultLight());
            }
            super.render(graphicsHolder, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    protected void saveData() {
        super.saveData();
        ((Route)this.data).setRouteNumber(this.textFieldLightRailRouteNumber.getText2());
        ((Route)this.data).setHidden(this.buttonIsRouteHidden.isChecked2());
        if (this.isCircular) {
            ((Route)this.data).setCircularState(this.buttonIsClockwiseRoute.isChecked2() ? Route.CircularState.CLOCKWISE : (this.buttonIsAntiClockwiseRoute.isChecked2() ? Route.CircularState.ANTICLOCKWISE : Route.CircularState.NONE));
        } else {
            ((Route)this.data).setCircularState(Route.CircularState.NONE);
        }
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addRoute((Route)this.data)));
    }

    private void setRouteType(Route route, RouteType newRouteType) {
        route.setRouteType(newRouteType);
        this.buttonRouteType.setMessage2(new Text((Component)TextHelper.translatable((String)route.getRouteTypeKey(), (Object[])new Object[0]).data));
    }

    private void setIsRouteHidden(boolean isRouteHidden) {
        this.buttonIsRouteHidden.setChecked(isRouteHidden);
    }

    private void setDisableNextStationAnnouncements(boolean hasNextStationAnnouncements) {
        this.buttonDisableNextStationAnnouncements.setChecked(hasNextStationAnnouncements);
    }

    private void setIsClockwise(boolean isClockwise) {
        this.buttonIsClockwiseRoute.setChecked(isClockwise);
        if (isClockwise) {
            this.buttonIsAntiClockwiseRoute.setChecked(false);
        }
    }

    private void setIsAntiClockwise(boolean isAntiClockwise) {
        this.buttonIsAntiClockwiseRoute.setChecked(isAntiClockwise);
        if (isAntiClockwise) {
            this.buttonIsClockwiseRoute.setChecked(false);
        }
    }
}

