/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import org.mtr.core.data.Depot;
import org.mtr.core.data.Siding;
import org.mtr.core.data.TransportMode;
import org.mtr.core.operation.UpdateDataRequest;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.Icons;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.RailType;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.screen.DashboardScreen;
import org.mtr.mod.screen.SavedRailScreenBase;
import org.mtr.mod.screen.VehicleSelectorScreen;
import org.mtr.mod.screen.WidgetShorterSlider;

public class SidingScreen
extends SavedRailScreenBase<Siding, Depot>
implements Icons {
    private final ButtonWidgetExtension buttonSelectTrain = new ButtonWidgetExtension(0, 0, 0, 20, button -> MinecraftClient.getInstance().openScreen(new Screen(new VehicleSelectorScreen(this, (Siding)this.savedRailBase))));
    private final CheckboxWidgetExtension buttonUnlimitedTrains;
    private final TextFieldWidgetExtension textFieldMaxTrains;
    private final WidgetShorterSlider sliderAccelerationConstant;
    private final WidgetShorterSlider sliderDecelerationConstant;
    private final WidgetShorterSlider sliderDelayedVehicleSpeedIncreasePercentage;
    private final WidgetShorterSlider sliderDelayedVehicleReduceDwellTimePercentage;
    private final CheckboxWidgetExtension buttonIsManual;
    private final WidgetShorterSlider sliderMaxManualSpeed;
    private static final MutableText SELECTED_TRAIN_TEXT = TextHelper.translatable("gui.mtr.selected_vehicle", new Object[0]);
    private static final MutableText MAX_TRAINS_TEXT = TextHelper.translatable("gui.mtr.max_vehicles", new Object[0]);
    private static final MutableText ACCELERATION_CONSTANT_TEXT = TextHelper.translatable("gui.mtr.acceleration", new Object[0]);
    private static final MutableText DECELERATION_CONSTANT_TEXT = TextHelper.translatable("gui.mtr.deceleration", new Object[0]);
    private static final MutableText DELAYED_VEHICLE_SPEED_INCREASE_PERCENTAGE_TEXT = TextHelper.translatable("gui.mtr.delayed_vehicle_speed_increase_percentage", new Object[0]);
    private static final MutableText DELAYED_VEHICLE_REDUCE_DWELL_TIME_PERCENTAGE_TEXT = TextHelper.translatable("gui.mtr.delayed_vehicle_reduce_dwell_time_percentage", new Object[0]);
    private static final MutableText MANUAL_TO_AUTOMATIC_TIME = TextHelper.translatable("gui.mtr.manual_to_automatic_time", new Object[0]);
    private static final MutableText MAX_MANUAL_SPEED = TextHelper.translatable("gui.mtr.max_manual_speed", new Object[0]);
    private static final int MAX_TRAINS_TEXT_LENGTH = 3;
    private static final int MAX_TRAINS_WIDTH = 80;
    private static final int SLIDER_SCALE = 2500000;
    private static final float ACCELERATION_UNIT_CONVERSION_1 = 1000000.0f;
    private static final float ACCELERATION_UNIT_CONVERSION_2 = 3600000.0f;

    public SidingScreen(Siding siding, TransportMode transportMode, DashboardScreen dashboardScreen) {
        super(siding, transportMode, dashboardScreen, SELECTED_TRAIN_TEXT, MAX_TRAINS_TEXT, ACCELERATION_CONSTANT_TEXT, DECELERATION_CONSTANT_TEXT, DELAYED_VEHICLE_SPEED_INCREASE_PERCENTAGE_TEXT, DELAYED_VEHICLE_REDUCE_DWELL_TIME_PERCENTAGE_TEXT, MANUAL_TO_AUTOMATIC_TIME, MAX_MANUAL_SPEED);
        this.buttonSelectTrain.setMessage2(new Text((Component)TextHelper.translatable((String)"selectWorld.edit", (Object[])new Object[0]).data));
        this.textFieldMaxTrains = new TextFieldWidgetExtension(0, 0, 0, 20, 3, TextCase.DEFAULT, "\\D", null);
        this.sliderAccelerationConstant = new WidgetShorterSlider(0, 80, (int)Math.round(49.00000000000001), SidingScreen::accelerationSliderFormatter, null);
        this.sliderDecelerationConstant = new WidgetShorterSlider(0, 80, (int)Math.round(49.00000000000001), SidingScreen::accelerationSliderFormatter, null);
        this.sliderDelayedVehicleSpeedIncreasePercentage = new WidgetShorterSlider(0, 80, 100, SidingScreen::percentageFormatter, null);
        this.sliderDelayedVehicleReduceDwellTimePercentage = new WidgetShorterSlider(0, 80, 100, SidingScreen::percentageFormatter, null);
        this.buttonIsManual = new CheckboxWidgetExtension(0, 0, 0, 20, true, checked -> {
            if (checked.booleanValue() && !this.textFieldMaxTrains.getText2().equals("1")) {
                this.textFieldMaxTrains.setText2("1");
            }
            this.setButtons();
        });
        this.buttonIsManual.setMessage2(new Text((Component)TextHelper.translatable((String)"gui.mtr.is_manual", (Object[])new Object[0]).data));
        this.sliderMaxManualSpeed = new WidgetShorterSlider(0, 80, RailType.DIAMOND.ordinal(), SidingScreen::speedSliderFormatter, null);
        this.buttonUnlimitedTrains = new CheckboxWidgetExtension(0, 0, 0, 20, true, checked -> {
            if (checked.booleanValue()) {
                this.buttonIsManual.setChecked(false);
                this.setButtons();
            }
            if (checked.booleanValue() && !this.textFieldMaxTrains.getText2().isEmpty()) {
                this.textFieldMaxTrains.setText2("");
            } else if (!checked.booleanValue() && this.textFieldMaxTrains.getText2().isEmpty()) {
                this.textFieldMaxTrains.setText2("1");
            }
        });
        this.buttonUnlimitedTrains.setMessage2(new Text((Component)TextHelper.translatable((String)"gui.mtr.unlimited_vehicles", (Object[])new Object[0]).data));
    }

    @Override
    protected void init2() {
        super.init2();
        IDrawing.setPositionAndWidth(this.buttonSelectTrain, 20 + this.textWidth, 44, this.f_96543_ - this.textWidth - 40);
        IDrawing.setPositionAndWidth(this.buttonUnlimitedTrains, 20 + this.textWidth + 80 + 6, 66, this.f_96543_ - this.textWidth - 40);
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonSelectTrain));
        this.buttonIsManual.setChecked(((Siding)this.savedRailBase).getIsManual());
        this.buttonUnlimitedTrains.setChecked(((Siding)this.savedRailBase).getIsUnlimited());
        IDrawing.setPositionAndWidth(this.textFieldMaxTrains, 20 + this.textWidth + 2, 66, 76);
        this.textFieldMaxTrains.setText2(((Siding)this.savedRailBase).getIsUnlimited() ? "" : String.valueOf(((Siding)this.savedRailBase).getMaxVehicles()));
        this.textFieldMaxTrains.setChangedListener2(text -> {
            this.buttonUnlimitedTrains.setChecked(text.isEmpty());
            if (!text.equals("1")) {
                this.buttonIsManual.setChecked(false);
                this.setButtons();
            }
        });
        this.sliderAccelerationConstant.setX2(20 + this.textWidth);
        this.sliderAccelerationConstant.setY2(88);
        this.sliderAccelerationConstant.setHeight(20);
        this.sliderAccelerationConstant.setValue((int)Math.round((((Siding)this.savedRailBase).getAcceleration() - 4.0E-7) * 2500000.0));
        this.sliderDecelerationConstant.setX2(20 + this.textWidth);
        this.sliderDecelerationConstant.setY2(108);
        this.sliderDecelerationConstant.setHeight(20);
        this.sliderDecelerationConstant.setValue((int)Math.round((((Siding)this.savedRailBase).getDeceleration() - 4.0E-7) * 2500000.0));
        this.sliderDelayedVehicleSpeedIncreasePercentage.setX2(20 + this.textWidth);
        this.sliderDelayedVehicleSpeedIncreasePercentage.setY2(128);
        this.sliderDelayedVehicleSpeedIncreasePercentage.setHeight(20);
        this.sliderDelayedVehicleSpeedIncreasePercentage.setValue(((Siding)this.savedRailBase).getDelayedVehicleSpeedIncreasePercentage());
        this.sliderDelayedVehicleReduceDwellTimePercentage.setX2(20 + this.textWidth);
        this.sliderDelayedVehicleReduceDwellTimePercentage.setY2(148);
        this.sliderDelayedVehicleReduceDwellTimePercentage.setHeight(20);
        this.sliderDelayedVehicleReduceDwellTimePercentage.setValue(((Siding)this.savedRailBase).getDelayedVehicleReduceDwellTimePercentage());
        IDrawing.setPositionAndWidth(this.buttonIsManual, 20, 168, this.f_96543_ - this.textWidth - 40);
        this.sliderMaxManualSpeed.setX2(20 + this.textWidth);
        this.sliderMaxManualSpeed.setY2(188);
        this.sliderMaxManualSpeed.setHeight(20);
        this.sliderMaxManualSpeed.setValue(0);
        this.sliderDwellTimeMin.setY2(208);
        this.sliderDwellTimeSec.setY2(218);
        if (this.showScheduleControls) {
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonUnlimitedTrains));
            this.addChild(new ClickableWidget((AbstractWidget)this.textFieldMaxTrains));
            this.addChild(new ClickableWidget((AbstractWidget)this.sliderAccelerationConstant));
            this.addChild(new ClickableWidget((AbstractWidget)this.sliderDecelerationConstant));
            this.addChild(new ClickableWidget((AbstractWidget)this.sliderDelayedVehicleSpeedIncreasePercentage));
            this.addChild(new ClickableWidget((AbstractWidget)this.sliderDelayedVehicleReduceDwellTimePercentage));
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonIsManual));
            this.addChild(new ClickableWidget((AbstractWidget)this.sliderMaxManualSpeed));
        }
        this.setButtons();
    }

    @Override
    public void tick2() {
        super.tick2();
        this.textFieldMaxTrains.tick2();
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        super.render(graphicsHolder, mouseX, mouseY, delta);
        graphicsHolder.drawText(SELECTED_TRAIN_TEXT, 20, 50, -1, false, GraphicsHolder.getDefaultLight());
        if (this.showScheduleControls) {
            graphicsHolder.drawText(MAX_TRAINS_TEXT, 20, 72, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(ACCELERATION_CONSTANT_TEXT, 20, 94, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(DECELERATION_CONSTANT_TEXT, 20, 114, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(DELAYED_VEHICLE_SPEED_INCREASE_PERCENTAGE_TEXT, 20, 134, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(DELAYED_VEHICLE_REDUCE_DWELL_TIME_PERCENTAGE_TEXT, 20, 154, -1, false, GraphicsHolder.getDefaultLight());
            if (this.buttonIsManual.isChecked2()) {
                graphicsHolder.drawText(MAX_MANUAL_SPEED, 20, 194, -1, false, GraphicsHolder.getDefaultLight());
                graphicsHolder.drawText(MANUAL_TO_AUTOMATIC_TIME, 20, 214, -1, false, GraphicsHolder.getDefaultLight());
            }
        }
    }

    @Override
    public void onClose2() {
        double decelerationConstant;
        double accelerationConstant;
        int maxTrains;
        try {
            maxTrains = Math.max(0, Integer.parseInt(this.textFieldMaxTrains.getText2()));
        }
        catch (Exception ignored) {
            maxTrains = 0;
        }
        try {
            accelerationConstant = Utilities.round(MathHelper.clamp((double)((float)this.sliderAccelerationConstant.getIntValue() / 2500000.0f) + 4.0E-7, 4.0E-7, 2.0E-5), 8);
        }
        catch (Exception ignored) {
            accelerationConstant = 4.0E-6;
        }
        try {
            decelerationConstant = Utilities.round(MathHelper.clamp((double)((float)this.sliderDecelerationConstant.getIntValue() / 2500000.0f) + 4.0E-7, 4.0E-7, 2.0E-5), 8);
        }
        catch (Exception ignored) {
            decelerationConstant = 4.0E-6;
        }
        if (this.buttonIsManual.isChecked2()) {
            ((Siding)this.savedRailBase).setIsManual(true);
        } else if (this.buttonUnlimitedTrains.isChecked2()) {
            ((Siding)this.savedRailBase).setUnlimitedVehicles(true);
        } else {
            ((Siding)this.savedRailBase).setMaxVehicles(maxTrains);
        }
        ((Siding)this.savedRailBase).setAcceleration(accelerationConstant);
        ((Siding)this.savedRailBase).setDeceleration(decelerationConstant);
        ((Siding)this.savedRailBase).setDelayedVehicleSpeedIncreasePercentage(this.sliderDelayedVehicleSpeedIncreasePercentage.getIntValue());
        ((Siding)this.savedRailBase).setDelayedVehicleReduceDwellTimePercentage(this.sliderDelayedVehicleReduceDwellTimePercentage.getIntValue());
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addSiding((Siding)this.savedRailBase)));
        super.onClose2();
    }

    @Override
    protected String getNumberStringKey() {
        return "gui.mtr.siding_number";
    }

    private void setButtons() {
        this.sliderMaxManualSpeed.f_93624_ = this.buttonIsManual.isChecked2();
        this.sliderDwellTimeMin.f_93624_ = this.buttonIsManual.isChecked2();
        this.sliderDwellTimeSec.f_93624_ = this.buttonIsManual.isChecked2();
    }

    private static String accelerationSliderFormatter(int value) {
        double valueMeterPerMillisecondSquared = (double)value / 2500000.0 + 4.0E-7;
        return String.format("%s m/s\u00b2 (%s km/h/s)", Utilities.round(valueMeterPerMillisecondSquared * 1000000.0, 1), Utilities.round(valueMeterPerMillisecondSquared * 3600000.0, 1));
    }

    private static String percentageFormatter(int value) {
        return value + "%";
    }

    private static String speedSliderFormatter(int value) {
        RailType railType = SidingScreen.convertMaxManualSpeed(value);
        return railType == null ? TextHelper.translatable("gui.mtr.unlimited", new Object[0]).getString() : String.format("%s km/h", railType.speedLimit);
    }

    private static RailType convertMaxManualSpeed(int maxManualSpeed) {
        if (maxManualSpeed >= 0 && maxManualSpeed <= RailType.DIAMOND.ordinal()) {
            return RailType.values()[maxManualSpeed];
        }
        return null;
    }
}

