/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.sound;

import java.util.Random;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.SoundHelper;
import org.mtr.mod.InitClient;
import org.mtr.mod.sound.VehicleSoundBase;

public class LegacyVehicleSound
extends VehicleSoundBase {
    private final String legacySpeedSoundBaseResource;
    private final int legacySpeedSoundCount;
    private final boolean legacyUseAccelerationSoundsWhenCoasting;
    private final boolean legacyConstantPlaybackSpeed;
    private final String legacyDoorSoundBaseResource;
    private final double legacyDoorCloseSoundTime;
    private final char[] SOUND_GROUP_LETTERS = new char[]{'a', 'b', 'c'};
    private final int SOUND_GROUP_SIZE = this.SOUND_GROUP_LETTERS.length;
    private static final String SOUND_ACCELERATION = "_acceleration_";
    private static final String SOUND_DECELERATION = "_deceleration_";
    private static final String SOUND_DOOR_OPEN = "_door_open";
    private static final String SOUND_DOOR_CLOSE = "_door_close";

    public LegacyVehicleSound(@Nullable String legacySpeedSoundBaseResource, int legacySpeedSoundCount, boolean legacyUseAccelerationSoundsWhenCoasting, boolean legacyConstantPlaybackSpeed, String legacyDoorSoundBaseResource, double legacyDoorCloseSoundTime) {
        this.legacySpeedSoundBaseResource = legacySpeedSoundBaseResource;
        this.legacySpeedSoundCount = legacySpeedSoundCount;
        this.legacyUseAccelerationSoundsWhenCoasting = legacyUseAccelerationSoundsWhenCoasting;
        this.legacyConstantPlaybackSpeed = legacyConstantPlaybackSpeed;
        this.legacyDoorSoundBaseResource = legacyDoorSoundBaseResource;
        this.legacyDoorCloseSoundTime = legacyDoorCloseSoundTime;
    }

    @Override
    public void playMotorSound(int bogieIndex, BlockPos blockPos, float speed, float speedChange, float acceleration, boolean isOnRoute) {
        double referenceAcceleration;
        int floorSpeed;
        if (!InitClient.canPlaySound()) {
            return;
        }
        if (this.legacySpeedSoundCount > 0 && this.legacySpeedSoundBaseResource != null && (floorSpeed = (int)Math.floor((double)speed / (referenceAcceleration = this.legacyConstantPlaybackSpeed ? (double)acceleration : 4.0E-6) / 200.0)) > 0) {
            Random random = new Random();
            int index = Math.min(floorSpeed, this.legacySpeedSoundCount) - 1;
            boolean isAccelerating = speedChange == 0.0f ? this.legacyUseAccelerationSoundsWhenCoasting || random.nextBoolean() : speedChange > 0.0f;
            String speedSoundId = this.legacySpeedSoundBaseResource + (isAccelerating ? SOUND_ACCELERATION : SOUND_DECELERATION) + index / this.SOUND_GROUP_SIZE + this.SOUND_GROUP_LETTERS[index % this.SOUND_GROUP_SIZE];
            LegacyVehicleSound.playSoundInWorld(SoundHelper.createSoundEvent(new Identifier("mtr", speedSoundId)), blockPos, 1.0f, 1.0f);
        }
    }

    @Override
    protected void playDoorSound(BlockPos blockPos, boolean isOpen) {
        LegacyVehicleSound.playSoundInWorld(SoundHelper.createSoundEvent(new Identifier("mtr", String.format("%s%s", this.legacyDoorSoundBaseResource, isOpen ? SOUND_DOOR_OPEN : SOUND_DOOR_CLOSE))), blockPos, 2.0f, 1.0f);
    }

    @Override
    protected double getDoorCloseSoundTime() {
        return this.legacyDoorCloseSoundTime;
    }
}

