/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.sound;

import javax.annotation.Nullable;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.SoundCategory;
import org.mtr.mapping.holder.SoundEvent;

public abstract class VehicleSoundBase {
    public abstract void playMotorSound(int var1, BlockPos var2, float var3, float var4, float var5, boolean var6);

    public final void playDoorSound(BlockPos blockPos, double doorValue, double oldDoorValue) {
        if (doorValue > 0.0 && oldDoorValue == 0.0) {
            this.playDoorSound(blockPos, true);
        }
        if (doorValue < this.getDoorCloseSoundTime() && oldDoorValue >= this.getDoorCloseSoundTime()) {
            this.playDoorSound(blockPos, false);
        }
    }

    protected abstract void playDoorSound(BlockPos var1, boolean var2);

    protected abstract double getDoorCloseSoundTime();

    protected static void playSoundInWorld(@Nullable SoundEvent soundEvent, BlockPos blockPos, float gain, float pitch) {
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld != null && soundEvent != null) {
            clientWorld.playSoundAtBlockCenter(blockPos, soundEvent, SoundCategory.getBlocksMapped(), Math.min(1.0f, gain), pitch, false);
        }
    }

    protected static void playSoundInWorld(@Nullable SoundEvent soundEvent, BlockPos blockPos) {
        VehicleSoundBase.playSoundInWorld(soundEvent, blockPos, 1.0f, 1.0f);
    }
}

