/*
 * Decompiled with CFR 0.152.
 */
package com.anar4732.opf;

import com.mojang.math.Vector3d;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import team.creative.creativecore.common.util.math.box.AlignedBox;

public class Utils {
    public static VoxelShape toVoxelShape(AlignedBox box) {
        return Shapes.m_83048_((double)box.minX, (double)box.minY, (double)box.minZ, (double)box.maxX, (double)box.maxY, (double)box.maxZ);
    }

    public static AlignedBox rotateCube(AlignedBox cube, Direction direction) {
        return Utils.rotateCube(cube, direction, new Vector3d(0.5, 0.5, 0.5));
    }

    public static AlignedBox rotateCube(AlignedBox cube, Direction direction, Vector3d center) {
        AlignedBox rotateCube = new AlignedBox(cube);
        Utils.applyCubeRotation(rotateCube, direction, center);
        return rotateCube;
    }

    public static Vector3d applyVectorRotation(Vector3d vector, Direction direction) {
        double tempX = vector.f_86214_;
        double tempY = vector.f_86215_;
        double tempZ = vector.f_86216_;
        double posX = tempX;
        double posY = tempY;
        double posZ = tempZ;
        switch (direction) {
            case UP: {
                posX = -tempY;
                posY = tempX;
                break;
            }
            case DOWN: {
                posX = tempY;
                posY = -tempX;
                break;
            }
            case SOUTH: {
                posX = -tempZ;
                posZ = tempX;
                break;
            }
            case NORTH: {
                posX = tempZ;
                posZ = -tempX;
                break;
            }
            case WEST: {
                posX = -tempX;
                posZ = -tempZ;
            }
        }
        return new Vector3d(posX, posY, posZ);
    }

    public static void applyCubeRotation(AlignedBox cube, Direction direction, Vector3d center) {
        float minX = cube.minX;
        float minY = cube.minY;
        float minZ = cube.minZ;
        float maxX = cube.maxX;
        float maxY = cube.maxY;
        float maxZ = cube.maxZ;
        if (center != null) {
            minX = (float)((double)minX - center.f_86214_);
            minY = (float)((double)minY - center.f_86215_);
            minZ = (float)((double)minZ - center.f_86216_);
            maxX = (float)((double)maxX - center.f_86214_);
            maxY = (float)((double)maxY - center.f_86215_);
            maxZ = (float)((double)maxZ - center.f_86216_);
        }
        Vector3d min = Utils.applyVectorRotation(new Vector3d((double)minX, (double)minY, (double)minZ), direction);
        Vector3d max = Utils.applyVectorRotation(new Vector3d((double)maxX, (double)maxY, (double)maxZ), direction);
        if (center != null) {
            min.m_176291_(new Vector3d(center.f_86214_, center.f_86215_, center.f_86216_));
            max.m_176291_(new Vector3d(center.f_86214_, center.f_86215_, center.f_86216_));
        }
        if (min.f_86214_ < max.f_86214_) {
            cube.minX = (float)min.f_86214_;
            cube.maxX = (float)max.f_86214_;
        } else {
            cube.minX = (float)max.f_86214_;
            cube.maxX = (float)min.f_86214_;
        }
        if (min.f_86215_ < max.f_86215_) {
            cube.minY = (float)min.f_86215_;
            cube.maxY = (float)max.f_86215_;
        } else {
            cube.minY = (float)max.f_86215_;
            cube.maxY = (float)min.f_86215_;
        }
        if (min.f_86216_ < max.f_86216_) {
            cube.minZ = (float)min.f_86216_;
            cube.maxZ = (float)max.f_86216_;
        } else {
            cube.minZ = (float)max.f_86216_;
            cube.maxZ = (float)min.f_86216_;
        }
    }
}

