/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc;

import com.hypherionmc.craterlib.core.platform.ModloaderEnvironment;
import com.hypherionmc.craterlib.nojang.client.BridgedMinecraft;
import com.hypherionmc.craterlib.nojang.client.multiplayer.BridgedClientLevel;
import com.hypherionmc.craterlib.nojang.client.multiplayer.BridgedServerData;
import com.hypherionmc.craterlib.nojang.core.BridgedBlockPos;
import com.hypherionmc.craterlib.nojang.realmsclient.dto.BridgedRealmsServer;
import com.hypherionmc.craterlib.nojang.resources.ResourceIdentifier;
import com.hypherionmc.craterlib.utils.ChatUtils;
import java.util.concurrent.atomic.AtomicReference;
import me.hypherionmc.simplerpc.SimpleRPCClient;
import me.hypherionmc.simplerpc.core.RPCConstants;
import me.hypherionmc.simplerpc.core.discord.RichPresenceVariables;
import me.hypherionmc.simplerpc.core.integrations.known.KnownBiomeHelper;
import me.hypherionmc.simplerpc.core.integrations.known.KnownDimensionHelper;
import me.hypherionmc.simplerpc.core.integrations.known.KnownServerHelpers;
import me.hypherionmc.simplerpc.core.integrations.launchers.LauncherAssets;
import me.hypherionmc.simplerpc.core.util.APIUtils;
import me.hypherionmc.simplerpc.core.util.MCTimeUtils;
import me.hypherionmc.simplerpc.core.util.MinecraftUtilHandler;
import org.apache.commons.lang3.StringUtils;
import shadow.kyori.adventure.text.Component;

public class Utils
implements MinecraftUtilHandler {
    private final BridgedMinecraft mc = BridgedMinecraft.getInstance();
    public static BridgedRealmsServer realmsServer;

    @Override
    public String parseVars(String input) {
        block10: {
            input = RichPresenceVariables.MCVER.resolve(input, this.mc.getGameVersion());
            input = RichPresenceVariables.PLAYER.resolve(input, this.mc.getUserName());
            input = RichPresenceVariables.MODS.resolve(input, String.valueOf(ModloaderEnvironment.INSTANCE.getModCount()));
            input = RichPresenceVariables.PLAYER_HEAD.resolve(input, RichPresenceVariables.PLAYER_HEAD.getDefaultVal().replace("{UUID}", this.mc.getPlayerId().toString()) + "?size=512");
            if (this.mc.getLevel() != null) {
                input = RichPresenceVariables.WORLD.resolve(input, this.resolveWorldName(this.mc.getLevel()));
                input = RichPresenceVariables.DIFFICULTY.resolve(input, ChatUtils.resolve((Component)this.mc.getLevel().getDifficulty(), (boolean)false));
                input = this.mc.isSinglePlayer() && this.mc.getSinglePlayerServer() != null ? RichPresenceVariables.SAVENAME.resolve(input, this.mc.getSinglePlayerServer().getLevelName()) : RichPresenceVariables.SAVENAME.resolve(input, "Server World");
                input = RichPresenceVariables.GAME_TIME.resolve(input, MCTimeUtils.format12(this.mc.getLevel().getDayTime()));
                input = RichPresenceVariables.GAME_TIME24.resolve(input, MCTimeUtils.format24(this.mc.getLevel().getDayTime()));
                input = RichPresenceVariables.DAY.resolve(input, String.valueOf(this.mc.getLevel().dayTime() / 24000L));
            }
            if (this.mc.getPlayer() != null) {
                input = RichPresenceVariables.POSITION.resolve(input, this.getBlockPosString(this.mc.getPlayer().getOnPos()));
                input = RichPresenceVariables.BIOME.resolve(input, this.resolveBiomeName(this.mc.getPlayer().getOnPos()));
                if (this.mc.getLevel() != null) {
                    String weather = "Clear";
                    if (this.mc.getLevel().isRaining()) {
                        weather = "Raining/Snowing";
                    }
                    if (this.mc.getLevel().isThundering()) {
                        weather = "Thunderstorm";
                    }
                    input = RichPresenceVariables.WEATHER.resolve(input, weather);
                }
            }
            if (this.mc.getCurrentServer() != null && !this.mc.isRealmServer()) {
                try {
                    BridgedServerData serverData = this.mc.getCurrentServer();
                    input = RichPresenceVariables.SERVERIP.resolve(input, serverData.ip());
                    input = RichPresenceVariables.SERVER.resolve(input, serverData.ip().toLowerCase().replace(".", "_"));
                    input = RichPresenceVariables.SERVERNAME.resolve(input, KnownServerHelpers.isKnownServer(serverData.ip()) ? KnownServerHelpers.getKnownServer((String)serverData.ip()).severName : APIUtils.stringNN(serverData.name()));
                    input = RichPresenceVariables.MOTD.resolve(input, serverData.motd() != null ? ChatUtils.resolve((Component)serverData.motd(), (boolean)false) : RichPresenceVariables.MOTD.getDefaultVal());
                    input = RichPresenceVariables.SERVERICON.resolve(input, RichPresenceVariables.SERVERICON.getDefaultVal().replace("{serverurl}", serverData.ip()));
                    AtomicReference<String> inp = new AtomicReference<String>(input);
                    SimpleRPCClient.rpcCore.getSafeRunner().executeSafely(() -> {
                        int online = this.mc.getServerPlayerCount();
                        int maxOnline = serverData.getMaxPlayers();
                        inp.set(RichPresenceVariables.PLAYERS.resolve((String)inp.get(), String.valueOf(online)));
                        inp.set(RichPresenceVariables.PLAYERS_EXCL.resolve((String)inp.get(), String.valueOf(online - 1)));
                        inp.set(RichPresenceVariables.MAXPLAYERS.resolve((String)inp.get(), String.valueOf(maxOnline)));
                    }, SimpleRPCClient.rpcCore.getClientConfig().general.debugging);
                    input = inp.get();
                }
                catch (Exception e) {
                    if (!SimpleRPCClient.rpcCore.getClientConfig().general.debugging) break block10;
                    RPCConstants.logger.error(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        if (realmsServer != null && this.mc.isRealmServer()) {
            input = RichPresenceVariables.REALM_NAME.resolve(input, realmsServer.getName());
            input = RichPresenceVariables.REALM_DESCRIPTION.resolve(input, realmsServer.getDescription());
            input = RichPresenceVariables.REALM_WORLD.resolve(input, realmsServer.getWorldType().toLowerCase());
            input = RichPresenceVariables.REALM_GAME.resolve(input, realmsServer.getMinigameName());
            input = RichPresenceVariables.REALM_IMAGE.resolve(input, realmsServer.getMinigameImage());
            input = RichPresenceVariables.PLAYERS.resolve(input, String.valueOf(realmsServer.getPlayerCount()));
            input = RichPresenceVariables.MAXPLAYERS.resolve(input, "10");
        }
        if (SimpleRPCClient.rpcCore != null) {
            LauncherAssets launcherAssets = SimpleRPCClient.rpcCore.getLauncherAssets();
            input = RichPresenceVariables.LAUNCHER.resolve(input, StringUtils.capitalize((String)SimpleRPCClient.rpcCore.getLauncherType().toString().toLowerCase()));
            input = RichPresenceVariables.INSTANCE.resolve(input, launcherAssets != null ? launcherAssets.PACK_NAME : "Unknown Instance");
            input = RichPresenceVariables.LAUNCHER_NAME.resolve(input, SimpleRPCClient.rpcCore.getLauncherType().toString().toLowerCase().replace(" ", ""));
        }
        return input;
    }

    @Override
    public String getWorld() {
        if (this.mc.getLevel().getDimensionKey() != null) {
            return this.mc.getLevel().getDimensionKey().getString();
        }
        return "unknown_world";
    }

    private String resolveWorldName(BridgedClientLevel world) {
        if (this.mc.getLevel().getDimensionKey() != null) {
            String worldResKey = this.mc.getLevel().getDimensionKey().getPath();
            return KnownDimensionHelper.tryKnownDimensions(worldResKey).equalsIgnoreCase(worldResKey) ? APIUtils.worldNameToReadable(worldResKey) : KnownDimensionHelper.tryKnownDimensions(worldResKey);
        }
        return "Unknown World";
    }

    private String resolveBiomeName(BridgedBlockPos pos) {
        AtomicReference<String> biome = new AtomicReference<String>("Unknown Biome");
        if (this.mc.getLevel() != null && this.mc.getLevel().getBiomeIdentifier(pos) != null) {
            ResourceIdentifier location = this.mc.getLevel().getBiomeIdentifier(pos);
            if (KnownBiomeHelper.tryKnownBiomes(location.getPath()).equalsIgnoreCase(location.getPath())) {
                biome.set(ChatUtils.resolve((Component)ChatUtils.getBiomeName((ResourceIdentifier)location), (boolean)false));
            } else {
                biome.set(KnownBiomeHelper.tryKnownBiomes(location.getPath()));
            }
        }
        return biome.get();
    }

    public String getBlockPosString(BridgedBlockPos pos) {
        return "x: " + pos.getX() + ", y:" + pos.getY() + ", z:" + pos.getZ();
    }

    @Override
    public String getBiome() {
        AtomicReference<String> biome = new AtomicReference<String>("unknown");
        if (this.mc.getLevel() != null && this.mc.getLevel().getBiomeIdentifier(BridgedMinecraft.getInstance().getPlayer().getOnPos()) != null) {
            ResourceIdentifier location = this.mc.getLevel().getBiomeIdentifier(BridgedMinecraft.getInstance().getPlayer().getOnPos());
            biome.set(location.getString());
        }
        return biome.get();
    }
}

