/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc.core.configuration.presence;

import com.hypherionmc.craterlib.core.config.annotations.HideFromScreen;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.hypherionmc.simplerpc.core.configuration.objects.Dimension;
import me.hypherionmc.simplerpc.core.configuration.objects.RPCButton;
import me.hypherionmc.simplerpc.core.discord.RichPresenceBuilder;
import me.hypherionmc.simplerpc.core.discord.RichPresenceCore;
import me.hypherionmc.simplerpc.core.integrations.launchers.LauncherUtils;
import me.hypherionmc.simplerpc.core.util.APIUtils;
import me.hypherionmc.simplerpc.core.util.RPCContainer;
import shadow.hypherionmc.moonconfig.core.conversion.Path;
import shadow.hypherionmc.moonconfig.core.conversion.SpecComment;
import shadow.hypherionmc.moonconfig.core.fields.RandomArrayList;

public class SinglePlayerSection
implements RPCContainer {
    @Path(value="enabled")
    @SpecComment(value="Enable/Disable the Single Player Event")
    public boolean enabled = true;
    @Path(value="description")
    @SpecComment(value="The first line of text under the app name")
    public String description = "Currently In %world%";
    @Path(value="state")
    @SpecComment(value="The second line of text under the app name")
    public String state = "Playing lonely mode";
    @Path(value="largeImageKey")
    @SpecComment(value="The Asset ID of the image to display as the large image")
    @HideFromScreen
    public RandomArrayList<String> largeImageKey = RandomArrayList.of((Object[])new String[]{"mclogonew"});
    @Path(value="largeImageText")
    @SpecComment(value="The text that gets displayed when the large image is hovered")
    public String largeImageText = "It's Minecraft %mcver%, but modded";
    @Path(value="smallImageKey")
    @SpecComment(value="The Asset ID of the image to display as the small image")
    @HideFromScreen
    public RandomArrayList<String> smallImageKey = RandomArrayList.of((Object[])new String[]{"mclogo"});
    @Path(value="smallImageText")
    @SpecComment(value="The text that gets displayed when the small image is hovered")
    public String smallImageText = "%mods% mods installed";
    @Path(value="buttons")
    @SpecComment(value="The buttons to display on Discord")
    @HideFromScreen
    public List<RPCButton> buttonsList = new ArrayList<RPCButton>();

    @Override
    public RichPresenceBuilder buildPresence(RichPresenceCore core) {
        RichPresenceBuilder build = new RichPresenceBuilder().setDetails(core.getUtilHandler().parseVarsInternal(this.description, core.getClientConfig().variablesConfig)).setLargeImage(core.getUtilHandler().parseVarsInternal(this.largeImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig)).setLargeImageText(core.getUtilHandler().parseVarsInternal(this.largeImageText, core.getClientConfig().variablesConfig)).setSmallImage(core.getUtilHandler().parseVarsInternal(this.smallImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig)).setSmallImageText(core.getUtilHandler().parseVarsInternal(this.smallImageText, core.getClientConfig().variablesConfig)).setTimeStamp(OffsetDateTime.now()).setButtons(APIUtils.parseButtons(this.buttonsList, core.getUtilHandler(), core.getClientConfig().variablesConfig)).setState(core.getUtilHandler().parseVarsInternal(this.state, core.getClientConfig().variablesConfig));
        build = LauncherUtils.getLauncherOverrides(build, core);
        if (core.getClientConfig().dimension_overrides.enabled) {
            RichPresenceBuilder finalBuild = build;
            Optional<Dimension> dimension = APIUtils.findDimension(core.getClientConfig().dimension_overrides.dimensions, core.getUtilHandler().getWorld(), core.getUtilHandler().getBiome());
            if (dimension.isPresent()) {
                Dimension dim = dimension.get();
                if (dim.description != null && !dim.description.isEmpty()) {
                    finalBuild.setDetails(core.getUtilHandler().parseVarsInternal(dim.description, core.getClientConfig().variablesConfig));
                }
                if (dim.state != null && !dim.state.isEmpty()) {
                    finalBuild.setState(core.getUtilHandler().parseVarsInternal(dim.state, core.getClientConfig().variablesConfig));
                }
                if (dim.largeImageKey != null && !dim.largeImageKey.getNextRandom().orElse("").isEmpty()) {
                    finalBuild.setLargeImage(core.getUtilHandler().parseVarsInternal(dim.largeImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig));
                }
                if (dim.largeImageText != null && !dim.largeImageText.isEmpty()) {
                    finalBuild.setLargeImageText(core.getUtilHandler().parseVarsInternal(dim.largeImageText, core.getClientConfig().variablesConfig));
                }
                if (dim.smallImageKey != null && !dim.smallImageKey.getNextRandom().orElse("").isEmpty()) {
                    finalBuild.setSmallImage(core.getUtilHandler().parseVarsInternal(dim.smallImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig));
                }
                if (dim.smallImageText != null && !dim.smallImageText.isEmpty()) {
                    finalBuild.setSmallImageText(core.getUtilHandler().parseVarsInternal(dim.smallImageText, core.getClientConfig().variablesConfig));
                }
                if (!dim.buttonsList.isEmpty()) {
                    finalBuild.setButtons(APIUtils.parseButtons(dim.buttonsList, core.getUtilHandler(), core.getClientConfig().variablesConfig));
                }
                build = finalBuild;
            }
        }
        return this.enabled ? build : null;
    }
}

