/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer;

import com.railwayteam.railways.content.buffer.IDyedBuffer;
import com.railwayteam.railways.util.BlockStateUtils;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DyeableBlockEntity
extends SmartBlockEntity
implements IDyedBuffer {
    @Nullable
    protected DyeColor color;

    public DyeableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.color != null) {
            tag.m_128405_("Color", this.color.m_41060_());
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        DyeColor prevColor = this.color;
        this.color = tag.m_128441_("Color") ? DyeColor.m_41053_((int)tag.m_128451_("Color")) : null;
        if (clientPacket && prevColor != this.color) {
            this.redraw();
        }
    }

    protected void redraw() {
        if (this.m_58898_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
        }
    }

    public InteractionResult applyDyeIfValid(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof DyeItem)) {
            return InteractionResult.PASS;
        }
        DyeItem dyeItem = (DyeItem)item;
        DyeColor color = dyeItem.m_41089_();
        if (color == this.color) {
            return InteractionResult.PASS;
        }
        if (this.f_58857_.m_5776_() && !this.isVirtual()) {
            return InteractionResult.SUCCESS;
        }
        this.color = color;
        this.notifyUpdate();
        this.f_58857_.m_46796_(2001, this.f_58858_, Block.m_49956_((BlockState)BlockStateUtils.getWoolBlock(color).m_49966_()));
        return InteractionResult.SUCCESS;
    }
}

