/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.peripheral.modem.wired.BlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.CableShapes;
import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft", value={Dist.CLIENT})
public final class CableHighlightRenderer {
    private CableHighlightRenderer() {
    }

    @SubscribeEvent
    public static void drawHighlight(RenderHighlightEvent.Block event) {
        BlockHitResult hit = event.getTarget();
        BlockPos pos = hit.m_82425_();
        Level world = event.getCamera().m_90592_().m_20193_();
        Camera info = event.getCamera();
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() != Registry.ModBlocks.CABLE.get() || ((CableModemVariant)((Object)state.m_61143_(BlockCable.MODEM))).getFacing() == null || !((Boolean)state.m_61143_((Property)BlockCable.CABLE)).booleanValue()) {
            return;
        }
        event.setCanceled(true);
        VoxelShape shape = WorldUtil.isVecInside(CableShapes.getModemShape(state), hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) ? CableShapes.getModemShape(state) : CableShapes.getCableShape(state);
        Vec3 cameraPos = info.m_90583_();
        double xOffset = (double)pos.m_123341_() - cameraPos.m_7096_();
        double yOffset = (double)pos.m_123342_() - cameraPos.m_7098_();
        double zOffset = (double)pos.m_123343_() - cameraPos.m_7094_();
        VertexConsumer buffer = event.getMultiBufferSource().m_6299_(RenderType.m_110504_());
        Matrix4f matrix4f = event.getPoseStack().m_85850_().m_85861_();
        Matrix3f normal = event.getPoseStack().m_85850_().m_85864_();
        shape.m_83224_((x1, y1, z1, x2, y2, z2) -> {
            float xDelta = (float)(x2 - x1);
            float yDelta = (float)(y2 - y1);
            float zDelta = (float)(z2 - z1);
            float len = Mth.m_14116_((float)(xDelta * xDelta + yDelta * yDelta + zDelta * zDelta));
            buffer.m_85982_(matrix4f, (float)(x1 + xOffset), (float)(y1 + yOffset), (float)(z1 + zOffset)).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_85977_(normal, xDelta /= len, yDelta /= len, zDelta /= len).m_5752_();
            buffer.m_85982_(matrix4f, (float)(x2 + xOffset), (float)(y2 + yOffset), (float)(z2 + zOffset)).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_85977_(normal, xDelta, yDelta, zDelta).m_5752_();
        });
    }
}

