/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleRefuelHandler;
import dan200.computercraft.shared.turtle.TurtleUtil;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;

public final class FurnaceRefuelHandler
implements TurtleRefuelHandler {
    @Override
    public OptionalInt refuel(@Nonnull ITurtleAccess turtle, @Nonnull ItemStack currentStack, int slot, int limit) {
        int fuelPerItem = FurnaceRefuelHandler.getFuelPerItem(currentStack);
        if (fuelPerItem <= 0) {
            return OptionalInt.empty();
        }
        if (limit == 0) {
            return OptionalInt.of(0);
        }
        int fuelSpaceLeft = turtle.getFuelLimit() - turtle.getFuelLevel();
        int fuelItemLimit = (int)Math.ceil((double)fuelSpaceLeft / (double)fuelPerItem);
        if (limit > fuelItemLimit) {
            limit = fuelItemLimit;
        }
        ItemStack stack = turtle.getInventory().m_7407_(slot, limit);
        int fuelToGive = fuelPerItem * stack.m_41613_();
        ItemStack replacementStack = ForgeHooks.getCraftingRemainingItem((ItemStack)stack);
        if (!replacementStack.m_41619_()) {
            TurtleUtil.storeItemOrDrop(turtle, replacementStack);
        }
        turtle.getInventory().m_6596_();
        return OptionalInt.of(fuelToGive);
    }

    private static int getFuelPerItem(@Nonnull ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, null) * 5 / 100;
    }
}

