/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import mod.chiselsandbits.client.model.baked.chiseled.InterpolationHelper;
import mod.chiselsandbits.client.model.baked.face.model.VertexData;
import mod.chiselsandbits.client.util.Vector2f;
import mod.chiselsandbits.client.util.VectorUtils;
import net.minecraft.core.Direction;

public final class VertexDataUtils {
    private VertexDataUtils() {
        throw new IllegalStateException("Tried to instantiate: 'VertexDataUtils', but this is a utility class.");
    }

    public static Collection<VertexData> adaptVertices(VertexData[] vertexData, Direction cullDirection, Vector3f from, Vector3f to) {
        HashBiMap projectedVertexPositions = HashBiMap.create();
        Arrays.stream(vertexData).forEach(arg_0 -> VertexDataUtils.lambda$adaptVertices$0((BiMap)projectedVertexPositions, cullDirection, arg_0));
        Collection<Vector2f> boxCorners = VertexDataUtils.buildCorners(cullDirection, from, to);
        Map<Vector2f, VertexData> closestCorners = VertexDataUtils.buildClosestVertices(vertexData, boxCorners, cullDirection);
        InterpolationHelper interpolationHelper = new InterpolationHelper(((Vector2f)projectedVertexPositions.get((Object)vertexData[0])).x(), ((Vector2f)projectedVertexPositions.get((Object)vertexData[0])).y(), ((Vector2f)projectedVertexPositions.get((Object)vertexData[1])).x(), ((Vector2f)projectedVertexPositions.get((Object)vertexData[1])).y(), ((Vector2f)projectedVertexPositions.get((Object)vertexData[2])).x(), ((Vector2f)projectedVertexPositions.get((Object)vertexData[2])).y(), ((Vector2f)projectedVertexPositions.get((Object)vertexData[3])).x(), ((Vector2f)projectedVertexPositions.get((Object)vertexData[3])).y());
        ArrayList<VertexData> adaptedVertices = new ArrayList<VertexData>();
        for (Vector2f newPosition : boxCorners) {
            interpolationHelper.locate(newPosition.x(), newPosition.y());
            float u = interpolationHelper.interpolate(vertexData[0].u(), vertexData[1].u(), vertexData[2].u(), vertexData[3].u());
            float v = interpolationHelper.interpolate(vertexData[0].v(), vertexData[1].v(), vertexData[2].v(), vertexData[3].v());
            Vector3f position = VectorUtils.unprojectFromPlaneOf(newPosition, from, cullDirection);
            VertexData vertex = new VertexData(position, new Vector2f(u, v), closestCorners.get(newPosition).vertexIndex());
            adaptedVertices.add(vertex);
        }
        adaptedVertices.sort(Comparator.comparing(VertexData::vertexIndex));
        return adaptedVertices;
    }

    private static Map<Vector2f, VertexData> buildClosestVertices(VertexData[] vertexData, Collection<Vector2f> boxCorners, Direction cullDirection) {
        Vector2f center = new Vector2f();
        for (Vector2f vector2f : boxCorners) {
            center.add(vector2f);
        }
        center.mul(1.0f / (float)boxCorners.size());
        Vector2f centerOfVertices = new Vector2f();
        for (VertexData vertex : vertexData) {
            centerOfVertices.add(vertex.projectOntoPlaneOf(cullDirection));
        }
        centerOfVertices.mul(1.0f / (float)vertexData.length);
        HashBiMap hashBiMap = HashBiMap.create();
        boxCorners.forEach(arg_0 -> VertexDataUtils.lambda$buildClosestVertices$1((BiMap)hashBiMap, center, arg_0));
        HashBiMap vertexByCorner = HashBiMap.create();
        for (VertexData vertexDatum : vertexData) {
            static enum Corner {
                TOP_LEFT,
                TOP_RIGHT,
                BOTTOM_LEFT,
                BOTTOM_RIGHT;


                private static Corner closest(Vector2f vector2f, Vector2f center) {
                    if (vector2f.x() < center.x()) {
                        if (vector2f.y() < center.y()) {
                            return BOTTOM_LEFT;
                        }
                        return TOP_LEFT;
                    }
                    if (vector2f.y() < center.y()) {
                        return BOTTOM_RIGHT;
                    }
                    return TOP_RIGHT;
                }
            }
            vertexByCorner.put((Object)Corner.closest(vertexDatum.projectOntoPlaneOf(cullDirection), centerOfVertices), (Object)vertexDatum);
        }
        HashMap<Vector2f, VertexData> closestVertices = new HashMap<Vector2f, VertexData>();
        hashBiMap.forEach((arg_0, arg_1) -> VertexDataUtils.lambda$buildClosestVertices$2(closestVertices, (BiMap)vertexByCorner, arg_0, arg_1));
        return closestVertices;
    }

    private static Collection<Vector2f> buildCorners(Direction cullDirection, Vector3f from, Vector3f to) {
        ArrayList<Vector2f> corners = new ArrayList<Vector2f>();
        float x1 = from.m_122239_();
        float y1 = from.m_122260_();
        float z1 = from.m_122269_();
        float x2 = to.m_122239_();
        float y2 = to.m_122260_();
        float z2 = to.m_122269_();
        switch (cullDirection) {
            case DOWN: {
                corners.add(new Vector2f(x1, z1));
                corners.add(new Vector2f(x1, z2));
                corners.add(new Vector2f(x2, z2));
                corners.add(new Vector2f(x2, z1));
                break;
            }
            case UP: {
                corners.add(new Vector2f(x1, z1));
                corners.add(new Vector2f(x2, z1));
                corners.add(new Vector2f(x2, z2));
                corners.add(new Vector2f(x1, z2));
                break;
            }
            case NORTH: {
                corners.add(new Vector2f(x1, y1));
                corners.add(new Vector2f(x2, y1));
                corners.add(new Vector2f(x2, y2));
                corners.add(new Vector2f(x1, y2));
                break;
            }
            case SOUTH: {
                corners.add(new Vector2f(x1, y1));
                corners.add(new Vector2f(x1, y2));
                corners.add(new Vector2f(x2, y2));
                corners.add(new Vector2f(x2, y1));
                break;
            }
            case WEST: {
                corners.add(new Vector2f(z1, y1));
                corners.add(new Vector2f(z1, y2));
                corners.add(new Vector2f(z2, y2));
                corners.add(new Vector2f(z2, y1));
                break;
            }
            case EAST: {
                corners.add(new Vector2f(z1, y1));
                corners.add(new Vector2f(z2, y1));
                corners.add(new Vector2f(z2, y2));
                corners.add(new Vector2f(z1, y2));
            }
        }
        return corners;
    }

    private static /* synthetic */ void lambda$buildClosestVertices$2(Map closestVertices, BiMap vertexByCorner, 1Corner corner, Vector2f vector2f) {
        static enum Corner {
            TOP_LEFT,
            TOP_RIGHT,
            BOTTOM_LEFT,
            BOTTOM_RIGHT;


            private static Corner closest(Vector2f vector2f, Vector2f center) {
                if (vector2f.x() < center.x()) {
                    if (vector2f.y() < center.y()) {
                        return BOTTOM_LEFT;
                    }
                    return TOP_LEFT;
                }
                if (vector2f.y() < center.y()) {
                    return BOTTOM_RIGHT;
                }
                return TOP_RIGHT;
            }
        }
        closestVertices.put(vector2f, (VertexData)vertexByCorner.get((Object)corner));
    }

    private static /* synthetic */ void lambda$buildClosestVertices$1(BiMap boxCornersByCorner, Vector2f center, Vector2f corner) {
        static enum Corner {
            TOP_LEFT,
            TOP_RIGHT,
            BOTTOM_LEFT,
            BOTTOM_RIGHT;


            private static Corner closest(Vector2f vector2f, Vector2f center) {
                if (vector2f.x() < center.x()) {
                    if (vector2f.y() < center.y()) {
                        return BOTTOM_LEFT;
                    }
                    return TOP_LEFT;
                }
                if (vector2f.y() < center.y()) {
                    return BOTTOM_RIGHT;
                }
                return TOP_RIGHT;
            }
        }
        boxCornersByCorner.put((Object)Corner.closest(corner, center), (Object)corner);
    }

    private static /* synthetic */ void lambda$adaptVertices$0(BiMap projectedVertexPositions, Direction cullDirection, VertexData vertex) {
        projectedVertexPositions.put((Object)vertex, (Object)vertex.projectOntoPlaneOf(cullDirection));
    }
}

