/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.clipboard;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ClipboardEditPacket
extends SimplePacketBase {
    private int hotbarSlot;
    private CompoundTag data;
    private BlockPos targetedBlock;

    public ClipboardEditPacket(int hotbarSlot, CompoundTag data, @Nullable BlockPos targetedBlock) {
        this.hotbarSlot = hotbarSlot;
        this.data = data;
        this.targetedBlock = targetedBlock;
    }

    public ClipboardEditPacket(FriendlyByteBuf buffer) {
        this.hotbarSlot = buffer.m_130242_();
        this.data = buffer.m_130260_();
        if (buffer.readBoolean()) {
            this.targetedBlock = buffer.m_130135_();
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.hotbarSlot);
        buffer.m_130079_(this.data);
        buffer.writeBoolean(this.targetedBlock != null);
        if (this.targetedBlock != null) {
            buffer.m_130064_(this.targetedBlock);
        }
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (this.targetedBlock != null) {
                Level world = sender.f_19853_;
                if (world == null || !world.m_46749_(this.targetedBlock)) {
                    return;
                }
                if (!this.targetedBlock.m_123314_((Vec3i)sender.m_20183_(), 20.0)) {
                    return;
                }
                BlockEntity patt1712$temp = world.m_7702_(this.targetedBlock);
                if (patt1712$temp instanceof ClipboardBlockEntity) {
                    ClipboardBlockEntity cbe = (ClipboardBlockEntity)patt1712$temp;
                    cbe.dataContainer.m_41751_(this.data.m_128456_() ? null : this.data);
                    cbe.onEditedBy((Player)sender);
                }
                return;
            }
            ItemStack itemStack = sender.m_150109_().m_8020_(this.hotbarSlot);
            if (!AllBlocks.CLIPBOARD.isIn(itemStack)) {
                return;
            }
            itemStack.m_41751_(this.data.m_128456_() ? null : this.data);
        });
        return true;
    }
}

