/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.Comparator;
import java.util.WeakHashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IEChunkTicketManager;
import qouteall.imm_ptl.core.ducks.IEServerChunkManager;
import qouteall.imm_ptl.core.ducks.IEServerWorld;
import qouteall.q_misc_util.dimension.DynamicDimensionsImpl;

public class MyLoadingTicket {
    public static final TicketType<ChunkPos> portalLoadingTicketType = TicketType.m_9462_((String)"imm_ptl", Comparator.comparingLong(ChunkPos::m_45588_));
    public static final TicketType<ChunkPos> temporalLoadingTicketType = TicketType.m_9465_((String)"imm_ptl_temportal", Comparator.comparingLong(ChunkPos::m_45588_), (int)300);
    public static final WeakHashMap<ServerLevel, LongSortedSet> loadedChunkRecord = new WeakHashMap();

    public static DistanceManager getTicketManager(ServerLevel world) {
        return ((IEServerChunkManager)world.m_7726_()).getTicketManager();
    }

    private static boolean hasOtherChunkTicket(ServerLevel world, ChunkPos chunkPos) {
        SortedArraySet<Ticket<?>> chunkTickets = ((IEChunkTicketManager)MyLoadingTicket.getTicketManager(world)).portal_getTicketSet(chunkPos.m_45588_());
        return chunkTickets.stream().anyMatch(t -> t.m_9428_() != portalLoadingTicketType);
    }

    public static void addTicketIfNotLoaded(ServerLevel world, ChunkPos chunkPos) {
        boolean isNewlyAdded = MyLoadingTicket.getRecord(world).add(chunkPos.m_45588_());
        if (isNewlyAdded) {
            MyLoadingTicket.getTicketManager(world).m_140840_(portalLoadingTicketType, chunkPos, MyLoadingTicket.getLoadingRadius(), (Object)chunkPos);
            PersistentEntitySectionManager<Entity> persistentEntitySectionManager = ((IEServerWorld)world).ip_getEntityManager();
        }
    }

    public static void removeTicketIfPresent(ServerLevel world, ChunkPos chunkPos) {
        boolean isNewlyRemoved = MyLoadingTicket.getRecord(world).remove(chunkPos.m_45588_());
        if (isNewlyRemoved) {
            MyLoadingTicket.getTicketManager(world).m_140849_(portalLoadingTicketType, chunkPos, MyLoadingTicket.getLoadingRadius(), (Object)chunkPos);
        }
    }

    public static int getLoadingRadius() {
        if (IPGlobal.activeLoading) {
            return 2;
        }
        return 1;
    }

    public static LongSortedSet getRecord(ServerLevel world) {
        return loadedChunkRecord.computeIfAbsent(world, k -> new LongLinkedOpenHashSet());
    }

    public static void loadTemporally(ServerLevel world, ChunkPos chunkPos) {
        MyLoadingTicket.getTicketManager(world).m_140849_(temporalLoadingTicketType, chunkPos, 2, (Object)chunkPos);
    }

    public static void loadTemporally(ServerLevel world, ChunkPos centerChunkPos, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                MyLoadingTicket.loadTemporally(world, new ChunkPos(centerChunkPos.f_45578_ + dx, centerChunkPos.f_45579_ + dz));
            }
        }
    }

    public static void onDimensionRemove(ResourceKey<Level> dimension) {
        ServerLevel world = McHelper.getServerWorld(dimension);
        LongSortedSet longs = loadedChunkRecord.get(world);
        if (longs == null) {
            return;
        }
        DistanceManager ticketManager = MyLoadingTicket.getTicketManager(world);
        longs.forEach(pos -> {
            ChunkPos chunkPos = new ChunkPos(pos);
            ticketManager.m_140849_(portalLoadingTicketType, chunkPos, MyLoadingTicket.getLoadingRadius(), (Object)chunkPos);
        });
        loadedChunkRecord.remove(world);
    }

    public static void init() {
        DynamicDimensionsImpl.beforeRemovingDimensionSignal.connect(MyLoadingTicket::onDimensionRemove);
    }
}

