/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.FMLPaths;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.q_misc_util.Helper;

public class IPConfig {
    public String check_the_wiki_for_more_information = "https://qouteall.fun/immptl/wiki/Config-Options";
    public boolean enableWarning = true;
    public boolean enableMirrorCreation = true;
    public int maxPortalLayer = 5;
    public boolean sharedBlockMeshBufferOptimization = true;
    public boolean lagAttackProof = true;
    public int portalRenderLimit = 200;
    public int indirectLoadingRadiusCap = 8;
    public boolean enableCrossPortalSound = true;
    public boolean compatibilityRenderMode = false;
    public boolean doCheckGlError = false;
    public int portalSearchingRange = 128;
    public boolean renderYourselfInPortal = true;
    public boolean serverSideNormalChunkLoading = true;
    public boolean teleportationDebug = false;
    public boolean correctCrossPortalEntityRendering = true;
    public boolean looseMovementCheck = false;
    public boolean pureMirror = false;
    public boolean enableAlternateDimensions = true;
    public boolean reducedPortalRendering = false;
    public boolean visibilityPrediction = true;
    public boolean netherPortalOverlay = false;
    public int scaleLimit = 30;
    public boolean easeCreativePermission = true;
    public boolean easeCommandStickPermission = false;
    public boolean enableDatapackPortalGen = true;
    public boolean enableCrossPortalView = true;
    public boolean enableClippingMechanism = true;
    public boolean enableDepthClampForPortalRendering = false;
    public boolean lightVanillaNetherPortalWhenCrouching = false;
    public boolean enableNetherPortalEffect = true;
    public boolean enableClientPerformanceAdjustment = true;
    public boolean enableServerPerformanceAdjustment = true;
    public boolean checkModInfoFromInternet = true;
    public boolean enableUpdateNotification = true;
    public IPGlobal.NetherPortalMode netherPortalMode = IPGlobal.NetherPortalMode.normal;
    public IPGlobal.EndPortalMode endPortalMode = IPGlobal.EndPortalMode.normal;

    private static File getGameDir() {
        return FMLPaths.GAMEDIR.get().toFile();
    }

    public static IPConfig readConfig() {
        File oldConfigFile = new File(IPConfig.getGameDir(), "imm_ptl_config.json");
        File newConfigFile = IPConfig.getConfigFileLocation();
        if (oldConfigFile.exists()) {
            Helper.log("Detected the old config file. deleted.");
            IPConfig result = IPConfig.readConfigFromFile(oldConfigFile);
            oldConfigFile.delete();
            return result;
        }
        return IPConfig.readConfigFromFile(newConfigFile);
    }

    public static File getConfigFileLocation() {
        return new File(IPConfig.getGameDir(), "config/immersive_portals_forge.json");
    }

    public static IPConfig readConfigFromFile(File configFile) {
        if (configFile.exists()) {
            try {
                String data = Files.lines(configFile.toPath()).collect(Collectors.joining());
                IPConfig result = (IPConfig)IPGlobal.gson.fromJson(data, IPConfig.class);
                if (result == null) {
                    return new IPConfig();
                }
                return result;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return new IPConfig();
            }
        }
        IPConfig configObject = new IPConfig();
        configObject.saveConfigFile();
        return configObject;
    }

    public void saveConfigFile() {
        File configFile1 = IPConfig.getConfigFileLocation();
        try {
            configFile1.getParentFile().mkdirs();
            configFile1.createNewFile();
            FileWriter fileWriter = new FileWriter(configFile1);
            fileWriter.write(IPGlobal.gson.toJson((Object)this));
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onConfigChanged() {
        IPGlobal.renderMode = this.compatibilityRenderMode ? IPGlobal.RenderMode.compatibility : IPGlobal.RenderMode.normal;
        IPGlobal.enableWarning = this.enableWarning;
        IPGlobal.enableMirrorCreation = this.enableMirrorCreation;
        IPGlobal.doCheckGlError = this.doCheckGlError;
        IPGlobal.maxPortalLayer = this.maxPortalLayer;
        IPGlobal.lagAttackProof = this.lagAttackProof;
        IPGlobal.portalRenderLimit = this.portalRenderLimit;
        IPGlobal.netherPortalFindingRadius = this.portalSearchingRange;
        IPGlobal.renderYourselfInPortal = this.renderYourselfInPortal;
        IPGlobal.activeLoading = this.serverSideNormalChunkLoading;
        IPGlobal.teleportationDebugEnabled = this.teleportationDebug;
        IPGlobal.correctCrossPortalEntityRendering = this.correctCrossPortalEntityRendering;
        IPGlobal.looseMovementCheck = this.looseMovementCheck;
        IPGlobal.pureMirror = this.pureMirror;
        IPGlobal.enableAlternateDimensions = this.enableAlternateDimensions;
        IPGlobal.indirectLoadingRadiusCap = this.indirectLoadingRadiusCap;
        IPGlobal.netherPortalMode = this.netherPortalMode;
        IPGlobal.endPortalMode = this.endPortalMode;
        IPGlobal.reducedPortalRendering = this.reducedPortalRendering;
        IPGlobal.offsetOcclusionQuery = this.visibilityPrediction;
        IPGlobal.netherPortalOverlay = this.netherPortalOverlay;
        IPGlobal.scaleLimit = this.scaleLimit;
        IPGlobal.easeCreativePermission = this.easeCreativePermission;
        IPGlobal.enableSharedBlockMeshBuffers = this.sharedBlockMeshBufferOptimization;
        IPGlobal.enableDatapackPortalGen = this.enableDatapackPortalGen;
        IPGlobal.enableCrossPortalView = this.enableCrossPortalView;
        IPGlobal.enableClippingMechanism = this.enableClippingMechanism;
        IPGlobal.lightVanillaNetherPortalWhenCrouching = this.lightVanillaNetherPortalWhenCrouching;
        IPGlobal.enableNetherPortalEffect = this.enableNetherPortalEffect;
        IPGlobal.enableClientPerformanceAdjustment = this.enableClientPerformanceAdjustment;
        IPGlobal.enableServerPerformanceAdjustment = this.enableServerPerformanceAdjustment;
        IPGlobal.enableCrossPortalSound = this.enableCrossPortalSound;
        IPGlobal.checkModInfoFromInternet = this.checkModInfoFromInternet;
        IPGlobal.enableUpdateNotification = this.enableUpdateNotification;
        if (this.enableDepthClampForPortalRendering) {
            IPGlobal.enableDepthClampForPortalRendering = true;
        }
        Helper.log("IP Config Applied");
    }
}

