/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.portal_generation;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.NetherPortalLikeForm;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.BreakablePortalEntity;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalEntity;

public class IntrinsicNetherPortalForm
extends NetherPortalLikeForm {
    private static boolean encounteredVanillaPortalBlock = false;

    public IntrinsicNetherPortalForm() {
        super(true);
    }

    @Override
    public void generateNewFrame(ServerLevel fromWorld, BlockPortalShape fromShape, ServerLevel toWorld, BlockPortalShape toShape) {
        for (BlockPos blockPos : toShape.frameAreaWithCorner) {
            toWorld.m_46597_(blockPos, Blocks.f_50080_.m_49966_());
        }
    }

    @Override
    public PortalGenInfo getNewPortalPlacement(ServerLevel toWorld, BlockPos toPos, ServerLevel fromWorld, BlockPortalShape fromShape) {
        if (encounteredVanillaPortalBlock) {
            encounteredVanillaPortalBlock = false;
            if (IPGlobal.enableWarning) {
                List<ServerPlayer> nearbyPlayers = McHelper.findEntitiesRough(ServerPlayer.class, (Level)fromWorld, Vec3.m_82528_((Vec3i)fromShape.anchor), 2, p -> true);
                for (ServerPlayer player : nearbyPlayers) {
                    player.m_5661_((Component)Component.m_237115_((String)"imm_ptl.cannot_connect_to_vanilla_portal"), false);
                }
            }
        }
        return super.getNewPortalPlacement(toWorld, toPos, fromWorld, fromShape);
    }

    public BreakablePortalEntity[] generatePortalEntitiesAndPlaceholder(PortalGenInfo info) {
        info.generatePlaceholderBlocks();
        BreakablePortalEntity[] portals = info.generateBiWayBiFacedPortal(NetherPortalEntity.entityType);
        return portals;
    }

    @Override
    public Predicate<BlockState> getOtherSideFramePredicate() {
        return blockState -> {
            if (O_O.isObsidian(blockState)) {
                return true;
            }
            Block block = blockState.m_60734_();
            if (block == Blocks.f_50142_) {
                encounteredVanillaPortalBlock = true;
            }
            return false;
        };
    }

    @Override
    public Predicate<BlockState> getThisSideFramePredicate() {
        return O_O::isObsidian;
    }

    @Override
    public Predicate<BlockState> getAreaPredicate() {
        return BlockBehaviour.BlockStateBase::m_60795_;
    }

    @Override
    public Codec<? extends PortalGenForm> getCodec() {
        throw new RuntimeException();
    }

    @Override
    public PortalGenForm getReverse() {
        return this;
    }
}

