/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import qouteall.q_misc_util.Helper;

public class RotationHelper {
    public static Quaternion quaternionNumAdd(Quaternion a, Quaternion b) {
        a.m_80143_(a.m_80140_() + b.m_80140_(), a.m_80150_() + b.m_80150_(), a.m_80153_() + b.m_80153_(), a.m_80156_() + b.m_80156_());
        return a;
    }

    public static Quaternion quaternionScale(Quaternion a, float scale) {
        a.m_80143_(a.m_80140_() * scale, a.m_80150_() * scale, a.m_80153_() * scale, a.m_80156_() * scale);
        return a;
    }

    public static Quaternion interpolateQuaternion(Quaternion a, Quaternion b, float t) {
        double DOT_THRESHOLD;
        a.m_80160_();
        b.m_80160_();
        double dot = RotationHelper.dotProduct4d(a, b);
        if (dot < 0.0) {
            a.m_80141_(-1.0f);
            dot = -dot;
        }
        if (dot > (DOT_THRESHOLD = 0.9995)) {
            Quaternion result = RotationHelper.quaternionNumAdd(RotationHelper.quaternionScale(a.m_80161_(), 1.0f - t), RotationHelper.quaternionScale(b.m_80161_(), t));
            result.m_80160_();
            return result;
        }
        double theta_0 = Math.acos(dot);
        double theta = theta_0 * (double)t;
        double sin_theta = Math.sin(theta);
        double sin_theta_0 = Math.sin(theta_0);
        double s0 = Math.cos(theta) - dot * sin_theta / sin_theta_0;
        double s1 = sin_theta / sin_theta_0;
        return RotationHelper.quaternionNumAdd(RotationHelper.quaternionScale(a.m_80161_(), (float)s0), RotationHelper.quaternionScale(b.m_80161_(), (float)s1));
    }

    public static double dotProduct4d(Quaternion a, Quaternion b) {
        return a.m_80140_() * b.m_80140_() + a.m_80150_() * b.m_80150_() + a.m_80153_() * b.m_80153_() + a.m_80156_() * b.m_80156_();
    }

    public static boolean isClose(Quaternion a, Quaternion b, float valve) {
        float dd;
        float dc;
        float db;
        float da;
        a.m_80160_();
        b.m_80160_();
        if (a.m_80156_() * b.m_80156_() < 0.0f) {
            a.m_80141_(-1.0f);
        }
        return (da = a.m_80140_() - b.m_80140_()) * da + (db = a.m_80150_() - b.m_80150_()) * db + (dc = a.m_80153_() - b.m_80153_()) * dc + (dd = a.m_80156_() - b.m_80156_()) * dd < valve;
    }

    public static Vec3 getRotated(Quaternion rotation, Vec3 vec) {
        Vector3f vector3f = new Vector3f(vec);
        vector3f.m_122251_(rotation);
        return new Vec3(vector3f);
    }

    public static Quaternion ortholize(Quaternion quaternion) {
        if (quaternion.m_80156_() < 0.0f) {
            quaternion.m_80141_(-1.0f);
        }
        return quaternion;
    }

    public static Vec3 getRotatingAxis(Quaternion quaternion) {
        return new Vec3((double)quaternion.m_80140_(), (double)quaternion.m_80150_(), (double)quaternion.m_80153_()).m_82541_();
    }

    public static Quaternion interpolateQuaternionNaive(Quaternion a, Quaternion b, float t) {
        return Helper.makeIntoExpression(new Quaternion(Mth.m_14179_((float)t, (float)a.m_80140_(), (float)b.m_80140_()), Mth.m_14179_((float)t, (float)a.m_80150_(), (float)b.m_80150_()), Mth.m_14179_((float)t, (float)a.m_80153_(), (float)b.m_80153_()), Mth.m_14179_((float)t, (float)a.m_80156_(), (float)b.m_80156_())), Quaternion::m_80160_);
    }
}

