/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.render.animation.v1.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gg.moonflower.pinwheel.api.animation.AnimationController;
import gg.moonflower.pinwheel.api.geometry.GeometryModel;
import gg.moonflower.pinwheel.api.texture.TextureTable;
import gg.moonflower.pollen.api.animation.v1.controller.PollenAnimationController;
import gg.moonflower.pollen.api.animation.v1.entity.AnimatedEntity;
import gg.moonflower.pollen.api.render.geometry.v1.GeometryBufferSource;
import gg.moonflower.pollen.api.render.geometry.v1.GeometryModelManager;
import gg.moonflower.pollen.api.render.geometry.v1.GeometryTextureManager;
import gg.moonflower.pollen.api.render.geometry.v1.MinecraftGeometryRenderer;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class AnimatedGeometryEntityModel<T extends Entity>
extends EntityModel<T> {
    private final GeometryBufferSource buffers = GeometryBufferSource.entity((MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_());
    private final ResourceLocation model;
    private ResourceLocation texture;

    public AnimatedGeometryEntityModel(ResourceLocation model) {
        this.model = model;
        this.texture = null;
    }

    private PollenAnimationController getAnimationController(T entity) {
        AnimationController animationController = ((AnimatedEntity)entity).getRenderAnimationController();
        if (animationController instanceof PollenAnimationController) {
            PollenAnimationController controller = (PollenAnimationController)animationController;
            return controller;
        }
        throw new IllegalStateException("Animation controller must implement PollenAnimationController to use AnimatedGeometryEntityModel");
    }

    public void m_6839_(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.getAnimationController(entity).updateRenderTime(partialTicks);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float animationTicks, float netHeadYaw, float headPitch) {
        GeometryModel model = this.getModel();
        model.resetTransformation();
        PollenAnimationController controller = this.getAnimationController(entity);
        Collection animations = controller.getPlayingAnimations();
        if (animations.isEmpty()) {
            return;
        }
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        profiler.m_6180_("applyMolangAnimation");
        controller.setLifetime(animationTicks / 20.0f);
        controller.setRenderParameters(headPitch, netHeadYaw, limbSwing, limbSwingAmount);
        model.applyAnimations(controller.getEnvironment(), animations);
        profiler.m_7238_();
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, (double)1.501f, 0.0);
        MinecraftGeometryRenderer.getInstance().render(this.getModel(), this.getTexture(), this.getGeometryBuffers(), matrixStack, packedLight, packedOverlay, red, green, blue, alpha);
        matrixStack.m_85849_();
    }

    public GeometryBufferSource getGeometryBuffers() {
        return this.buffers;
    }

    public GeometryModel getModel() {
        return GeometryModelManager.getModel(this.model);
    }

    public TextureTable getTexture() {
        return this.texture != null ? GeometryTextureManager.getTextures(this.texture) : TextureTable.EMPTY;
    }

    public void setTexture(@Nullable ResourceLocation texture) {
        this.texture = texture;
    }
}

