/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.animation.runtime;

import gg.moonflower.molangcompiler.api.MolangEnvironmentBuilder;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import gg.moonflower.molangcompiler.api.bridge.MolangJavaFunction;
import gg.moonflower.molangcompiler.api.exception.MolangRuntimeException;
import gg.moonflower.pollen.api.animation.v1.controller.IdleAnimationController;
import gg.moonflower.pollen.api.animation.v1.controller.PollenAnimationController;
import gg.moonflower.pollen.api.animation.v1.controller.StateAnimationController;
import gg.moonflower.pollen.api.animation.v1.state.AnimationState;
import gg.moonflower.pollen.impl.animation.controller.ClientIdleAnimationControllerImpl;
import gg.moonflower.pollen.impl.animation.controller.ClientStateAnimationControllerImpl;
import gg.moonflower.pollen.impl.animation.runtime.CommonAnimationRuntime;
import java.util.OptionalLong;
import java.util.stream.LongStream;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ClientAnimationRuntime
extends CommonAnimationRuntime {
    private static final MolangJavaFunction LAST_FRAME_TIME = context -> {
        int wrappedIndex;
        FrameTimer frameTimer = Minecraft.m_91087_().m_91293_();
        long[] log = frameTimer.m_13764_();
        int index = (int)Math.min(context.get(0), (float)(log.length - 1));
        if (index == 0) {
            return (float)log[frameTimer.m_13761_()] / 1.0E9f;
        }
        if (index < 0) {
            throw new MolangRuntimeException("Invalid argument for last_frame_time(): " + index);
        }
        for (wrappedIndex = frameTimer.m_13761_() - index; wrappedIndex < 0; wrappedIndex += 240) {
        }
        return (float)log[frameTimer.m_13762_(wrappedIndex)] / 1.0E9f;
    };
    private static final MolangJavaFunction AVERAGE_FRAME_TIME = context -> ClientAnimationRuntime.applyFrame("average_frame_time", (int)context.get(0), stream -> OptionalLong.of(stream.sum())) / context.get(0);
    private static final MolangJavaFunction MAX_FRAME_TIME = context -> ClientAnimationRuntime.applyFrame("max_frame_time", (int)context.get(0), LongStream::max);
    private static final MolangJavaFunction MIN_FRAME_TIME = context -> ClientAnimationRuntime.applyFrame("min_frame_time", (int)context.get(0), LongStream::min);
    private static final MolangJavaFunction CAMERA_ROTATION = context -> {
        int param = (int)context.get(0);
        if (param < 0 || param >= 2) {
            throw new MolangRuntimeException("Invalid argument for camera_rotation: " + param);
        }
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        return param == 0 ? camera.m_90589_() : camera.m_90590_();
    };

    @Override
    public void addGlobal(MolangEnvironmentBuilder<?> builder) {
        super.addGlobal(builder);
        builder.setQuery("average_frame_time", () -> {
            FrameTimer frameTimer = Minecraft.m_91087_().m_91293_();
            return Float.valueOf((float)frameTimer.m_13764_()[frameTimer.m_13761_()] / 1.0E9f);
        });
        builder.setQuery("delta_time", Minecraft.m_91087_().m_91296_());
        builder.setQuery("average_frame_time", 1, AVERAGE_FRAME_TIME);
        builder.setQuery("last_frame_time", () -> {
            FrameTimer frameTimer = Minecraft.m_91087_().m_91293_();
            return Float.valueOf((float)frameTimer.m_13764_()[frameTimer.m_13761_()] / 1.0E9f);
        });
        builder.setQuery("last_frame_time", 1, LAST_FRAME_TIME);
        builder.setQuery("maximum_frame_time", () -> {
            FrameTimer frameTimer = Minecraft.m_91087_().m_91293_();
            return Float.valueOf((float)frameTimer.m_13764_()[frameTimer.m_13761_()] / 1.0E9f);
        });
        builder.setQuery("maximum_frame_time", 1, MAX_FRAME_TIME);
        builder.setQuery("minimum_frame_time", () -> {
            FrameTimer frameTimer = Minecraft.m_91087_().m_91293_();
            return Float.valueOf((float)frameTimer.m_13764_()[frameTimer.m_13761_()] / 1.0E9f);
        });
        builder.setQuery("minimum_frame_time", 1, MIN_FRAME_TIME);
        builder.setQuery("camera_rotation", 1, CAMERA_ROTATION);
    }

    @Override
    public void addEntity(MolangEnvironmentBuilder<?> builder, Entity entity, boolean client) {
        super.addEntity(builder, entity, client);
        if (!client) {
            return;
        }
        Level level = entity.f_19853_;
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            builder.setQuery("actor_count", MolangExpression.of(() -> Float.valueOf(clientLevel.m_104813_())));
        }
        builder.setQuery("time_of_day", MolangExpression.of(() -> Float.valueOf(entity.f_19853_.m_46942_(Minecraft.m_91087_().m_91296_()) / 24000.0f)));
        builder.setQuery("is_first_person", MolangExpression.of(() -> entity == Minecraft.m_91087_().m_91288_() && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON));
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            builder.setQuery("body_y_rotation", MolangExpression.of(() -> Float.valueOf(Mth.m_14179_((float)Minecraft.m_91087_().m_91296_(), (float)livingEntity.f_20884_, (float)livingEntity.f_20883_))));
        }
        builder.setQuery("head_x_rotation_speed", MolangExpression.of(() -> {
            float partialTicks = Minecraft.m_91087_().m_91296_();
            return Float.valueOf(entity.m_5686_(partialTicks) - entity.m_5686_((float)((double)partialTicks - 0.1)));
        }));
        builder.setQuery("head_y_rotation_speed", MolangExpression.of(() -> {
            float partialTicks = Minecraft.m_91087_().m_91296_();
            return Float.valueOf(entity.m_5675_(partialTicks) - entity.m_5675_((float)((double)partialTicks - 0.1)));
        }));
        builder.setQuery("distance_from_camera", MolangExpression.of(() -> Float.valueOf((float)Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82554_(entity.m_20182_()))));
        builder.setQuery("camera_distance_range_lerp", 2, context -> {
            float second;
            float first = context.get(0);
            if (first == (second = context.get(1))) {
                return 1.0f;
            }
            float smaller = Math.min(first, second);
            float larger = Math.max(first, second);
            double distance = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82554_(entity.m_20182_());
            if (distance <= (double)smaller) {
                return smaller;
            }
            if (distance >= (double)larger) {
                return larger;
            }
            return (float)((distance - (double)smaller) / (double)(larger - smaller));
        });
        builder.setQuery("lod_index", -1, context -> {
            if (context.getParameters() <= 0) {
                return 0.0f;
            }
            double distance = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82554_(entity.m_20182_());
            for (int i = 0; i < context.getParameters(); ++i) {
                if (!(distance < (double)context.get(0))) continue;
                return i;
            }
            return context.getParameters() - 1;
        });
        builder.setQuery("position", 1, context -> {
            int index = (int)context.get(0);
            if (index < 0 || index >= 3) {
                throw new MolangRuntimeException("Invalid argument for position(): " + index);
            }
            float partialTicks = Minecraft.m_91087_().m_91296_();
            return (float)(index == 0 ? entity.m_20165_((double)partialTicks) : (index == 1 ? entity.m_20227_((double)partialTicks) : entity.m_20246_((double)partialTicks)));
        });
        builder.setQuery("position_delta", 1, context -> {
            int index = (int)context.get(0);
            if (index < 0 || index >= 3) {
                throw new MolangRuntimeException("Invalid argument for position(): " + index);
            }
            return (float)(index == 0 ? entity.m_20184_().m_7096_() : (index == 1 ? entity.m_20184_().m_7098_() : entity.m_20184_().m_7094_()));
        });
    }

    @Override
    public StateAnimationController createController(AnimationState[] states, MolangRuntime runtime, boolean client) {
        return client ? new ClientStateAnimationControllerImpl(states, runtime) : super.createController(states, runtime, false);
    }

    @Override
    public IdleAnimationController createIdleController(PollenAnimationController controller) {
        return new ClientIdleAnimationControllerImpl(controller);
    }

    private static float applyFrame(String name, int count, FrameFunction terminator) throws MolangRuntimeException {
        int wrappedIndex;
        FrameTimer frameTimer = Minecraft.m_91087_().m_91293_();
        long[] log = frameTimer.m_13764_();
        int duration = Math.min(count, log.length - 1);
        if (duration == 0) {
            return (float)frameTimer.m_13764_()[frameTimer.m_13761_()] / 1.0E9f;
        }
        if (duration < 0) {
            throw new MolangRuntimeException("Invalid argument for " + name + "(): " + duration);
        }
        for (wrappedIndex = frameTimer.m_13761_() - duration; wrappedIndex < 0; wrappedIndex += 240) {
        }
        int finalWrappedIndex = wrappedIndex;
        return (float)terminator.apply(LongStream.range(0L, duration).map(i -> frameTimer.m_13764_()[frameTimer.m_13762_((int)((long)finalWrappedIndex + i))])).orElse(0L) / 1.0E9f;
    }

    @FunctionalInterface
    private static interface FrameFunction {
        public OptionalLong apply(LongStream var1) throws MolangRuntimeException;
    }
}

