/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.geometry.texture;

import com.google.common.base.Suppliers;
import dev.architectury.registry.ReloadListenerRegistry;
import gg.moonflower.pinwheel.api.texture.TextureTable;
import gg.moonflower.pollen.api.render.geometry.v1.GeometryAtlasTexture;
import gg.moonflower.pollen.api.render.geometry.v1.GeometryTextureManager;
import gg.moonflower.pollen.api.render.util.v1.BackgroundLoader;
import gg.moonflower.pollen.impl.render.geometry.GeometryTextureSpriteUploader;
import gg.moonflower.pollen.impl.render.geometry.texture.LocalTextureTableLoader;
import gg.moonflower.pollen.impl.render.geometry.texture.StaticTextureTableLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class GeometryTextureManagerImpl {
    private static final Logger LOGGER = LogManager.getLogger(GeometryTextureManager.class);
    private static final Reloader RELOADER = new Reloader();
    private static final Set<BackgroundLoader<Map<ResourceLocation, TextureTable>>> LOADERS = new HashSet<BackgroundLoader<Map<ResourceLocation, TextureTable>>>();
    private static final Map<ResourceLocation, TextureTable> TEXTURES = new HashMap<ResourceLocation, TextureTable>();
    private static final Supplier<StaticTextureTableLoader> STATIC_LOADER = Suppliers.memoize(() -> {
        StaticTextureTableLoader loader = new StaticTextureTableLoader();
        GeometryTextureManagerImpl.addProvider(loader);
        return loader;
    });
    private static GeometryTextureSpriteUploader spriteUploader;

    private GeometryTextureManagerImpl() {
    }

    public static void init() {
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)RELOADER, (ResourceLocation)new ResourceLocation("pollen", "geometry_texture_manager"));
        GeometryTextureManagerImpl.addProvider(new LocalTextureTableLoader());
    }

    public static void addTexture(ResourceLocation location, TextureTable texture) {
        STATIC_LOADER.get().addTexture(location, texture);
    }

    public static void addProvider(BackgroundLoader<Map<ResourceLocation, TextureTable>> loader) {
        LOADERS.add(loader);
    }

    public static TextureTable getTextures(ResourceLocation location) {
        return TEXTURES.computeIfAbsent(location, key -> {
            LOGGER.warn("Unknown texture table with key '{}'", (Object)location);
            return TextureTable.EMPTY;
        });
    }

    public static GeometryAtlasTexture getAtlas() {
        return spriteUploader;
    }

    public static Collection<TextureTable> getAllTextures() {
        return TEXTURES.values();
    }

    private static class Reloader
    implements PreparableReloadListener {
        private Reloader() {
        }

        public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            HashMap textures = new HashMap();
            return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])LOADERS.stream().map(textureLoader -> textureLoader.reload(resourceManager, backgroundExecutor, gameExecutor).thenAcceptAsync(models -> {
                for (Map.Entry entry : models.entrySet()) {
                    if (textures.put((ResourceLocation)entry.getKey(), (TextureTable)entry.getValue()) == null) continue;
                    LOGGER.warn("Duplicate model texture: " + entry.getKey());
                }
            }, gameExecutor)).toArray(CompletableFuture[]::new)).thenComposeAsync(pair -> {
                if (spriteUploader == null) {
                    spriteUploader = new GeometryTextureSpriteUploader(Minecraft.m_91087_().m_91097_());
                }
                return spriteUploader.setTextures(textures).m_5540_(stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
            }, gameExecutor)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenRunAsync(() -> {
                LOGGER.info("Loaded " + textures.size() + " texture tables.");
                TEXTURES.clear();
                TEXTURES.putAll(textures);
            }, gameExecutor);
        }
    }
}

