/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.particle;

import dev.architectury.registry.ReloadListenerRegistry;
import gg.moonflower.pinwheel.api.particle.ParticleData;
import gg.moonflower.pollen.api.render.particle.v1.BedrockParticleManager;
import gg.moonflower.pollen.api.render.util.v1.BackgroundLoader;
import gg.moonflower.pollen.impl.render.particle.LocalParticleLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class BedrockParticleManagerImpl {
    private static final Logger LOGGER = LogManager.getLogger(BedrockParticleManager.class);
    private static final Reloader RELOADER = new Reloader();
    private static final Set<BackgroundLoader<Map<ResourceLocation, ParticleData>>> LOADERS = new HashSet<BackgroundLoader<Map<ResourceLocation, ParticleData>>>();
    private static final Map<ResourceLocation, ParticleData> PARTICLES = new HashMap<ResourceLocation, ParticleData>();

    private BedrockParticleManagerImpl() {
    }

    public static void init() {
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)RELOADER, (ResourceLocation)new ResourceLocation("pollen", "custom_particle_manager"));
        BedrockParticleManagerImpl.addLoader(new LocalParticleLoader());
    }

    public static void addLoader(BackgroundLoader<Map<ResourceLocation, ParticleData>> loader) {
        LOADERS.add(loader);
    }

    public static ParticleData getParticle(ResourceLocation location) {
        return PARTICLES.computeIfAbsent(location, key -> {
            LOGGER.warn("Unknown particle with key '{}'", (Object)location);
            return ParticleData.EMPTY;
        });
    }

    public static boolean hasParticle(ResourceLocation location) {
        return PARTICLES.containsKey(location) && PARTICLES.get(location) != ParticleData.EMPTY;
    }

    private static class Reloader
    implements PreparableReloadListener {
        private Reloader() {
        }

        public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            HashMap particleData = new HashMap();
            return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])LOADERS.stream().map(loader -> loader.reload(resourceManager, backgroundExecutor, gameExecutor).thenAcceptAsync(pairs -> {
                for (Map.Entry entry : pairs.entrySet()) {
                    if (particleData.put((ResourceLocation)entry.getKey(), (ParticleData)entry.getValue()) == null) continue;
                    LOGGER.warn("Duplicate particle: " + entry.getKey());
                }
            }, gameExecutor)).toArray(CompletableFuture[]::new)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenRunAsync(() -> {
                LOGGER.info("Loaded " + particleData.size() + " particles.");
                PARTICLES.clear();
                PARTICLES.putAll(particleData);
            }, gameExecutor);
        }
    }
}

