/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.particle.instance;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Matrix4f;
import gg.moonflower.molangcompiler.api.MolangEnvironmentBuilder;
import gg.moonflower.molangcompiler.api.bridge.MolangVariableProvider;
import gg.moonflower.pinwheel.api.particle.ParticleData;
import gg.moonflower.pinwheel.api.particle.component.ParticleComponent;
import gg.moonflower.pinwheel.api.particle.render.ParticleRenderProperties;
import gg.moonflower.pinwheel.api.texture.ModelTexture;
import gg.moonflower.pinwheel.api.texture.TextureTable;
import gg.moonflower.pinwheel.api.transform.MatrixStack;
import gg.moonflower.pollen.api.joml.v1.JomlBridge;
import gg.moonflower.pollen.api.registry.particle.v1.BedrockParticleComponentFactory;
import gg.moonflower.pollen.api.render.geometry.v1.GeometryBufferSource;
import gg.moonflower.pollen.api.render.geometry.v1.GeometryTextureManager;
import gg.moonflower.pollen.api.render.particle.v1.BedrockParticleEmitter;
import gg.moonflower.pollen.api.render.particle.v1.MinecraftSingleQuadRenderProperties;
import gg.moonflower.pollen.api.render.particle.v1.component.BedrockParticleComponent;
import gg.moonflower.pollen.api.render.particle.v1.component.BedrockParticleRenderComponent;
import gg.moonflower.pollen.impl.render.particle.instance.BedrockParticleEmitterImpl;
import gg.moonflower.pollen.impl.render.particle.instance.BedrockParticleImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3dc;

@ApiStatus.Internal
public class BedrockParticleInstanceImpl
extends BedrockParticleImpl {
    public static final ParticleGroup GROUP = new ParticleGroup(10000);
    public static final ParticleRenderType GEOMETRY_SHEET = new ParticleRenderType(){

        public void m_6505_(BufferBuilder bufferBuilder, TextureManager textureManager) {
        }

        public void m_6294_(Tesselator tesselator) {
            Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
            RenderSystem.m_69482_();
            Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        }

        public String toString() {
            return "GEOMETRY_SHEET";
        }
    };
    private static final MatrixStack MATRIX_STACK = MatrixStack.create();
    private static final GeometryBufferSource BUFFER_SOURCE = GeometryBufferSource.particle((MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_());
    private static final Matrix4f POSITION = new Matrix4f();
    private static final Map<String, ResourceLocation> MATERIALS = new HashMap<String, ResourceLocation>();
    private final BedrockParticleEmitterImpl emitter;
    private final Set<BedrockParticleRenderComponent> renderComponents;
    @Nullable
    private ParticleRenderProperties renderProperties;

    public BedrockParticleInstanceImpl(BedrockParticleEmitterImpl emitter, ClientLevel clientLevel, double x, double y, double z) {
        super(clientLevel, x, y, z, emitter.getName());
        this.emitter = emitter;
        this.renderComponents = new HashSet<BedrockParticleRenderComponent>();
        this.addComponents();
        MolangEnvironmentBuilder builder = this.environment.edit();
        builder.copy(emitter.getEnvironment());
        builder.setVariables((MolangVariableProvider)emitter);
        builder.setVariables((MolangVariableProvider)this.curves);
        builder.setVariables((MolangVariableProvider)this);
    }

    @Override
    @Nullable
    protected BedrockParticleComponent addComponent(BedrockParticleComponentFactory<?> type, ParticleComponent data) {
        BedrockParticleComponent component = super.addComponent(type, data);
        if (component instanceof BedrockParticleRenderComponent) {
            BedrockParticleRenderComponent listener = (BedrockParticleRenderComponent)((Object)component);
            this.renderComponents.add(listener);
        }
        return component;
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        if ((float)this.age / 20.0f >= this.lifetime.getValue()) {
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        if (this.age < 0) {
            return;
        }
        ProfilerFiller profiler = this.f_107208_.m_46473_();
        profiler.m_6180_("pollen");
        this.renderAge.setValue(((float)this.age + partialTicks) / 20.0f);
        this.curves.evaluate(this.getEnvironment(), profiler);
        profiler.m_6180_("components");
        this.renderComponents.forEach(component -> component.render(camera, partialTicks));
        profiler.m_7238_();
        if (this.renderProperties != null) {
            MinecraftSingleQuadRenderProperties properties;
            profiler.m_6180_("tessellate");
            MATRIX_STACK.pushMatrix();
            Vector3dc pos = this.position(partialTicks);
            Vec3 cameraPos = camera.m_90583_();
            float x = (float)(pos.x() - cameraPos.m_7096_());
            float y = (float)(pos.y() - cameraPos.m_7098_());
            float z = (float)(pos.z() - cameraPos.m_7094_());
            MATRIX_STACK.translate(x, y, z);
            ParticleRenderProperties particleRenderProperties = this.renderProperties;
            if (particleRenderProperties instanceof MinecraftSingleQuadRenderProperties && (properties = (MinecraftSingleQuadRenderProperties)particleRenderProperties).canRender()) {
                float zRot = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
                MATRIX_STACK.translate(0.0, 0.01, 0.0);
                MATRIX_STACK.rotate((Quaternionfc)properties.getRotation());
                MATRIX_STACK.rotate((float)((double)zRot * Math.PI / 180.0), 0.0f, 0.0f, 1.0f);
                MATRIX_STACK.scale(properties.getWidth(), properties.getHeight(), 1.0f);
                this.render(properties);
            }
            MATRIX_STACK.popMatrix();
            profiler.m_7238_();
        }
        profiler.m_7238_();
    }

    private void render(MinecraftSingleQuadRenderProperties properties) {
        ParticleData.Description description = this.data.description();
        if (description.material() == null) {
            this.renderQuad(BUFFER_SOURCE.getBuffer(description.texture()), properties);
            return;
        }
        ResourceLocation location = MATERIALS.computeIfAbsent(description.material(), ResourceLocation::m_135820_);
        if (location == null) {
            return;
        }
        TextureTable table = GeometryTextureManager.getTextures(location);
        ModelTexture[] textures = table.getLayerTextures("texture");
        if (textures.length == 0) {
            return;
        }
        if (textures.length == 1) {
            this.renderQuad(BUFFER_SOURCE.getBuffer(textures[0]), properties);
        }
        this.renderQuad(VertexMultiConsumer.m_167063_((VertexConsumer[])((VertexConsumer[])Arrays.stream(textures).map(BUFFER_SOURCE::getBuffer).toArray(VertexConsumer[]::new))), properties);
    }

    public ParticleRenderType m_7556_() {
        return GEOMETRY_SHEET;
    }

    public Optional<ParticleGroup> m_142654_() {
        return Optional.empty();
    }

    private void renderQuad(VertexConsumer consumer, MinecraftSingleQuadRenderProperties properties) {
        float uMin = properties.getUMin();
        float uMax = properties.getUMax();
        float vMin = properties.getVMin();
        float vMax = properties.getVMax();
        float r = properties.getRed();
        float g = properties.getGreen();
        float b = properties.getBlue();
        float a = properties.getAlpha();
        int light = properties.getPackedLight();
        Matrix4f matrix4f = JomlBridge.set(POSITION, (Matrix4fc)MATRIX_STACK.position());
        consumer.m_85982_(matrix4f, -1.0f, -1.0f, 0.0f);
        consumer.m_7421_(uMax, vMax);
        consumer.m_85950_(r, g, b, a);
        consumer.m_85969_(light);
        consumer.m_5752_();
        consumer.m_85982_(matrix4f, -1.0f, 1.0f, 0.0f);
        consumer.m_7421_(uMax, vMin);
        consumer.m_85950_(r, g, b, a);
        consumer.m_85969_(light);
        consumer.m_5752_();
        consumer.m_85982_(matrix4f, 1.0f, 1.0f, 0.0f);
        consumer.m_7421_(uMin, vMin);
        consumer.m_85950_(r, g, b, a);
        consumer.m_85969_(light);
        consumer.m_5752_();
        consumer.m_85982_(matrix4f, 1.0f, -1.0f, 0.0f);
        consumer.m_7421_(uMin, vMax);
        consumer.m_85950_(r, g, b, a);
        consumer.m_85969_(light);
        consumer.m_5752_();
    }

    @Override
    protected Component getPrefix() {
        return Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"[Particle]").m_130940_(ChatFormatting.YELLOW)).m_7220_(super.getPrefix());
    }

    public void addMolangVariables(MolangVariableProvider.Context context) {
        context.addVariable("particle_age", this.renderAge);
        context.addVariable("particle_lifetime", this.lifetime);
        context.addVariable("particle_random_1", this.random1);
        context.addVariable("particle_random_2", this.random2);
        context.addVariable("particle_random_3", this.random3);
        context.addVariable("particle_random_4", this.random4);
    }

    @Override
    @Nullable
    public ParticleRenderProperties getRenderProperties() {
        return this.renderProperties;
    }

    @Override
    public void setRenderProperties(@Nullable ParticleRenderProperties properties) {
        this.renderProperties = properties;
    }

    @Override
    public BedrockParticleEmitter getEmitter() {
        return this.emitter;
    }
}

