/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail;

import com.mojang.authlib.GameProfile;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.ChunkEvent;
import dev.architectury.event.events.common.ExplosionEvent;
import dev.architectury.registry.CreativeTabRegistry;
import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.init.ModBlockEntities;
import dev.itsmeow.snailmail.init.ModBlocks;
import dev.itsmeow.snailmail.init.ModEntities;
import dev.itsmeow.snailmail.init.ModItems;
import dev.itsmeow.snailmail.init.ModMenus;
import dev.itsmeow.snailmail.init.ModNetwork;
import dev.itsmeow.snailmail.item.EnvelopeItem;
import dev.itsmeow.snailmail.util.BiMultiMap;
import dev.itsmeow.snailmail.util.Location;
import dev.itsmeow.snailmail.util.SnailMailCommonConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;

public class SnailMail {
    public static final String MODID = "snailmail";
    public static CreativeModeTab ITEM_GROUP = CreativeTabRegistry.create((ResourceLocation)new ResourceLocation("snailmail", "main"), () -> new ItemStack((ItemLike)ModItems.ENVELOPE_CLOSED.get()));

    public static void construct() {
        ModEntities.init();
        ModBlocks.init();
        ModItems.init();
        ModBlockEntities.init();
        ModMenus.init();
        ModNetwork.init();
        BlockEvent.PLACE.register((level, pos, state, entity) -> {
            if (entity instanceof Player && !level.m_5776_()) {
                UUID uuid = UUIDUtil.m_235875_((GameProfile)((Player)entity).m_36316_());
                BlockEntity teB = level.m_7702_(pos);
                if (teB != null && teB instanceof SnailBoxBlockEntity) {
                    Set<Location> box = SnailBoxSavedData.getOrCreate(level).getBoxes(uuid);
                    int size = box == null ? 0 : box.size();
                    ((SnailBoxBlockEntity)teB).initializeOwner(uuid, ((Player)entity).m_36316_().getName() + " Snailbox #" + (size + 1), false);
                }
            }
            return EventResult.pass();
        });
        BlockEvent.BREAK.register((level, pos, state, player, xp) -> {
            BlockEntity teB;
            if (state.m_60734_() == ModBlocks.SNAIL_BOX.get() && (teB = level.m_7702_(pos)) instanceof SnailBoxBlockEntity) {
                if (SnailMailCommonConfig.protectBoxDestroy() && !((SnailBoxBlockEntity)teB).canAccess(player)) {
                    return EventResult.interruptFalse();
                }
                SnailBoxSavedData.getOrCreate(level).removeBoxRaw(new Location(level, pos));
            }
            return EventResult.pass();
        });
        ExplosionEvent.DETONATE.register((level, explosion, affected) -> {
            ArrayList list = new ArrayList();
            explosion.m_46081_().forEach(pos -> {
                if (level.m_8055_(pos).m_60734_() == ModBlocks.SNAIL_BOX.get()) {
                    list.add(pos);
                }
            });
            for (BlockPos pos2 : list) {
                explosion.m_46081_().remove(pos2);
            }
        });
        ChunkEvent.LOAD_DATA.register((chunk, level, nbt) -> {
            ChunkPos cPos = chunk.m_7697_();
            Location[] posL = SnailBoxSavedData.getOrCreate((Level)level).getAllBoxes().toArray(new Location[0]);
            for (int i = 0; i < posL.length; ++i) {
                BlockState state;
                Location loc = posL[i];
                if (!loc.getDimension().equals((Object)level.m_46472_()) || cPos.m_45604_() > loc.getX() || cPos.m_45608_() < loc.getX() || cPos.m_45605_() > loc.getZ() || cPos.m_45609_() < loc.getZ() || (state = chunk.m_8055_(loc.toBP())).m_60734_() == ModBlocks.SNAIL_BOX.get()) continue;
                SnailBoxSavedData.getOrCreate((Level)level).removeBoxRaw(loc);
            }
        });
    }

    public static void forceArea(ServerLevel world, BlockPos pos, boolean type) {
        world.m_8602_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, type);
        world.m_8602_(pos.m_123341_() >> 5, pos.m_123343_() >> 4, type);
        world.m_8602_(pos.m_123341_() >> 3, pos.m_123343_() >> 4, type);
        world.m_8602_(pos.m_123341_() >> 4, pos.m_123343_() >> 5, type);
        world.m_8602_(pos.m_123341_() >> 4, pos.m_123343_() >> 3, type);
    }

    public static boolean deliverTo(SnailBoxBlockEntity te, ItemStack envelope, boolean failed) {
        Optional<ItemStack> iOpt;
        if (SnailBoxBlockEntity.hasCapability(te) && (iOpt = EnvelopeItem.convert(envelope)).isPresent()) {
            ItemStack newEnvelope = iOpt.get();
            if (failed) {
                if (!newEnvelope.m_41782_()) {
                    newEnvelope.m_41751_(new CompoundTag());
                }
                newEnvelope.m_41783_().m_128379_("delivery_failed", true);
            }
            return SnailBoxBlockEntity.tryInsert(te, newEnvelope);
        }
        return false;
    }

    public static class SnailBoxSavedData
    extends SavedData {
        private final BiMultiMap<UUID, Location> snailBoxes;
        private final BiMultiMap<UUID, Location> members;
        private final Map<Location, String> names;
        private final Map<Location, Boolean> publicM;

        public SnailBoxSavedData() {
            this.snailBoxes = new BiMultiMap();
            this.members = new BiMultiMap();
            this.names = new HashMap<Location, String>();
            this.publicM = new HashMap<Location, Boolean>();
        }

        public SnailBoxSavedData(BiMultiMap<UUID, Location> snailBoxes, BiMultiMap<UUID, Location> members, Map<Location, String> names, Map<Location, Boolean> publicM) {
            this.snailBoxes = snailBoxes;
            this.members = members;
            this.names = names;
            this.publicM = publicM;
        }

        public void updateAll(UUID owner, String name, boolean publicBox, Set<UUID> membersIn, Location pos) {
            this.snailBoxes.put(owner, pos);
            this.names.put(pos, name);
            this.publicM.put(pos, publicBox);
            for (UUID member : membersIn) {
                this.members.put(member, pos);
            }
            this.m_77762_();
        }

        public void update(UUID owner, String name, boolean forceName, Location pos) {
            if (forceName || !this.names.containsKey(pos)) {
                this.names.put(pos, name);
            }
            this.snailBoxes.putIfAbsent(owner, pos);
            this.m_77762_();
        }

        public void moveBox(Location oldLoc, Location newLoc) {
            UUID owner = this.getOwner(oldLoc);
            String name = this.names.remove(oldLoc);
            boolean publicB = this.isPublic(oldLoc);
            Set<UUID> memberL = this.members.getKeys(oldLoc);
            this.removeBoxRaw(oldLoc);
            this.updateAll(owner, name, publicB, memberL, newLoc);
        }

        public void removeBoxRaw(Location pos) {
            this.snailBoxes.removeValueFromAll(pos);
            this.names.remove(pos);
            this.members.removeValueFromAll(pos);
            this.publicM.remove(pos);
            this.m_77762_();
        }

        public Set<Location> getBoxes(UUID owner) {
            return this.snailBoxes.getValues(owner);
        }

        public Set<Location> getMemberBoxes(UUID member) {
            return this.members.getValues(member);
        }

        public Set<Location> getAllBoxes() {
            return this.snailBoxes.getValuesToKeys().keySet();
        }

        public String getNameForPos(Location pos) {
            return this.names.get(pos);
        }

        public void setNameForPos(Location pos, String name) {
            this.names.put(pos, name);
            this.m_77762_();
        }

        public boolean isPublic(Location pos) {
            return this.publicM.containsKey(pos) && this.publicM.get(pos) != false;
        }

        public boolean setPublic(Location pos, boolean value) {
            Boolean val = this.publicM.put(pos, value);
            this.m_77762_();
            return val != null && val != false;
        }

        public boolean isMemberOf(Location pos, UUID uuid) {
            return this.members.getValuesToKeys().containsEntry((Object)pos, (Object)uuid);
        }

        public UUID getOwner(Location location) {
            UUID[] uuid = (UUID[])this.snailBoxes.getValuesToKeys().get((Object)location).toArray((Object[])new UUID[0]);
            return uuid.length == 1 ? uuid[0] : null;
        }

        public void addMember(UUID uuid, Location location) {
            this.members.put(uuid, location);
            this.m_77762_();
        }

        public void removeMember(UUID uuid, Location location) {
            this.members.remove(uuid, location);
            this.m_77762_();
        }

        public Set<UUID> getMembers(Location location) {
            return this.members.getKeys(location);
        }

        public CompoundTag m_7176_(CompoundTag compound) {
            this.snailBoxes.getKeysToValues().keySet().forEach(key -> {
                ListTag list = new ListTag();
                this.snailBoxes.getValues((UUID)key).forEach(pos -> {
                    CompoundTag comp = new CompoundTag();
                    pos.write(comp);
                    comp.m_128359_("name", this.names.get(pos));
                    comp.m_128379_("public", this.publicM.get(pos).booleanValue());
                    ListTag list2 = new ListTag();
                    for (UUID member : this.getMembers((Location)pos)) {
                        list2.add((Object)StringTag.m_129297_((String)member.toString()));
                    }
                    comp.m_128365_("members", (Tag)list2);
                    list.add((Object)comp);
                });
                compound.m_128365_(key.toString(), (Tag)list);
            });
            return compound;
        }

        public static SnailBoxSavedData getOrCreate(Level level) {
            return (SnailBoxSavedData)level.m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(compoundTag -> {
                BiMultiMap<UUID, Location> snailBoxes = new BiMultiMap<UUID, Location>();
                BiMultiMap<UUID, Location> members = new BiMultiMap<UUID, Location>();
                HashMap<Location, String> names = new HashMap<Location, String>();
                HashMap<Location, Boolean> publicM = new HashMap<Location, Boolean>();
                for (String key : compoundTag.m_128431_()) {
                    UUID uuid = UUID.fromString(key);
                    if (uuid == null || !compoundTag.m_128425_(key, 9)) continue;
                    ListTag list = compoundTag.m_128437_(key, 10);
                    for (int i = 0; i < list.size(); ++i) {
                        CompoundTag comp = list.m_128728_(i);
                        Location pos = Location.read(comp);
                        snailBoxes.put(uuid, pos);
                        names.put(pos, comp.m_128461_("name"));
                        publicM.put(pos, comp.m_128471_("public"));
                        ListTag mList = comp.m_128437_("members", 8);
                        for (int j = 0; j < mList.size(); ++j) {
                            members.put(UUID.fromString(mList.m_128778_(j)), pos);
                        }
                    }
                }
                return new SnailBoxSavedData(snailBoxes, members, names, publicM);
            }, SnailBoxSavedData::new, "SNAIL_BOXES");
        }
    }
}

