/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.block;

import com.mojang.authlib.GameProfile;
import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.util.SnailMailCommonConfig;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SnailBoxBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    private static VoxelShape SHAPE_X;
    private static VoxelShape SHAPE_Z;
    public static HashMap<UUID, BlockPos> lastClickedBox;

    public SnailBoxBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60913_(2.0f, 1200.0f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() == Direction.Axis.Z ? SHAPE_X : SHAPE_Z;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61362_});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new SnailBoxBlockEntity(blockPos, blockState);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity teB;
        if (state.m_60734_() != newState.m_60734_() && (teB = worldIn.m_7702_(pos)) instanceof SnailBoxBlockEntity) {
            SnailBoxBlockEntity.dropItems((SnailBoxBlockEntity)teB);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (level.m_7702_(pos) != null) {
            if (SnailBoxBlock.canOpen(level, pos, player)) {
                lastClickedBox.put(player.m_20148_(), new BlockPos((Vec3i)pos));
                ((SnailBoxBlockEntity)level.m_7702_(pos)).openGUI((ServerPlayer)player);
            } else if (hand == InteractionHand.MAIN_HAND) {
                player.m_213846_((Component)Component.m_237115_((String)"message.snailmail.noperm").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            }
        }
        return InteractionResult.CONSUME;
    }

    public static boolean canOpen(Level worldIn, BlockPos pos, Player player) {
        BlockEntity teB = worldIn.m_7702_(pos);
        return teB != null && teB instanceof SnailBoxBlockEntity && SnailBoxBlock.isAccessibleFor((SnailBoxBlockEntity)teB, player);
    }

    public static boolean isAccessibleFor(SnailBoxBlockEntity te, Player player) {
        if (!SnailMailCommonConfig.lockBoxes()) {
            return true;
        }
        UUID uuid = UUIDUtil.m_235875_((GameProfile)player.m_36316_());
        if (uuid.equals(te.getOwner()) || te.isMember(uuid)) {
            return true;
        }
        if (SnailMailCommonConfig.opBypassLock()) {
            return player.m_20310_(SnailMailCommonConfig.bypassLockOpLevel());
        }
        return false;
    }

    static {
        lastClickedBox = new HashMap();
        double d = 0.25;
        SHAPE_X = Shapes.m_83048_((double)d, (double)0.0, (double)0.0, (double)(1.0 - d), (double)1.0, (double)1.0);
        SHAPE_Z = Shapes.m_83048_((double)0.0, (double)0.0, (double)d, (double)1.0, (double)1.0, (double)(1.0 - d));
    }
}

