/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.block.entity;

import com.mojang.authlib.GameProfile;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.menu.MenuRegistry;
import dev.itsmeow.snailmail.SnailMail;
import dev.itsmeow.snailmail.block.SnailBoxBlock;
import dev.itsmeow.snailmail.block.entity.forge.SnailBoxBlockEntityImpl;
import dev.itsmeow.snailmail.init.ModBlockEntities;
import dev.itsmeow.snailmail.init.ModBlocks;
import dev.itsmeow.snailmail.menu.SnailBoxMenu;
import dev.itsmeow.snailmail.util.Location;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SnailBoxBlockEntity
extends BlockEntity {
    public static final int SLOT_COUNT = 28;
    public static final Component TITLE = Component.m_237115_((String)"container.snailmail.snail_box");

    public SnailBoxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.SNAIL_BOX.get(), blockPos, blockState);
    }

    protected SnailMail.SnailBoxSavedData data() {
        return SnailMail.SnailBoxSavedData.getOrCreate(this.m_58904_());
    }

    public boolean isPublic() {
        return this.data().isPublic(this.getLocation());
    }

    public boolean isMember(UUID uuid) {
        return this.data().isMemberOf(this.getLocation(), uuid);
    }

    public UUID getOwner() {
        return this.data().getOwner(this.getLocation());
    }

    public void initializeOwner(UUID uuid, String name, boolean forceName) {
        this.data().update(uuid, name, forceName, this.getLocation());
        this.data().setPublic(this.getLocation(), false);
    }

    public void addMember(UUID uuid) {
        this.data().addMember(uuid, this.getLocation());
    }

    public void removeMember(UUID uuid) {
        this.data().removeMember(uuid, this.getLocation());
    }

    public void setPublic(boolean publicB) {
        this.data().setPublic(this.getLocation(), publicB);
    }

    public Set<UUID> getMembers() {
        return this.data().getMembers(this.getLocation());
    }

    public void m_7651_() {
        SnailBoxBlockEntity.handleRemoved(this);
        super.m_7651_();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void handleRemoved(SnailBoxBlockEntity blockEntity) {
        SnailBoxBlockEntityImpl.handleRemoved(blockEntity);
    }

    public void setName(String name) {
        this.data().setNameForPos(this.getLocation(), name);
    }

    public void m_142339_(Level newLevel) {
        if (this.f_58857_ != null && newLevel != this.f_58857_) {
            this.data().moveBox(this.getLocation(), new Location(newLevel, this.f_58858_));
        }
        super.m_142339_(newLevel);
    }

    public void m_155250_(BlockState blockState) {
        super.m_155250_(blockState);
        if (this.m_58898_() && !this.m_58904_().m_5776_() && blockState.m_60734_() != ModBlocks.SNAIL_BOX.get()) {
            SnailMail.SnailBoxSavedData.getOrCreate(this.m_58904_()).removeBoxRaw(this.getLocation());
        }
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        SnailBoxBlockEntity.loadStorage(this, compoundTag);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        SnailBoxBlockEntity.saveStorage(this, compoundTag);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void loadStorage(SnailBoxBlockEntity blockEntity, CompoundTag compoundTag) {
        void var1_1;
        SnailBoxBlockEntityImpl.loadStorage(blockEntity, (CompoundTag)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void saveStorage(SnailBoxBlockEntity blockEntity, CompoundTag compoundTag) {
        void var1_1;
        SnailBoxBlockEntityImpl.saveStorage(blockEntity, (CompoundTag)var1_1);
    }

    public void openGUI(ServerPlayer player) {
        new Thread(() -> {
            MenuConstructor provider = SnailBoxBlockEntity.getServerMenuProvider(this);
            SimpleMenuProvider namedProvider = new SimpleMenuProvider(provider, TITLE);
            MenuRegistry.openExtendedMenu((ServerPlayer)player, (MenuProvider)namedProvider, buf -> {
                buf.m_130064_(this.m_58899_());
                String name = this.data().getNameForPos(this.getLocation());
                if (name == null) {
                    name = "";
                }
                buf.m_130072_(name, 35);
                buf.writeBoolean(UUIDUtil.m_235875_((GameProfile)player.m_36316_()).equals(this.getOwner()));
                buf.writeBoolean(this.isPublic());
                HashSet<String> usernames = new HashSet<String>();
                for (UUID member : this.getMembers()) {
                    Optional profile = player.m_20194_().m_129927_().m_11002_(member);
                    if (profile.isPresent() && ((GameProfile)profile.get()).getName() != null && !((GameProfile)profile.get()).getName().isEmpty()) {
                        usernames.add(((GameProfile)profile.get()).getName());
                        continue;
                    }
                    usernames.add(member.toString());
                }
                buf.writeInt(usernames.size());
                for (String username : usernames) {
                    buf.m_130070_(username);
                }
            });
        }).start();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void dropItems(SnailBoxBlockEntity blockEntity) {
        SnailBoxBlockEntityImpl.dropItems(blockEntity);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SnailBoxMenu getClientMenu(int id, Inventory playerInventory, FriendlyByteBuf extra) {
        void var2_2;
        void var1_1;
        return SnailBoxBlockEntityImpl.getClientMenu(id, (Inventory)var1_1, (FriendlyByteBuf)var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MenuConstructor getServerMenuProvider(SnailBoxBlockEntity te) {
        return SnailBoxBlockEntityImpl.getServerMenuProvider(te);
    }

    public Location getLocation() {
        return new Location(this.m_58904_(), this.m_58899_());
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemStack getEnvelope(SnailBoxBlockEntity blockEntity) {
        return SnailBoxBlockEntityImpl.getEnvelope(blockEntity);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setEnvelope(SnailBoxBlockEntity blockEntity, ItemStack stack) {
        void var1_1;
        SnailBoxBlockEntityImpl.setEnvelope(blockEntity, (ItemStack)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean setEnvelopeServer(SnailBoxBlockEntity blockEntity, ItemStack stack) {
        void var1_1;
        return SnailBoxBlockEntityImpl.setEnvelopeServer(blockEntity, (ItemStack)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasCapability(SnailBoxBlockEntity te) {
        return SnailBoxBlockEntityImpl.hasCapability(te);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean tryInsert(SnailBoxBlockEntity te, ItemStack newEnvelope) {
        void var1_1;
        return SnailBoxBlockEntityImpl.tryInsert(te, (ItemStack)var1_1);
    }

    public boolean canAccess(ServerPlayer sender) {
        return SnailBoxBlock.isAccessibleFor(this, (Player)sender);
    }
}

