/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.menu;

import dev.itsmeow.snailmail.block.SnailBoxBlock;
import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.init.ModBlocks;
import dev.itsmeow.snailmail.init.ModItems;
import dev.itsmeow.snailmail.init.ModMenus;
import dev.itsmeow.snailmail.item.EnvelopeItem;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class SnailBoxMenu
extends AbstractContainerMenu {
    public final BlockPos pos;
    public String startingName;
    public boolean isOwner = false;
    public boolean isPublic = false;
    public Set<String> memberUsers = new HashSet<String>();

    public SnailBoxMenu(int id, Container playerInventory, BlockPos pos) {
        super((MenuType)ModMenus.SNAIL_BOX.get(), id);
        this.pos = pos;
        this.startingName = "";
    }

    public SnailBoxMenu(int id, Container playerInventory, BlockPos pos, String startingName, boolean isOwner, boolean isPublic, Set<String> members) {
        super((MenuType)ModMenus.SNAIL_BOX.get(), id);
        this.pos = pos;
        this.startingName = startingName;
        this.isOwner = isOwner;
        this.isPublic = isPublic;
        this.memberUsers = members;
    }

    protected void addPlayerSlots(Container playerInventory) {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + 117;
                this.m_38897_(new Slot(playerInventory, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 8 + row * 18;
            int y = 175;
            this.m_38897_(new Slot(playerInventory, row, x, y));
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 28 ? !this.m_38903_(itemstack1, 28, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 28, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return player != null && SnailBoxMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)this.pos), (Player)player, (Block)((Block)ModBlocks.SNAIL_BOX.get())) && SnailBoxBlock.canOpen(player.f_19853_, this.pos, player);
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        if (!playerIn.f_19853_.m_5776_()) {
            playerIn.m_20194_().execute(() -> {
                for (int i = 0; i < playerIn.m_150109_().m_6643_(); ++i) {
                    ItemStack stack = playerIn.m_150109_().m_8020_(i);
                    if (stack.m_41720_() != ModItems.ENVELOPE_OPEN.get()) continue;
                    EnvelopeItem.emptyEnvelope(stack, playerIn);
                    playerIn.m_150109_().m_6836_(i, new ItemStack((ItemLike)ModItems.ENVELOPE_OPEN.get()));
                }
            });
        }
    }

    public SnailBoxBlockEntity getTile(Player player) {
        BlockEntity te = player.f_19853_.m_7702_(this.pos);
        if (te != null && this.m_6875_(player) && player.f_19853_.m_8055_(this.pos).m_60734_() == ModBlocks.SNAIL_BOX.get() && te instanceof SnailBoxBlockEntity) {
            return (SnailBoxBlockEntity)te;
        }
        return null;
    }
}

