/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.init.ModItems;
import dev.itsmeow.snailmail.item.EnvelopeItem;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class OpenEnvelopeGUIPacket {
    private BlockPos pos;

    public OpenEnvelopeGUIPacket(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(OpenEnvelopeGUIPacket pkt, FriendlyByteBuf buf) {
        buf.m_130064_(pkt.pos);
    }

    public static OpenEnvelopeGUIPacket decode(FriendlyByteBuf buf) {
        return new OpenEnvelopeGUIPacket(buf.m_130135_());
    }

    public static class Handler {
        public static void handle(OpenEnvelopeGUIPacket msg, Supplier<NetworkManager.PacketContext> ctx) {
            if (ctx.get().getEnvironment() == Env.SERVER) {
                ctx.get().queue(() -> {
                    ItemStack stack;
                    BlockEntity target;
                    ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer();
                    if (sender.m_20275_((double)msg.pos.m_123341_(), (double)msg.pos.m_123342_(), (double)msg.pos.m_123343_()) <= 25.0 && (target = sender.f_19853_.m_7702_(msg.pos)) instanceof SnailBoxBlockEntity && (stack = SnailBoxBlockEntity.getEnvelope((SnailBoxBlockEntity)target)).m_41720_() == ModItems.ENVELOPE_OPEN.get()) {
                        EnvelopeItem.openGUI(sender, stack, msg.pos);
                    }
                });
            }
        }
    }
}

