/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.itsmeow.snailmail.block.SnailBoxBlock;
import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.item.EnvelopeItem;
import dev.itsmeow.snailmail.util.RandomUtil;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class SetEnvelopeNamePacket {
    public final Type type;
    public String name = "";

    public SetEnvelopeNamePacket(Type type, String name) {
        this.name = name;
        this.type = type;
    }

    public static void encode(SetEnvelopeNamePacket pkt, FriendlyByteBuf buf) {
        buf.writeBoolean(pkt.type == Type.FROM);
        buf.writeInt(pkt.name.length());
        buf.writeCharSequence((CharSequence)pkt.name, StandardCharsets.UTF_8);
    }

    public static SetEnvelopeNamePacket decode(FriendlyByteBuf buf) {
        return new SetEnvelopeNamePacket(buf.readBoolean() ? Type.FROM : Type.TO, String.valueOf(buf.readCharSequence(buf.readInt(), StandardCharsets.UTF_8)));
    }

    public static enum Type {
        FROM,
        TO;

    }

    public static class Handler {
        public static void handle(SetEnvelopeNamePacket msg, Supplier<NetworkManager.PacketContext> ctx) {
            if (ctx.get().getEnvironment() == Env.SERVER) {
                ctx.get().queue(() -> {
                    ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer();
                    BlockPos pos = SnailBoxBlock.lastClickedBox.get(sender.m_20148_());
                    if (sender.f_19853_.m_7702_(pos) instanceof SnailBoxBlockEntity) {
                        SnailBoxBlockEntity box = (SnailBoxBlockEntity)sender.f_19853_.m_7702_(pos);
                        ItemStack stack = SnailBoxBlockEntity.getEnvelope(box);
                        String s = RandomUtil.filterAllowedCharacters(msg.name, false);
                        if (s.length() <= 35) {
                            if (msg.type == Type.TO) {
                                EnvelopeItem.putStringChecked(stack, "AddressedTo", s);
                            } else {
                                EnvelopeItem.putStringChecked(stack, "AddressedFrom", s);
                            }
                            SnailBoxBlockEntity.setEnvelope(box, stack);
                        }
                    }
                });
            }
        }
    }
}

