/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.network;

import com.mojang.authlib.GameProfile;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.itsmeow.snailmail.block.entity.SnailBoxBlockEntity;
import dev.itsmeow.snailmail.client.screen.SnailBoxMemberScreen;
import dev.itsmeow.snailmail.init.ModNetwork;
import dev.itsmeow.snailmail.menu.SnailBoxMenu;
import dev.itsmeow.snailmail.util.RandomUtil;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class UpdateSnailBoxPacket {
    public String name = "";
    public String memberUsername = "";
    public boolean addMember;
    public boolean isPublic;
    public final Type type;

    public UpdateSnailBoxPacket(String name) {
        this.type = Type.NAME;
        this.name = name;
    }

    public UpdateSnailBoxPacket(String memberUsername, boolean add) {
        this.type = Type.MEMBER;
        this.memberUsername = memberUsername;
        this.addMember = add;
    }

    public UpdateSnailBoxPacket(boolean isPublic) {
        this.type = Type.PUBLIC;
        this.isPublic = isPublic;
    }

    public static void encode(UpdateSnailBoxPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.type.ordinal());
        switch (pkt.type) {
            case NAME: {
                buf.m_130072_(pkt.name, 35);
                break;
            }
            case MEMBER: {
                buf.m_130072_(pkt.memberUsername, 35);
                buf.writeBoolean(pkt.addMember);
                break;
            }
            case PUBLIC: {
                buf.writeBoolean(pkt.isPublic);
            }
        }
    }

    public static UpdateSnailBoxPacket decode(FriendlyByteBuf buf) {
        Type type = Type.values()[buf.readInt()];
        switch (type) {
            case NAME: {
                return new UpdateSnailBoxPacket(buf.m_130136_(35));
            }
            case MEMBER: {
                return new UpdateSnailBoxPacket(buf.m_130136_(35), buf.readBoolean());
            }
            case PUBLIC: {
                return new UpdateSnailBoxPacket(buf.readBoolean());
            }
        }
        return null;
    }

    private static void reply(Supplier<NetworkManager.PacketContext> ctx, String name, boolean added) {
        ModNetwork.HANDLER.sendToPlayer((ServerPlayer)ctx.get().getPlayer(), (Object)new UpdateSnailBoxPacket(name, added));
    }

    public static enum Type {
        NAME,
        MEMBER,
        PUBLIC;

    }

    public static class Handler {
        public static void handle(UpdateSnailBoxPacket msg, Supplier<NetworkManager.PacketContext> ctx) {
            if (ctx.get().getEnvironment() == Env.SERVER) {
                ctx.get().queue(() -> {
                    SnailBoxBlockEntity te;
                    ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer();
                    if (sender.f_36096_ instanceof SnailBoxMenu && (te = ((SnailBoxMenu)sender.f_36096_).getTile((Player)sender)) != null && te.getOwner().equals(UUIDUtil.m_235875_((GameProfile)sender.m_36316_()))) {
                        switch (msg.type) {
                            case NAME: {
                                String newName = RandomUtil.filterAllowedCharacters(msg.name, true);
                                if (newName.length() > 35) break;
                                te.setName(newName);
                                break;
                            }
                            case MEMBER: {
                                String username = msg.memberUsername;
                                new Thread(() -> Handler.lambda$handle$1(sender, username, (Supplier)ctx, te, msg)).start();
                                break;
                            }
                            case PUBLIC: {
                                te.setPublic(msg.isPublic);
                            }
                        }
                    }
                });
            } else if (ctx.get().getEnvironment() == Env.CLIENT && msg.type == Type.MEMBER) {
                ctx.get().queue(() -> {
                    if (Minecraft.m_91087_().f_91080_ instanceof SnailBoxMemberScreen) {
                        SnailBoxMemberScreen screen = (SnailBoxMemberScreen)Minecraft.m_91087_().f_91080_;
                        String name = msg.memberUsername;
                        if (!name.equals("FAILED_ID_VERIFY")) {
                            if (msg.addMember) {
                                ((SnailBoxMenu)screen.parent.m_6262_()).memberUsers.add(name);
                            } else {
                                ((SnailBoxMenu)screen.parent.m_6262_()).memberUsers.remove(name);
                            }
                            screen.refreshList();
                        } else {
                            screen.failedAdd();
                        }
                    }
                });
            }
        }

        private static /* synthetic */ void lambda$handle$1(ServerPlayer sender, String username, Supplier ctx, SnailBoxBlockEntity te, UpdateSnailBoxPacket msg) {
            Optional profile = sender.m_20194_().m_129927_().m_10996_(username);
            ((NetworkManager.PacketContext)ctx.get()).queue(() -> Handler.lambda$handle$0(profile, username, te, msg, (Supplier)ctx));
        }

        private static /* synthetic */ void lambda$handle$0(Optional profile, String username, SnailBoxBlockEntity te, UpdateSnailBoxPacket msg, Supplier ctx) {
            UUID uuid = null;
            if ((profile.isEmpty() || ((GameProfile)profile.get()).getId() == null) && UUID.fromString(username) != null) {
                uuid = UUID.fromString(username);
                if (!uuid.equals(te.getOwner())) {
                    if (msg.addMember) {
                        te.addMember(uuid);
                    } else {
                        te.removeMember(uuid);
                    }
                }
            } else if (profile.isPresent() && ((GameProfile)profile.get()).getId() != null) {
                uuid = ((GameProfile)profile.get()).getId();
                if (!uuid.equals(te.getOwner())) {
                    if (msg.addMember) {
                        te.addMember(((GameProfile)profile.get()).getId());
                    } else {
                        te.removeMember(((GameProfile)profile.get()).getId());
                    }
                }
            } else if (msg.addMember) {
                UpdateSnailBoxPacket.reply(ctx, "FAILED_ID_VERIFY", false);
            }
            if (!(uuid == null || uuid.equals(te.getOwner()) && msg.addMember)) {
                UpdateSnailBoxPacket.reply(ctx, username, msg.addMember);
            }
        }
    }
}

