/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.snailmail.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Set;

public class BiMultiMap<K, V> {
    private final SetMultimap<K, V> keysToValues = HashMultimap.create();
    private final SetMultimap<V, K> valuesToKeys = HashMultimap.create();

    public Set<V> getValues(K key) {
        return this.keysToValues.get(key);
    }

    public Set<K> getKeys(V value) {
        return this.valuesToKeys.get(value);
    }

    public boolean put(K key, V value) {
        return this.keysToValues.put(key, value) && this.valuesToKeys.put(value, key);
    }

    public boolean putAll(K key, Iterable<? extends V> values) {
        boolean changed = false;
        for (V value : values) {
            changed |= this.put(key, value);
        }
        return changed;
    }

    public boolean removeKeyFromAll(K key) {
        Set values = this.keysToValues.removeAll(key);
        values.forEach(value -> this.valuesToKeys.remove(value, key));
        return !values.isEmpty();
    }

    public boolean removeValueFromAll(V value) {
        Set keys = this.valuesToKeys.removeAll(value);
        keys.forEach(key -> this.keysToValues.remove(key, value));
        return !keys.isEmpty();
    }

    public boolean remove(K key, V value) {
        return this.keysToValues.remove(key, value) && this.valuesToKeys.remove(value, key);
    }

    public ImmutableSetMultimap<K, V> getKeysToValues() {
        return ImmutableSetMultimap.copyOf(this.keysToValues);
    }

    public ImmutableSetMultimap<V, K> getValuesToKeys() {
        return ImmutableSetMultimap.copyOf(this.valuesToKeys);
    }

    public void clear() {
        this.keysToValues.clear();
        this.valuesToKeys.clear();
    }

    public void putIfAbsent(K key, V value) {
        if (!this.keysToValues.containsKey(key) || !this.valuesToKeys.containsEntry(value, key)) {
            this.put(key, value);
        }
    }
}

