/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib;

import com.supermartijn642.configlib.ConfigLibClient;
import com.supermartijn642.configlib.ConfigSyncPacket;
import com.supermartijn642.configlib.ModConfig;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="supermartijn642configlib")
public class ConfigLib {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"configlib");
    protected static final ResourceLocation CHANNEL_ID = new ResourceLocation("supermartijn642configlib", "sync_configs");
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)CHANNEL_ID, () -> "1", "1"::equals, "1"::equals);
    private static final List<ModConfig<?>> CONFIGS = new ArrayList();
    private static final Set<String> CONFIG_NAMES = new HashSet<String>();
    private static final List<ModConfig<?>> SYNCABLE_CONFIGS = new ArrayList();
    private static final Map<String, ModConfig<?>> SYNCABLE_CONFIGS_BY_IDENTIFIER = new HashMap();

    public ConfigLib() {
        MinecraftForge.EVENT_BUS.addListener(e -> ConfigLib.onLoadGame());
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.getEntity() instanceof ServerPlayer) {
                ConfigLib.onPlayerJoinServer((ServerPlayer)e.getEntity());
            }
        });
        if (ConfigLib.isClientEnvironment()) {
            ConfigLibClient.registerEventListeners();
        }
        CHANNEL.registerMessage(0, ConfigSyncPacket.class, ConfigLib::createSyncedEntriesPacket, buffer -> ConfigLib.handleSyncConfigPacket(buffer), (packet, context) -> ((NetworkEvent.Context)context.get()).setPacketHandled(true));
    }

    public static boolean isClientEnvironment() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    public static boolean isServerEnvironment() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    public static File getConfigFolder() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    protected static synchronized void addConfig(ModConfig<?> config) {
        if (CONFIG_NAMES.contains(config.getIdentifier())) {
            throw new IllegalStateException("Config '" + config.getIdentifier() + "' for mod '" + config.getModid() + "' already exists!");
        }
        CONFIGS.add(config);
        CONFIG_NAMES.add(config.getIdentifier());
        if (config.hasSyncableEntries()) {
            SYNCABLE_CONFIGS.add(config);
            SYNCABLE_CONFIGS_BY_IDENTIFIER.put(config.getIdentifier(), config);
        }
        config.initialize();
    }

    protected static void onLoadGame() {
        CONFIGS.forEach(ModConfig::onJoinGame);
    }

    protected static void onLeaveGame() {
        CONFIGS.forEach(ModConfig::onLeaveGame);
    }

    protected static void onPlayerJoinServer(ServerPlayer sender) {
        ConfigLib.sendSyncConfigPackets(sender);
    }

    private static void sendSyncConfigPackets(ServerPlayer sender) {
        for (ModConfig<?> config : SYNCABLE_CONFIGS) {
            CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new ConfigSyncPacket(config));
        }
    }

    private static void createSyncedEntriesPacket(ConfigSyncPacket packet, FriendlyByteBuf buffer) {
        ModConfig<?> config = packet.config;
        buffer.m_130070_(config.getIdentifier());
        try {
            config.writeSyncableEntries((ByteBuf)buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write syncable config entries for config '" + config.getIdentifier() + "' from mod '" + config.getModid() + "'!", e);
        }
    }

    protected static ConfigSyncPacket handleSyncConfigPacket(FriendlyByteBuf buffer) {
        String identifier = buffer.m_130277_();
        ModConfig<?> config = SYNCABLE_CONFIGS_BY_IDENTIFIER.get(identifier);
        if (config == null) {
            LOGGER.error("Received config sync packet for unknown config '" + identifier + "'!");
            return null;
        }
        try {
            config.readSyncableValues((ByteBuf)buffer);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read syncable config entries for config '" + config.getIdentifier() + "' from mod '" + config.getModid() + "'!", (Throwable)e);
        }
        return new ConfigSyncPacket();
    }
}

