/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.WidgetHolder;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SimpleDisplayRenderer
extends DisplayRenderer
implements WidgetHolder {
    protected static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("roughlyenoughitems", "textures/gui/recipecontainer.png");
    protected List<Slot> inputWidgets;
    protected List<Slot> outputWidgets;
    protected List<GuiEventListener> widgets;

    @ApiStatus.Internal
    protected SimpleDisplayRenderer(List<EntryIngredient> input, List<EntryIngredient> output) {
        this.inputWidgets = CollectionUtils.map(SimpleDisplayRenderer.simplify(input), this::createSlot);
        this.outputWidgets = CollectionUtils.map(SimpleDisplayRenderer.simplify(output), this::createSlot);
        this.widgets = Stream.concat(this.inputWidgets.stream(), this.outputWidgets.stream()).collect(Collectors.toList());
    }

    protected Slot createSlot(EntryIngredient ingredient) {
        return Widgets.createSlot(new Point(0, 0)).entries(CollectionUtils.filterToList(ingredient, stack -> !stack.isEmpty())).disableBackground().disableHighlight().disableTooltips();
    }

    public static List<EntryIngredient> simplify(List<EntryIngredient> original) {
        ArrayList<EntryIngredient> out = new ArrayList<EntryIngredient>();
        for (EntryIngredient ingredient : original) {
            EntryIngredient filter = ingredient.filter((Predicate<EntryStack<?>>)Predicates.not(EntryStack::isEmpty));
            if (filter.isEmpty()) continue;
            EntryIngredient orNull = CollectionUtils.findFirstOrNull(out, s -> SimpleDisplayRenderer.equalsList(filter, s));
            if (orNull == null) {
                out.add(filter);
                continue;
            }
            out.set(out.indexOf(orNull), orNull.map(stack -> {
                for (EntryStack filterStack : filter) {
                    EntryDefinition definition;
                    Object newValue;
                    if (!EntryStacks.equalsExact(filterStack, stack) || (newValue = (definition = filterStack.getDefinition()).add(stack.getValue(), filterStack.getValue())) == null) continue;
                    stack = EntryStack.of(definition, newValue);
                }
                return stack;
            }));
        }
        return out;
    }

    public static DisplayRenderer from(List<EntryIngredient> input, List<EntryIngredient> output) {
        return new SimpleDisplayRenderer(input, output);
    }

    public static boolean equalsList(EntryIngredient left, EntryIngredient right) {
        LongOpenHashSet leftBytes = new LongOpenHashSet(left.size());
        for (EntryStack entryStack : left) {
            leftBytes.add(EntryStacks.hashExact(entryStack));
        }
        if (leftBytes.size() > right.size()) {
            return false;
        }
        LongOpenHashSet rightBytes = new LongOpenHashSet(right.size());
        for (EntryStack entryStack : right) {
            rightBytes.add(EntryStacks.hashExact(entryStack));
            if (rightBytes.size() <= leftBytes.size()) continue;
            return false;
        }
        return leftBytes.equals(rightBytes);
    }

    @Override
    public void render(PoseStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        int xx = bounds.x + 4;
        int yy = bounds.y + 2;
        int j = 0;
        int itemsPerLine = this.getItemsPerLine();
        for (Slot entryWidget : this.inputWidgets) {
            entryWidget.setZ(this.getZ() + 50);
            entryWidget.getBounds().setLocation(xx, yy);
            entryWidget.m_6305_(matrices, mouseX, mouseY, delta);
            xx += 18;
            if (++j < this.getItemsPerLine() - 2) continue;
            yy += 18;
            xx = bounds.x + 4;
            j = 0;
        }
        xx = bounds.x + 4 + 18 * (this.getItemsPerLine() - 2);
        yy = bounds.y + this.getHeight() / 2 - 8;
        RenderSystem.m_157456_((int)0, (ResourceLocation)CHEST_GUI_TEXTURE);
        this.m_93228_(matrices, xx, yy, 0, 28, 18, 18);
        xx += 18;
        yy += this.outputWidgets.size() * -9 + 9;
        for (Slot outputWidget : this.outputWidgets) {
            outputWidget.setZ(this.getZ() + 50);
            outputWidget.getBounds().setLocation(xx, yy);
            outputWidget.m_6305_(matrices, mouseX, mouseY, delta);
            yy += 18;
        }
    }

    @Override
    @Nullable
    public Tooltip getTooltip(TooltipContext context) {
        for (Slot widget : this.inputWidgets) {
            if (!widget.containsMouse(context.getPoint())) continue;
            return widget.getCurrentTooltip(context);
        }
        for (Slot widget : this.outputWidgets) {
            if (!widget.containsMouse(context.getPoint())) continue;
            return widget.getCurrentTooltip(context);
        }
        return null;
    }

    @Override
    public int getHeight() {
        return Math.max(4 + this.getItemsHeight() * 18, 4 + this.outputWidgets.size() * 18);
    }

    public int getItemsHeight() {
        return Math.max(Mth.m_14167_((float)((float)this.inputWidgets.size() / (float)(this.getItemsPerLine() - 2))), this.outputWidgets.size());
    }

    public int getItemsPerLine() {
        return Mth.m_14143_((float)(((float)this.getWidth() - 4.0f) / 18.0f));
    }

    @Override
    public List<? extends GuiEventListener> children() {
        return this.widgets;
    }
}

