/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import me.shedaniel.rei.RoughlyEnoughItemsState;
import me.shedaniel.rei.impl.client.gui.widget.DynamicErrorFreeEntryListWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class WarningAndErrorScreen
extends Screen {
    private AbstractWidget buttonExit;
    private StringEntryListWidget listWidget;
    private String action;
    private Screen parent;
    private List<Tuple<String, String>> warnings;
    private List<Tuple<String, String>> errors;
    private Consumer<Screen> onContinue;

    public WarningAndErrorScreen(String action, List<Tuple<String, String>> warnings, List<Tuple<String, String>> errors, Consumer<Screen> onContinue) {
        super((Component)Component.m_237119_());
        this.action = action;
        this.warnings = warnings;
        this.errors = errors;
        this.onContinue = onContinue;
    }

    public boolean m_6913_() {
        return false;
    }

    public void setParent(Screen parent) {
        this.parent = parent;
    }

    private void addText(Component string) {
        for (FormattedCharSequence s : this.f_96547_.m_92923_((FormattedText)string, this.f_96543_ - 80)) {
            this.listWidget.creditsAddEntry(new TextItem(s));
        }
    }

    private void addLink(Component string, String link) {
        for (FormattedCharSequence s : this.f_96547_.m_92923_((FormattedText)string, this.f_96543_ - 80)) {
            this.listWidget.creditsAddEntry(new LinkItem(s, link));
        }
    }

    public void m_7856_() {
        int i;
        this.listWidget = new StringEntryListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32);
        this.m_7787_((GuiEventListener)this.listWidget);
        this.listWidget.max = 80;
        this.listWidget.creditsClearEntries();
        this.listWidget.creditsAddEntry(new EmptyItem());
        if (!this.warnings.isEmpty()) {
            this.listWidget.creditsAddEntry(new TextItem(Component.m_237113_((String)"Warnings:").m_130940_(ChatFormatting.GOLD).m_7532_()));
        }
        for (Tuple<String, String> pair : this.warnings) {
            this.addText((Component)Component.m_237113_((String)((String)pair.m_14418_())));
            if (pair.m_14419_() != null) {
                this.addLink((Component)Component.m_237113_((String)((String)pair.m_14419_())), (String)pair.m_14419_());
            }
            for (i = 0; i < 2; ++i) {
                this.listWidget.creditsAddEntry(new EmptyItem());
            }
        }
        if (!this.warnings.isEmpty() && !this.errors.isEmpty()) {
            this.listWidget.creditsAddEntry(new EmptyItem());
        }
        if (!this.errors.isEmpty()) {
            this.listWidget.creditsAddEntry(new TextItem(Component.m_237113_((String)"Errors:").m_130940_(ChatFormatting.RED).m_7532_()));
        }
        for (Tuple<String, String> pair : this.errors) {
            this.addText((Component)Component.m_237113_((String)((String)pair.m_14418_())));
            if (pair.m_14419_() != null) {
                this.addLink((Component)Component.m_237113_((String)((String)pair.m_14419_())), (String)pair.m_14419_());
            }
            for (i = 0; i < 2; ++i) {
                this.listWidget.creditsAddEntry(new EmptyItem());
            }
        }
        for (StringItem child : this.listWidget.m_6702_()) {
            this.listWidget.max = Math.max(this.listWidget.max, child.getWidth());
        }
        this.buttonExit = new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 26, 200, 20, (Component)Component.m_237113_((String)(this.errors.isEmpty() ? "Continue" : "Exit")), button -> this.onContinue.accept(this.parent));
        this.m_142416_((GuiEventListener)this.buttonExit);
    }

    public boolean m_6050_(double double_1, double double_2, double double_3) {
        return this.listWidget.m_6050_(double_1, double_2, double_3) || super.m_6050_(double_1, double_2, double_3);
    }

    public void m_6305_(PoseStack matrices, int int_1, int int_2, float float_1) {
        this.m_96626_(0);
        this.listWidget.m_6305_(matrices, int_1, int_2, float_1);
        if (RoughlyEnoughItemsState.getErrors().isEmpty()) {
            WarningAndErrorScreen.m_93208_((PoseStack)matrices, (Font)this.f_96547_, (String)("Warnings during Roughly Enough Items' " + this.action), (int)(this.f_96543_ / 2), (int)16, (int)0xFFFFFF);
        } else {
            WarningAndErrorScreen.m_93208_((PoseStack)matrices, (Font)this.f_96547_, (String)("Errors during Roughly Enough Items' " + this.action), (int)(this.f_96543_ / 2), (int)16, (int)0xFFFFFF);
        }
        super.m_6305_(matrices, int_1, int_2, float_1);
        this.buttonExit.m_6305_(matrices, int_1, int_2, float_1);
    }

    private static class StringEntryListWidget
    extends DynamicErrorFreeEntryListWidget<StringItem> {
        private boolean inFocus;
        private int max = 80;

        public StringEntryListWidget(Minecraft client, int width, int height, int startY, int endY) {
            super(client, width, height, startY, endY, GuiComponent.f_93096_);
        }

        public boolean m_5755_(boolean boolean_1) {
            if (!this.inFocus && this.getItemCount() == 0) {
                return false;
            }
            boolean bl = this.inFocus = !this.inFocus;
            if (this.inFocus && this.getFocused() == null && this.getItemCount() > 0) {
                this.moveSelection(1);
            } else if (this.inFocus && this.getFocused() != null) {
                this.moveSelection(0);
            }
            return this.inFocus;
        }

        public void creditsClearEntries() {
            this.clearItems();
        }

        private StringItem rei_getEntry(int int_1) {
            return (StringItem)((Object)this.m_6702_().get(int_1));
        }

        public void creditsAddEntry(StringItem entry) {
            this.addItem(entry);
        }

        @Override
        public int getItemWidth() {
            return this.max;
        }

        @Override
        protected int getScrollbarPosition() {
            return this.width - 40;
        }
    }

    private static class TextItem
    extends StringItem {
        private FormattedCharSequence text;

        public TextItem(FormattedCharSequence text) {
            this.text = text;
        }

        @Override
        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            Minecraft.m_91087_().f_91062_.m_92744_(matrices, this.text, (float)(x + 5), (float)y, -1);
        }

        @Override
        public int getItemHeight() {
            return 12;
        }

        public boolean m_5755_(boolean boolean_1) {
            return false;
        }

        @Override
        public int getWidth() {
            return Minecraft.m_91087_().f_91062_.m_92724_(this.text) + 10;
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput narrationElementOutput) {
                    StringBuilder builder = new StringBuilder();
                    text.m_13731_((i, style, j) -> {
                        builder.append(Character.toChars(j));
                        return false;
                    });
                    narrationElementOutput.m_169143_(NarratedElementType.TITLE, builder.toString());
                }
            });
        }
    }

    private static abstract class StringItem
    extends DynamicErrorFreeEntryListWidget.Entry<StringItem> {
        private StringItem() {
        }

        public abstract int getWidth();
    }

    private class LinkItem
    extends StringItem {
        private FormattedCharSequence text;
        private String link;
        private boolean contains;

        public LinkItem(FormattedCharSequence text, String link) {
            this.text = text;
            this.link = link;
        }

        @Override
        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            boolean bl = this.contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (this.contains) {
                WarningAndErrorScreen.this.m_96602_(matrices, (Component)Component.m_237113_((String)"Click to open link."), mouseX, mouseY);
                Minecraft.m_91087_().f_91062_.m_92744_(matrices, characterVisitor -> this.text.m_13731_((charIndex, style, codePoint) -> characterVisitor.m_6411_(charIndex, style.m_131157_(ChatFormatting.UNDERLINE), codePoint)), (float)(x + 5), (float)y, -14695425);
            } else {
                Minecraft.m_91087_().f_91062_.m_92744_(matrices, this.text, (float)(x + 5), (float)y, -14695425);
            }
        }

        @Override
        public int getItemHeight() {
            return 12;
        }

        public boolean m_5755_(boolean boolean_1) {
            return false;
        }

        @Override
        public int getWidth() {
            return Minecraft.m_91087_().f_91062_.m_92724_(this.text) + 10;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.contains && button == 0) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                try {
                    Util.m_137581_().m_137648_(new URI(this.link));
                    return true;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput narrationElementOutput) {
                    StringBuilder builder = new StringBuilder();
                    LinkItem.this.text.m_13731_((i, style, j) -> {
                        builder.append(Character.toChars(j));
                        return false;
                    });
                    narrationElementOutput.m_169143_(NarratedElementType.TITLE, builder.toString());
                }
            });
        }
    }

    private static class EmptyItem
    extends StringItem {
        private EmptyItem() {
        }

        @Override
        public void render(PoseStack matrixStack, int i, int i1, int i2, int i3, int i4, int i5, int i6, boolean b, float v) {
        }

        @Override
        public int getItemHeight() {
            return 5;
        }

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }
}

