/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.mixin.forge;

import com.google.common.base.Stopwatch;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.plugin.common.displays.tag.TagNodes;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagLoader;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TagLoader.class})
public class MixinTagLoader<T> {
    @Shadow
    @Final
    private String f_13449_;

    @Inject(method={"build(Ljava/util/Map;)Ljava/util/Map;"}, at={@At(value="HEAD")})
    private void load(Map<ResourceLocation, TagLoader.EntryWithSource> map, CallbackInfoReturnable<Map<ResourceLocation, Collection<T>>> cir) {
        TagNodes.RAW_TAG_DATA_MAP.put(this.f_13449_, new HashMap());
        TagNodes.CURRENT_TAG_DIR.set(this.f_13449_);
    }

    @Inject(method={"build(Ljava/util/Map;)Ljava/util/Map;"}, at={@At(value="RETURN")})
    private void loadPost(Map<ResourceLocation, TagLoader.EntryWithSource> map, CallbackInfoReturnable<Map<ResourceLocation, Collection<T>>> cir) {
        HashMap inverseMap = new HashMap(((Map)cir.getReturnValue()).size());
        for (Map.Entry entry : ((Map)cir.getReturnValue()).entrySet()) {
            inverseMap.put(new TagNodes.CollectionWrapper((Collection)entry.getValue()), (ResourceLocation)entry.getKey());
        }
        ResourceKey<? extends Registry<?>> resourceKey = TagNodes.TAG_DIR_MAP.get(this.f_13449_);
        if (resourceKey == null) {
            return;
        }
        TagNodes.TAG_DATA_MAP.put(resourceKey, new HashMap());
        Map<ResourceLocation, TagNodes.TagData> tagDataMap = TagNodes.TAG_DATA_MAP.get(resourceKey);
        if (tagDataMap == null) {
            return;
        }
        Registry registry = (Registry)Registry.f_122897_.m_6246_(resourceKey);
        Stopwatch stopwatch = Stopwatch.createStarted();
        Iterator entryIterator = ((Map)TagNodes.RAW_TAG_DATA_MAP.getOrDefault(this.f_13449_, (Map<TagNodes.CollectionWrapper<?>, TagNodes.RawTagData>)Reference2ObjectMaps.emptyMap())).entrySet().iterator();
        if (!entryIterator.hasNext()) {
            return;
        }
        while (entryIterator.hasNext()) {
            ResourceLocation tagLoc;
            Map.Entry entry = entryIterator.next();
            TagNodes.CollectionWrapper tag = (TagNodes.CollectionWrapper)entry.getKey();
            entryIterator.remove();
            if (registry == null || (tagLoc = (ResourceLocation)inverseMap.get(tag)) == null) continue;
            TagNodes.RawTagData rawTagData = (TagNodes.RawTagData)entry.getValue();
            IntArrayList elements = new IntArrayList();
            for (ResourceLocation element : rawTagData.otherElements()) {
                Object t = registry.m_7745_(element);
                if (t == null) continue;
                elements.add(registry.m_7447_(t));
            }
            tagDataMap.put(tagLoc, new TagNodes.TagData((IntList)elements, rawTagData.otherTags()));
        }
        InternalLogger.getInstance().debug("Processed %d tags in %s for %s", tagDataMap.size(), stopwatch.stop(), resourceKey.m_135782_());
    }

    @Inject(method={"build(Lnet/minecraft/tags/TagEntry$Lookup;Ljava/util/List;)Lcom/mojang/datafixers/util/Either;"}, at={@At(value="RETURN")})
    private void load(TagEntry.Lookup<T> lookup, List<TagLoader.EntryWithSource> entries, CallbackInfoReturnable<Either<Collection<TagLoader.EntryWithSource>, Collection<T>>> cir) {
        Collection tag = ((Either)cir.getReturnValue()).right().orElse(null);
        if (tag != null) {
            String currentTagDirectory = TagNodes.CURRENT_TAG_DIR.get();
            if (currentTagDirectory == null) {
                return;
            }
            ResourceKey<? extends Registry<?>> resourceKey = TagNodes.TAG_DIR_MAP.get(currentTagDirectory);
            if (resourceKey == null) {
                return;
            }
            Map<TagNodes.CollectionWrapper<?>, TagNodes.RawTagData> dataMap = TagNodes.RAW_TAG_DATA_MAP.get(currentTagDirectory);
            if (dataMap == null) {
                return;
            }
            ArrayList<ResourceLocation> otherElements = new ArrayList<ResourceLocation>();
            ArrayList<ResourceLocation> otherTags = new ArrayList<ResourceLocation>();
            for (TagLoader.EntryWithSource builderEntry : entries) {
                Object apply;
                TagEntry entry = builderEntry.f_216042_();
                if (entry.f_215914_) {
                    apply = lookup.m_214048_(entry.getId());
                    if (apply == null) continue;
                    otherTags.add(entry.getId());
                    continue;
                }
                apply = lookup.m_213619_(entry.getId());
                if (apply == null) continue;
                otherElements.add(entry.getId());
            }
            dataMap.put(new TagNodes.CollectionWrapper(tag), new TagNodes.RawTagData(CollectionUtils.distinctToList(otherElements), CollectionUtils.distinctToList(otherTags)));
        }
    }
}

