/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.autocrafting;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.MenuTransferException;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultCategoryHandler
implements TransferHandler {
    @Override
    public TransferHandler.Result handle(TransferHandler.Context context) {
        Display display = context.getDisplay();
        AbstractContainerScreen<?> containerScreen = context.getContainerScreen();
        if (containerScreen == null) {
            return TransferHandler.Result.createNotApplicable();
        }
        AbstractContainerMenu menu = context.getMenu();
        MenuInfoContext<AbstractContainerMenu, Player, Display> menuInfoContext = DefaultCategoryHandler.ofContext(menu, display);
        MenuInfo<AbstractContainerMenu, Display> menuInfo = MenuInfoRegistry.getInstance().getClient(display, menuInfoContext, menu);
        if (menuInfo == null) {
            return TransferHandler.Result.createNotApplicable();
        }
        try {
            menuInfo.validate(menuInfoContext);
        }
        catch (MenuTransferException e) {
            if (e.isApplicable()) {
                return TransferHandler.Result.createFailed(e.getError());
            }
            return TransferHandler.Result.createNotApplicable();
        }
        List<InputIngredient<ItemStack>> input = menuInfo.getInputsIndexed(menuInfoContext, false);
        List<InputIngredient<ItemStack>> missing = this.hasItemsIndexed(menuInfoContext, menu, menuInfo, display, input);
        if (!missing.isEmpty()) {
            IntArrayList missingIndices = new IntArrayList(missing.size());
            for (InputIngredient<ItemStack> ingredient2 : missing) {
                missingIndices.add(ingredient2.getIndex());
            }
            IntLinkedOpenHashSet missingIndicesSet = new IntLinkedOpenHashSet((IntCollection)missingIndices);
            List<List> oldInputs = CollectionUtils.map(input, InputIngredient::get);
            return TransferHandler.Result.createFailed((Component)Component.m_237115_((String)"error.rei.not.enough.materials")).renderer((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> DefaultCategoryHandler.lambda$handle$0(menuInfo, menuInfoContext, oldInputs, (IntList)missingIndices, input, missing, (IntSet)missingIndicesSet, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6)).tooltipMissing(CollectionUtils.map(missing, ingredient -> EntryIngredients.ofItemStacks(ingredient.get())));
        }
        if (!ClientHelper.getInstance().canUseMovePackets()) {
            return TransferHandler.Result.createFailed((Component)Component.m_237115_((String)"error.rei.not.on.server"));
        }
        if (!context.isActuallyCrafting()) {
            return TransferHandler.Result.createSuccessful();
        }
        context.getMinecraft().m_91152_(containerScreen);
        if (containerScreen instanceof RecipeUpdateListener) {
            RecipeUpdateListener listener = (RecipeUpdateListener)containerScreen;
            listener.m_5564_().f_100269_.m_100140_();
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130085_(display.getCategoryIdentifier().getIdentifier());
        buf.writeBoolean(context.isStackedCrafting());
        buf.m_130079_(menuInfo.save(menuInfoContext, display));
        NetworkManager.sendToServer((ResourceLocation)RoughlyEnoughItemsNetwork.MOVE_ITEMS_PACKET, (FriendlyByteBuf)buf);
        return TransferHandler.Result.createSuccessful();
    }

    @Override
    public double getPriority() {
        return -10.0;
    }

    private static MenuInfoContext<AbstractContainerMenu, Player, Display> ofContext(final AbstractContainerMenu menu, final Display display) {
        return new MenuInfoContext<AbstractContainerMenu, Player, Display>(){

            @Override
            public AbstractContainerMenu getMenu() {
                return menu;
            }

            @Override
            public Player getPlayerEntity() {
                return Minecraft.m_91087_().f_91074_;
            }

            @Override
            public CategoryIdentifier<Display> getCategoryIdentifier() {
                return display.getCategoryIdentifier();
            }

            @Override
            public Display getDisplay() {
                return display;
            }
        };
    }

    public IntList hasItems(MenuInfoContext<AbstractContainerMenu, Player, Display> menuInfoContext, AbstractContainerMenu menu, MenuInfo<AbstractContainerMenu, Display> info, Display display, List<List<ItemStack>> inputs) {
        List<InputIngredient<ItemStack>> missing = this.hasItemsIndexed(menuInfoContext, menu, info, display, CollectionUtils.mapIndexed(inputs, InputIngredient::of));
        IntArrayList ids = new IntArrayList(missing.size());
        for (InputIngredient<ItemStack> ingredient : missing) {
            ids.add(ingredient.getIndex());
        }
        return ids;
    }

    public List<InputIngredient<ItemStack>> hasItemsIndexed(MenuInfoContext<AbstractContainerMenu, Player, Display> menuInfoContext, AbstractContainerMenu menu, MenuInfo<AbstractContainerMenu, Display> info, Display display, List<InputIngredient<ItemStack>> inputs) {
        RecipeFinder recipeFinder = new RecipeFinder();
        info.getRecipeFinderPopulator().populate(menuInfoContext, recipeFinder);
        ArrayList<InputIngredient<ItemStack>> missing = new ArrayList<InputIngredient<ItemStack>>();
        for (InputIngredient<ItemStack> possibleStacks : inputs) {
            boolean done = possibleStacks.get().isEmpty();
            for (ItemStack possibleStack : possibleStacks.get()) {
                int invRequiredCount;
                if (done) continue;
                int key = RecipeFinder.getItemId(possibleStack);
                for (invRequiredCount = possibleStack.m_41613_(); invRequiredCount > 0 && recipeFinder.contains(key); --invRequiredCount) {
                    recipeFinder.take(key, 1);
                }
                if (invRequiredCount > 0) continue;
                done = true;
                break;
            }
            if (done) continue;
            missing.add(possibleStacks);
        }
        return missing;
    }

    private static /* synthetic */ void lambda$handle$0(MenuInfo menuInfo, MenuInfoContext menuInfoContext, List oldInputs, IntList missingIndices, List input, List missing, IntSet missingIndicesSet, PoseStack matrices, int mouseX, int mouseY, float delta, List widgets, Rectangle bounds, Display d) {
        menuInfo.renderMissingInput(menuInfoContext, oldInputs, missingIndices, matrices, mouseX, mouseY, delta, widgets, bounds);
        menuInfo.renderMissingInput(menuInfoContext, input, missing, missingIndicesSet, matrices, mouseX, mouseY, delta, widgets, bounds);
    }
}

